import { ncHasProperties, ncIsObject } from '../../../../lib/is';
import AbstractColumnHelper from '../../column.interface';
import { SilentTypeConversionError } from '../../../../lib/error';
import { LookupHelper } from '../Lookup';
export class BelongsToHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!ncHasProperties(parsedVal, ['fk_related_model_id', 'value']) ||
            !ncIsObject(parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.value) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        return JSON.stringify({
            fk_related_model_id: params.col.colOptions
                .fk_related_model_id,
            value: value || null,
        });
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = new LookupHelper().parsePlainCellValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmVsb25nc1RvLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9MVEFSL0JlbG9uZ3NUby50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsZUFBZSxFQUFFLFVBQVUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUN2RCxPQUFPLG9CQUVOLE1BQU0sd0JBQXdCLENBQUM7QUFFaEMsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0sYUFBYSxDQUFDO0FBQ3hELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFFekMsTUFBTSxPQUFPLGVBQWdCLFNBQVEsb0JBQW9CO0lBQXpEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQXNDekIsQ0FBQztJQXBDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxJQUFJLFNBQVMsR0FBRyxLQUFLLENBQUM7UUFFdEIsSUFBSSxDQUFDO1lBQ0gsU0FBUyxHQUFHLE9BQU8sS0FBSyxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDO1FBQ3BFLENBQUM7UUFBQyxXQUFNLENBQUMsQ0FBQSxDQUFDO1FBRVYsSUFDRSxDQUFDLGVBQWUsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxxQkFBcUIsRUFBRSxPQUFPLENBQUMsQ0FBQztZQUM3RCxDQUFDLFVBQVUsQ0FBQyxTQUFTLGFBQVQsU0FBUyx1QkFBVCxTQUFTLENBQUUsS0FBSyxDQUFDO1lBQzdCLENBQUMsU0FBaUMsYUFBakMsU0FBUyx1QkFBVCxTQUFTLENBQTBCLG1CQUFtQjtpQkFDckQsTUFBQyxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQXNDLDBDQUFFLG1CQUFtQixDQUFBLEVBQ3pFLENBQUM7WUFDRCxNQUFNLElBQUkseUJBQXlCLEVBQUUsQ0FBQztRQUN4QyxDQUFDO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQztJQUVELFVBQVUsQ0FBQyxLQUFVLEVBQUUsTUFBMkM7UUFDaEUsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ3BCLG1CQUFtQixFQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBc0M7aUJBQ3BFLG1CQUFtQjtZQUN0QixLQUFLLEVBQUUsS0FBSyxJQUFJLElBQUk7U0FDckIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLE9BQU8sTUFBQSxJQUFJLFlBQVksRUFBRSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsbUNBQUksRUFBRSxDQUFDO0lBQ3JFLENBQUM7Q0FDRiJ9