import { SilentTypeConversionError } from '../../../../lib/error';
import AbstractColumnHelper from '../../column.interface';
import { ncHasProperties } from '../../../../lib/is';
import { isMm } from '../../utils';
import { LookupHelper } from '../Lookup';
export class ManyToManyHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        if (!isMm(params.col))
            throw new SilentTypeConversionError();
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!ncHasProperties(parsedVal, [
            'rowId',
            'columnId',
            'fk_related_model_id',
            'value',
        ]) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        return JSON.stringify({
            rowId: params.rowId,
            columnId: params.col.id,
            fk_related_model_id: params.col.colOptions
                .fk_related_model_id,
            value,
        });
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = new LookupHelper().parsePlainCellValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWFueVRvTWFueS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvTFRBUi9NYW55VG9NYW55LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSx5QkFBeUIsRUFBRSxNQUFNLGFBQWEsQ0FBQztBQUN4RCxPQUFPLG9CQUVOLE1BQU0sd0JBQXdCLENBQUM7QUFFaEMsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUMzQyxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sYUFBYSxDQUFDO0FBQ25DLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFFekMsTUFBTSxPQUFPLGdCQUFpQixTQUFRLG9CQUFvQjtJQUExRDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUEyQ3pCLENBQUM7SUF6Q0MsY0FBYyxDQUFDLEtBQVUsRUFBRSxNQUEyQzs7UUFDcEUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDO1lBQUUsTUFBTSxJQUFJLHlCQUF5QixFQUFFLENBQUM7UUFFN0QsSUFBSSxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBRXRCLElBQUksQ0FBQztZQUNILFNBQVMsR0FBRyxPQUFPLEtBQUssS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztRQUNwRSxDQUFDO1FBQUMsV0FBTSxDQUFDLENBQUEsQ0FBQztRQUVWLElBQ0UsQ0FBQyxlQUFlLENBQUMsU0FBUyxFQUFFO1lBQzFCLE9BQU87WUFDUCxVQUFVO1lBQ1YscUJBQXFCO1lBQ3JCLE9BQU87U0FDUixDQUFDO1lBQ0YsQ0FBQyxTQUFpQyxhQUFqQyxTQUFTLHVCQUFULFNBQVMsQ0FBMEIsbUJBQW1CO2lCQUNyRCxNQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBc0MsMENBQUUsbUJBQW1CLENBQUEsRUFDekUsQ0FBQztZQUNELE1BQU0sSUFBSSx5QkFBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVUsRUFBRSxNQUEyQztRQUNoRSxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDcEIsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFFBQVEsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDdkIsbUJBQW1CLEVBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxVQUFzQztpQkFDcEUsbUJBQW1CO1lBQ3RCLEtBQUs7U0FDTixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsT0FBTyxNQUFBLElBQUksWUFBWSxFQUFFLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDckUsQ0FBQztDQUNGIn0=