import { SilentTypeConversionError } from '../../../lib/error';
import AbstractColumnHelper from '../column.interface';
import { isBt, isMm, isOo, parseLinksValue } from '../utils';
import { ncIsNaN, ncIsObject } from '../../../lib/is';
export class LinksHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        var _a;
        if (params.serializeSearchQuery)
            return null;
        if (!isMm(params.col))
            throw new SilentTypeConversionError();
        let parsedVal = value;
        try {
            parsedVal = typeof value === 'string' ? JSON.parse(value) : value;
        }
        catch (_b) { }
        if (!(parsedVal &&
            ncIsObject(parsedVal) &&
            ['rowId', 'columnId', 'fk_related_model_id', 'value'].every((key) => parsedVal.hasOwnProperty(key))) ||
            (parsedVal === null || parsedVal === void 0 ? void 0 : parsedVal.fk_related_model_id) !==
                ((_a = params.col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_model_id)) {
            throw new SilentTypeConversionError();
        }
        return parsedVal;
    }
    parseValue(value, params) {
        if (isMm(params.col)) {
            return JSON.stringify({
                rowId: params.rowId,
                columnId: params.col.id,
                fk_related_model_id: params.col.colOptions
                    .fk_related_model_id,
                value: !ncIsNaN(value) ? +value : 0,
            });
        }
        else if (isBt(params.col) || isOo(params.col)) {
            // fk_related_model_id is used to prevent paste operation in different fk_related_model_id cell
            return JSON.stringify({
                fk_related_model_id: params.col.colOptions
                    .fk_related_model_id,
                value: value || null,
            });
        }
        return value !== null && value !== void 0 ? value : '';
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = parseLinksValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTGlua3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL0xpbmtzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSx5QkFBeUIsRUFBRSxNQUFNLGFBQWEsQ0FBQztBQUN4RCxPQUFPLG9CQUVOLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLGVBQWUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUM3RCxPQUFPLEVBQUUsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUcvQyxNQUFNLE9BQU8sV0FBWSxTQUFRLG9CQUFvQjtJQUFyRDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUE0RHpCLENBQUM7SUExREMsY0FBYyxDQUNaLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsSUFBSSxNQUFNLENBQUMsb0JBQW9CO1lBQUUsT0FBTyxJQUFJLENBQUM7UUFFN0MsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDO1lBQUUsTUFBTSxJQUFJLHlCQUF5QixFQUFFLENBQUM7UUFFN0QsSUFBSSxTQUFTLEdBQUcsS0FBSyxDQUFDO1FBRXRCLElBQUksQ0FBQztZQUNILFNBQVMsR0FBRyxPQUFPLEtBQUssS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztRQUNwRSxDQUFDO1FBQUMsV0FBTSxDQUFDLENBQUEsQ0FBQztRQUVWLElBQ0UsQ0FBQyxDQUNDLFNBQVM7WUFDVCxVQUFVLENBQUMsU0FBUyxDQUFDO1lBQ3JCLENBQUMsT0FBTyxFQUFFLFVBQVUsRUFBRSxxQkFBcUIsRUFBRSxPQUFPLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNqRSxTQUFvQixDQUFDLGNBQWMsQ0FBQyxHQUFHLENBQUMsQ0FDMUMsQ0FDRjtZQUNELENBQUMsU0FBaUMsYUFBakMsU0FBUyx1QkFBVCxTQUFTLENBQTBCLG1CQUFtQjtpQkFDckQsTUFBQyxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQXNDLDBDQUFFLG1CQUFtQixDQUFBLEVBQ3pFLENBQUM7WUFDRCxNQUFNLElBQUkseUJBQXlCLEVBQUUsQ0FBQztRQUN4QyxDQUFDO1FBRUQsT0FBTyxTQUFTLENBQUM7SUFDbkIsQ0FBQztJQUVELFVBQVUsQ0FBQyxLQUFVLEVBQUUsTUFBMkM7UUFDaEUsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7WUFDckIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNwQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7Z0JBQ25CLFFBQVEsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQ3ZCLG1CQUFtQixFQUFHLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBc0M7cUJBQ3BFLG1CQUFtQjtnQkFDdEIsS0FBSyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUNwQyxDQUFDLENBQUM7UUFDTCxDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUNoRCwrRkFBK0Y7WUFDL0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNwQixtQkFBbUIsRUFBRyxNQUFNLENBQUMsR0FBRyxDQUFDLFVBQXNDO3FCQUNwRSxtQkFBbUI7Z0JBQ3RCLEtBQUssRUFBRSxLQUFLLElBQUksSUFBSTthQUNyQixDQUFDLENBQUM7UUFDTCxDQUFDO1FBRUQsT0FBTyxLQUFLLGFBQUwsS0FBSyxjQUFMLEtBQUssR0FBSSxFQUFFLENBQUM7SUFDckIsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBK0Q7O1FBRS9ELE9BQU8sTUFBQSxlQUFlLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDOUMsQ0FBQztDQUNGIn0=