import { LongTextAiMetaProp } from '../../../lib/globals';
import { parseProp } from '../../../lib/helperFunctions';
import { ncIsObject } from '../../../lib/is';
import AbstractColumnHelper from '../column.interface';
import { serializeStringValue } from '../utils';
export class LongTextHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value) {
        // This is to remove the quotes added from LongText
        return serializeStringValue(value);
    }
    parseValue(value, params) {
        var _a;
        const columnMeta = parseProp(params.col.meta);
        if (columnMeta[LongTextAiMetaProp]) {
            if (ncIsObject(value)) {
                return (_a = value === null || value === void 0 ? void 0 : value.value) !== null && _a !== void 0 ? _a : null;
            }
        }
        if (!value)
            return null;
        return `"${value.replace(/"/g, '\\"')}"`;
    }
    parsePlainCellValue(value, params) {
        var _a, _b;
        return (_b = (_a = this.parseValue(value, params)) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTG9uZ1RleHQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL0xvbmdUZXh0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUNuRCxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFDbEQsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUN0QyxPQUFPLG9CQUVOLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLG9CQUFvQixFQUFFLE1BQU0sVUFBVSxDQUFDO0FBRWhELE1BQU0sT0FBTyxjQUFlLFNBQVEsb0JBQW9CO0lBQXhEOztRQUNFLHNCQUFpQixHQUFHLEVBQUUsQ0FBQztJQThCekIsQ0FBQztJQTVCUSxjQUFjLENBQUMsS0FBVTtRQUM5QixtREFBbUQ7UUFDbkQsT0FBTyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsTUFBTSxVQUFVLEdBQUcsU0FBUyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFOUMsSUFBSSxVQUFVLENBQUMsa0JBQWtCLENBQUMsRUFBRSxDQUFDO1lBQ25DLElBQUksVUFBVSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7Z0JBQ3RCLE9BQU8sTUFBQyxLQUFzQixhQUF0QixLQUFLLHVCQUFMLEtBQUssQ0FBbUIsS0FBSyxtQ0FBSSxJQUFJLENBQUM7WUFDaEQsQ0FBQztRQUNILENBQUM7UUFFRCxJQUFJLENBQUMsS0FBSztZQUFFLE9BQU8sSUFBSSxDQUFDO1FBRXhCLE9BQU8sSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDO0lBQzNDLENBQUM7SUFFRCxtQkFBbUIsQ0FDakIsS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxPQUFPLE1BQUEsTUFBQSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsMENBQUUsUUFBUSxFQUFFLG1DQUFJLEVBQUUsQ0FBQztJQUMxRCxDQUFDO0NBQ0YifQ==