import AbstractColumnHelper from '../column.interface';
import { ncIsArray } from '../../../lib/is';
import { ColumnHelper } from '../column-helper';
import { ComputedTypePasteError } from '../../../lib/error';
import { getMetaWithCompositeKey } from '../../../lib/helpers/metaHelpers';
import rfdc from 'rfdc';
const clone = rfdc();
export class LookupHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return this.parseValue(value, params);
        }
        if (params.isMultipleCellPaste) {
            return undefined;
        }
        else {
            throw new ComputedTypePasteError();
        }
    }
    parseValue(value, params) {
        var _a, _b;
        if (!value)
            return null;
        const { col, meta, metas } = params;
        const baseId = meta === null || meta === void 0 ? void 0 : meta.base_id;
        const colOptions = col.colOptions;
        const relationColumnOptions = colOptions.fk_relation_column_id
            ? (_b = (_a = meta === null || meta === void 0 ? void 0 : meta.columns) === null || _a === void 0 ? void 0 : _a.find((c) => c.id === colOptions.fk_relation_column_id)) === null || _b === void 0 ? void 0 : _b.colOptions
            : null;
        const relatedBaseId = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_base_id) || baseId;
        const relatedTableMeta = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_model_id) &&
            getMetaWithCompositeKey(metas, relatedBaseId, relationColumnOptions.fk_related_model_id);
        let childColumn = relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns.find((c) => c.id === colOptions.fk_lookup_column_id);
        if (!childColumn)
            return value;
        childColumn = clone(childColumn);
        if (ncIsArray(value)) {
            return value
                .map((v) => {
                return ColumnHelper.parseValue(v, Object.assign(Object.assign({}, params), { col: childColumn }));
            })
                .join(', ');
        }
        return ColumnHelper.parseValue(value, Object.assign(Object.assign({}, params), { col: childColumn }));
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,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