import { SilentTypeConversionError } from '../../../lib/error';
import { parseProp } from '../../../lib/helperFunctions';
import { parseIntValue, serializeIntValue } from '..';
import AbstractColumnHelper from '../column.interface';
import { ncIsNaN } from '../../../lib/is';
export class RatingHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            iconIdx: 0,
            icon: {
                full: 'mdi-star',
                empty: 'mdi-star-outline',
            },
            color: '#fcb401',
            max: 5,
        };
        // simply copy highlighted rows
        // since rating doesn't need increment
        // override populateFillHandle
    }
    serializeValue(value, params) {
        var _a;
        const res = serializeIntValue(value !== null && value !== void 0 ? value : 0);
        if (res === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new SilentTypeConversionError();
            }
        }
        if (res) {
            if (params.serializeSearchQuery) {
                return res;
            }
            return Math.min(res, ((_a = parseProp(params.col.meta)) === null || _a === void 0 ? void 0 : _a.max) || this.columnDefaultMeta.max);
        }
        return res;
    }
    parseValue(value) {
        return parseIntValue(value);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && ncIsNaN(value)) {
            value = 0;
        }
        return `${(_a = parseIntValue(value, params.col)) !== null && _a !== void 0 ? _a : ''}`;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUmF0aW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9SYXRpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0sYUFBYSxDQUFDO0FBQ3hELE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQztBQUNsRCxPQUFPLEVBQUUsYUFBYSxFQUFFLGlCQUFpQixFQUFFLE1BQU0sSUFBSSxDQUFDO0FBQ3RELE9BQU8sb0JBRU4sTUFBTSxxQkFBcUIsQ0FBQztBQUM3QixPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sVUFBVSxDQUFDO0FBRW5DLE1BQU0sT0FBTyxZQUFhLFNBQVEsb0JBQW9CO0lBQXREOztRQUNFLHNCQUFpQixHQUFHO1lBQ2xCLE9BQU8sRUFBRSxDQUFDO1lBQ1YsSUFBSSxFQUFFO2dCQUNKLElBQUksRUFBRSxVQUFVO2dCQUNoQixLQUFLLEVBQUUsa0JBQWtCO2FBQzFCO1lBQ0QsS0FBSyxFQUFFLFNBQVM7WUFDaEIsR0FBRyxFQUFFLENBQUM7U0FDUCxDQUFDO1FBNkNGLCtCQUErQjtRQUMvQixzQ0FBc0M7UUFDdEMsOEJBQThCO0lBQ2hDLENBQUM7SUE5Q0MsY0FBYyxDQUNaLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsTUFBTSxHQUFHLEdBQUcsaUJBQWlCLENBQUMsS0FBSyxhQUFMLEtBQUssY0FBTCxLQUFLLEdBQUksQ0FBQyxDQUFDLENBQUM7UUFFMUMsSUFBSSxHQUFHLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDakIsSUFBSSxNQUFNLENBQUMsbUJBQW1CLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQzlELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sSUFBSSx5QkFBeUIsRUFBRSxDQUFDO1lBQ3hDLENBQUM7UUFDSCxDQUFDO1FBRUQsSUFBSSxHQUFHLEVBQUUsQ0FBQztZQUNSLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQ2hDLE9BQU8sR0FBRyxDQUFDO1lBQ2IsQ0FBQztZQUVELE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FDYixHQUFHLEVBQ0gsQ0FBQSxNQUFBLFNBQVMsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQywwQ0FBRSxHQUFHLEtBQUksSUFBSSxDQUFDLGlCQUFpQixDQUFDLEdBQUcsQ0FDOUQsQ0FBQztRQUNKLENBQUM7UUFFRCxPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTtRQUNuQixPQUFPLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsSUFBSSxNQUFNLENBQUMsYUFBYSxJQUFJLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQzNDLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDWixDQUFDO1FBRUQsT0FBTyxHQUFHLE1BQUEsYUFBYSxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQ3JELENBQUM7Q0FLRiJ9