import AbstractColumnHelper from '../column.interface';
import { ColumnHelper } from '../column-helper';
import { getMetaWithCompositeKey } from '../../../lib/helpers/metaHelpers';
import { getRenderAsTextFunForUiType, parseProp } from '../../../lib/helperFunctions';
import UITypes from '../../../lib/UITypes';
import { ComputedTypePasteError } from '../../../lib/error';
import { precisionFormats } from '../utils';
import { isValidValue } from '../../../lib/is';
import rfdc from 'rfdc';
const clone = rfdc();
export class RollupHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            precision: precisionFormats[0],
            isLocaleString: false,
        };
    }
    serializeValue(_value, params) {
        if (params.isMultipleCellPaste || params.serializeSearchQuery) {
            return undefined;
        }
        else {
            throw new ComputedTypePasteError();
        }
    }
    parseValue(value, params) {
        var _a, _b, _c;
        if (!isValidValue(value))
            return null;
        const { col, meta, metas } = params;
        const baseId = meta === null || meta === void 0 ? void 0 : meta.base_id;
        const colOptions = col.colOptions;
        const relationColumnOptions = colOptions.fk_relation_column_id
            ? (_b = (_a = meta === null || meta === void 0 ? void 0 : meta.columns) === null || _a === void 0 ? void 0 : _a.find((c) => c.id === colOptions.fk_relation_column_id)) === null || _b === void 0 ? void 0 : _b.colOptions
            : null;
        const relatedTableMeta = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_model_id) &&
            getMetaWithCompositeKey(metas, baseId, relationColumnOptions.fk_related_model_id);
        let childColumn = relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns.find((c) => c.id === colOptions.fk_rollup_column_id);
        if (!childColumn)
            return value;
        childColumn = clone(childColumn);
        const renderAsTextFun = getRenderAsTextFunForUiType(((_c = childColumn.uidt) !== null && _c !== void 0 ? _c : UITypes.SingleLineText));
        childColumn.meta = Object.assign(Object.assign({}, parseProp(childColumn === null || childColumn === void 0 ? void 0 : childColumn.meta)), parseProp(col === null || col === void 0 ? void 0 : col.meta));
        if (renderAsTextFun.includes(colOptions.rollup_function)) {
            childColumn.uidt = UITypes.Decimal;
        }
        return ColumnHelper.parseValue(value, Object.assign(Object.assign({}, params), { col: childColumn }));
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
export const rollupAllFunctions = [
    { text: 'datatype.Count', value: 'count' },
    { text: 'general.min', value: 'min' },
    { text: 'general.max', value: 'max' },
    { text: 'general.avg', value: 'avg' },
    { text: 'general.sum', value: 'sum' },
    { text: 'general.countDistinct', value: 'countDistinct' },
    { text: 'general.sumDistinct', value: 'sumDistinct' },
    { text: 'general.avgDistinct', value: 'avgDistinct' },
];
//# sourceMappingURL=data:application/json;base64,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