import AbstractColumnHelper from '../column.interface';
import { serializeStringValue } from '../utils';
import { populateFillHandleStringNumber } from '../utils/fill-handler';
export class SingleLineTextHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, _params) {
        return serializeStringValue(value);
    }
    parseValue(value, _params) {
        if (value === null || value === undefined) {
            return '';
        }
        return value.toString();
    }
    parsePlainCellValue(value, _params) {
        var _a;
        return (_a = value === null || value === void 0 ? void 0 : value.toString()) !== null && _a !== void 0 ? _a : '';
    }
    // using string number fill handler
    populateFillHandle(params) {
        return populateFillHandleStringNumber(params);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2luZ2xlTGluZVRleHQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL1NpbmdsZUxpbmVUZXh0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sb0JBRU4sTUFBTSxxQkFBcUIsQ0FBQztBQUM3QixPQUFPLEVBQUUsb0JBQW9CLEVBQUUsTUFBTSxVQUFVLENBQUM7QUFDaEQsT0FBTyxFQUFFLDhCQUE4QixFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFFdkUsTUFBTSxPQUFPLG9CQUFxQixTQUFRLG9CQUFvQjtJQUE5RDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUErQnpCLENBQUM7SUE3QkMsY0FBYyxDQUNaLEtBQVUsRUFDVixPQUE0QztRQUU1QyxPQUFPLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVSxFQUFFLE9BQTRDO1FBQ2pFLElBQUksS0FBSyxLQUFLLElBQUksSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFLENBQUM7WUFDMUMsT0FBTyxFQUFFLENBQUM7UUFDWixDQUFDO1FBQ0QsT0FBTyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDMUIsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsT0FBNEM7O1FBRTVDLE9BQU8sTUFBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsUUFBUSxFQUFFLG1DQUFJLEVBQUUsQ0FBQztJQUNqQyxDQUFDO0lBRUQsbUNBQW1DO0lBQzFCLGtCQUFrQixDQUFDLE1BSTNCO1FBQ0MsT0FBTyw4QkFBOEIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUNoRCxDQUFDO0NBQ0YifQ==