import { ncIsArray } from '../../../lib/is';
import AbstractColumnHelper from '../column.interface';
import { serializeSelectValue, serializeStringValue } from '../utils';
export class SingleSelectHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return serializeStringValue(value);
        }
        return serializeSelectValue(value, params.col);
    }
    parseValue(value) {
        var _a, _b;
        if (!value)
            return null;
        if (ncIsArray(value) && value.length) {
            return (_a = value[0]) === null || _a === void 0 ? void 0 : _a.toString().trim();
        }
        return (_b = value === null || value === void 0 ? void 0 : value.toString().trim()) !== null && _b !== void 0 ? _b : null;
    }
    parsePlainCellValue(value) {
        var _a;
        return (_a = this.parseValue(value)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2luZ2xlU2VsZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvY29sdW1ucy9TaW5nbGVTZWxlY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUNyQyxPQUFPLG9CQUVOLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLE1BQU0sVUFBVSxDQUFDO0FBRXRFLE1BQU0sT0FBTyxrQkFBbUIsU0FBUSxvQkFBb0I7SUFBNUQ7O1FBQ0Usc0JBQWlCLEdBQUcsRUFBRSxDQUFDO0lBMEJ6QixDQUFDO0lBeEJDLGNBQWMsQ0FDWixLQUFVLEVBQ1YsTUFBMkM7UUFFM0MsSUFBSSxNQUFNLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztZQUNoQyxPQUFPLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3JDLENBQUM7UUFFRCxPQUFPLG9CQUFvQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVELFVBQVUsQ0FBQyxLQUFVOztRQUNuQixJQUFJLENBQUMsS0FBSztZQUFFLE9BQU8sSUFBSSxDQUFDO1FBRXhCLElBQUksU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNyQyxPQUFPLE1BQUEsS0FBSyxDQUFDLENBQUMsQ0FBQywwQ0FBRSxRQUFRLEdBQUcsSUFBSSxFQUFFLENBQUM7UUFDckMsQ0FBQztRQUVELE9BQU8sTUFBQSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsUUFBUSxHQUFHLElBQUksRUFBRSxtQ0FBSSxJQUFJLENBQUM7SUFDMUMsQ0FBQztJQUVELG1CQUFtQixDQUFDLEtBQVU7O1FBQzVCLE9BQU8sTUFBQSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDdEMsQ0FBQztDQUNGIn0=