import dayjs from 'dayjs';
import { ButtonActionsType } from '../../../lib/Api';
import { LongTextAiMetaProp } from '../../../lib/globals';
import { parseProp } from '../../../lib/helperFunctions';
import UITypes, { isAIPromptCol } from '../../../lib/UITypes';
export const dataTypeLow = (column) => { var _a; return (_a = column.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase(); };
export const isBoolean = (column, abstractType) => column.uidt === UITypes.Checkbox || abstractType === 'boolean';
export const isString = (column, abstractType) => column.uidt === UITypes.SingleLineText || abstractType === 'string';
export const isTextArea = (column) => column.uidt === UITypes.LongText;
export const isRichText = (column) => column.uidt === UITypes.LongText && !!parseProp(column === null || column === void 0 ? void 0 : column.meta).richMode;
export const isInt = (_column, abstractType) => abstractType === 'integer';
export const isFloat = (column, abstractType) => abstractType === 'float' || column.uidt === UITypes.Number;
export const isDate = (column, abstractType) => abstractType === 'date' || column.uidt === UITypes.Date;
export const isYear = (column, abstractType) => abstractType === 'year' || column.uidt === UITypes.Year;
export const isTime = (column, abstractType) => abstractType === 'time' || column.uidt === UITypes.Time;
export const isDateTime = (column, abstractType) => abstractType === 'datetime' || column.uidt === UITypes.DateTime;
export const isReadonlyDateTime = (column, _abstractType) => column.uidt === UITypes.CreatedTime ||
    column.uidt === UITypes.LastModifiedTime;
export const isReadonlyUser = (column, _abstractType) => column.uidt === UITypes.CreatedBy || column.uidt === UITypes.LastModifiedBy;
export const isJSON = (column) => column.uidt === UITypes.JSON;
export const isEnum = (column) => column.uidt === UITypes.SingleSelect;
export const isSingleSelect = (column) => column.uidt === UITypes.SingleSelect;
export const isSet = (column) => column.uidt === UITypes.MultiSelect;
export const isMultiSelect = (column) => column.uidt === UITypes.MultiSelect;
export const isURL = (column) => column.uidt === UITypes.URL;
export const isEmail = (column) => column.uidt === UITypes.Email;
export const isAttachment = (column) => column.uidt === UITypes.Attachment;
export const isRating = (column) => column.uidt === UITypes.Rating;
export const isCurrency = (column) => column.uidt === UITypes.Currency;
export const isPhoneNumber = (column) => column.uidt === UITypes.PhoneNumber;
export const isDecimal = (column) => column.uidt === UITypes.Decimal;
export const isDuration = (column) => column.uidt === UITypes.Duration;
export const isGeoData = (column) => column.uidt === UITypes.GeoData;
export const isPercent = (column) => column.uidt === UITypes.Percent;
export const isSpecificDBType = (column) => column.uidt === UITypes.SpecificDBType;
export const isGeometry = (column) => column.uidt === UITypes.Geometry;
export const isUser = (column) => column.uidt === UITypes.User;
export const isMultiUser = (column) => isUser(column) && !!parseProp(column.meta).is_multi;
export const isButton = (column) => column.uidt === UITypes.Button;
export const isAiButton = (column) => {
    var _a;
    return column.uidt === UITypes.Button &&
        ((_a = column === null || column === void 0 ? void 0 : column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === ButtonActionsType.Ai;
};
export const isScriptButton = (column) => {
    var _a;
    return column.uidt === UITypes.Button &&
        ((_a = column === null || column === void 0 ? void 0 : column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === ButtonActionsType.Script;
};
export const isAI = (column) => {
    var _a;
    return column.uidt === UITypes.LongText &&
        ((_a = parseProp(column === null || column === void 0 ? void 0 : column.meta)) === null || _a === void 0 ? void 0 : _a[LongTextAiMetaProp]) === true;
};
export const isAutoSaved = (column) => [
    UITypes.SingleLineText,
    UITypes.LongText,
    UITypes.PhoneNumber,
    UITypes.Email,
    UITypes.URL,
    UITypes.Number,
    UITypes.Decimal,
    UITypes.Percent,
    UITypes.Count,
    UITypes.AutoNumber,
    UITypes.SpecificDBType,
    UITypes.Geometry,
    UITypes.GeoData,
    UITypes.Duration,
].includes(column.uidt) && !isAIPromptCol(column);
export const isManualSaved = (column) => [UITypes.Currency].includes(column.uidt) || isAIPromptCol(column);
export const isPrimary = (column) => !!column.pv;
export const isPrimaryKey = (column) => !!column.pk;
// used for LTAR and Formula
export const renderValue = (result) => {
    if (!result || typeof result !== 'string') {
        return result;
    }
    // convert ISO string (e.g. in MSSQL) to YYYY-MM-DD hh:mm:ssZ
    // e.g. 2023-05-18T05:30:00.000Z -> 2023-05-18 11:00:00+05:30
    result = result.replace(/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/g, (d) => {
        return dayjs(d).isValid() ? dayjs(d).format('YYYY-MM-DD HH:mm:ssZ') : d;
    });
    // convert all date time values to local time
    // the datetime is either YYYY-MM-DD hh:mm:ss (xcdb)
    // or YYYY-MM-DD hh:mm:ss+/-xx:yy (ext)
    return result.replace(/\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}(?:[+-]\d{2}:\d{2})?/g, (d) => {
        // TODO(timezone): retrieve the format from the corresponding column meta
        // assume HH:mm at this moment
        return dayjs(d).isValid() ? dayjs(d).format('YYYY-MM-DD HH:mm') : d;
    });
};
export const isNumericFieldType = (column, abstractType) => {
    return (isInt(column, abstractType) ||
        isFloat(column, abstractType) ||
        isDecimal(column) ||
        isCurrency(column) ||
        isPercent(column) ||
        isDuration(column));
};
//# sourceMappingURL=data:application/json;base64,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