import { extractProps } from '../../../lib/commonUtils';
import { parseProp } from '../../../lib/helperFunctions';
export const getClipboardConfigForColumn = ({ col, extractMetaProps = [], }) => {
    const columnMeta = extractMetaProps.length
        ? extractProps(parseProp(col.meta), extractMetaProps)
        : parseProp(col.meta);
    return {
        column: col
            ? {
                id: col.id,
                title: col.title,
                column_name: col.column_name,
                meta: columnMeta,
                colOptions: col.colOptions,
                uidt: col.uidt,
                cdf: col.cdf,
                description: col.description,
                source_id: col.source_id,
                fk_model_id: col.fk_model_id,
                system: col.system,
            }
            : {},
    };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpcGJvYXJkLWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL3V0aWxzL2NsaXBib2FyZC1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLG1CQUFtQixDQUFDO0FBQ2pELE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQztBQUVsRCxNQUFNLENBQUMsTUFBTSwyQkFBMkIsR0FBRyxDQUFDLEVBQzFDLEdBQUcsRUFFSCxnQkFBZ0IsR0FBRyxFQUFFLEdBSXRCLEVBRUMsRUFBRTtJQUNGLE1BQU0sVUFBVSxHQUFHLGdCQUFnQixDQUFDLE1BQU07UUFDeEMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLGdCQUFnQixDQUFDO1FBQ3JELENBQUMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBRXhCLE9BQU87UUFDTCxNQUFNLEVBQUUsR0FBRztZQUNULENBQUMsQ0FBQztnQkFDRSxFQUFFLEVBQUUsR0FBRyxDQUFDLEVBQUU7Z0JBQ1YsS0FBSyxFQUFFLEdBQUcsQ0FBQyxLQUFLO2dCQUNoQixXQUFXLEVBQUUsR0FBRyxDQUFDLFdBQVc7Z0JBQzVCLElBQUksRUFBRSxVQUFVO2dCQUNoQixVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVU7Z0JBQzFCLElBQUksRUFBRSxHQUFHLENBQUMsSUFBSTtnQkFDZCxHQUFHLEVBQUUsR0FBRyxDQUFDLEdBQUc7Z0JBQ1osV0FBVyxFQUFFLEdBQUcsQ0FBQyxXQUFXO2dCQUM1QixTQUFTLEVBQUUsR0FBRyxDQUFDLFNBQVM7Z0JBQ3hCLFdBQVcsRUFBRSxHQUFHLENBQUMsV0FBVztnQkFDNUIsTUFBTSxFQUFFLEdBQUcsQ0FBQyxNQUFNO2FBQ25CO1lBQ0gsQ0FBQyxDQUFDLEVBQUU7S0FDUCxDQUFDO0FBQ0osQ0FBQyxDQUFDIn0=