import dayjs from 'dayjs';
import { constructDateTimeFormat, getDateFormat, getDateTimeFormat, } from '../../../lib/dateTimeHelper';
import { parseProp } from '../../../lib/helperFunctions';
import UITypes from '../../../lib/UITypes';
export const DATE_SCALE_LABEL_TO_DIFF_MAP = {
    Y: 'year',
    M: 'month',
    D: 'day',
    H: 'hour',
    m: 'minute',
    s: 'second',
};
export const DATE_DIFF_TO_SCALE_LABEL_MAP = {
    year: 'Y',
    month: 'M',
    day: 'D',
    hour: 'H',
    minute: 'm',
    second: 's',
};
export const parseDateValue = (value, col, isSystemCol) => {
    var _a, _b;
    value = value === null || value === void 0 ? void 0 : value.toString().trim();
    const dateFormat = !isSystemCol
        ? (_b = (_a = parseProp(col.meta)) === null || _a === void 0 ? void 0 : _a.date_format) !== null && _b !== void 0 ? _b : 'YYYY-MM-DD'
        : 'YYYY-MM-DD HH:mm:ss';
    if (!value || !dayjs(value).isValid()) {
        return null;
    }
    else {
        value = value === null || value === void 0 ? void 0 : value.toString().trim();
        return dayjs(/^\d+$/.test(value) ? +value : value).format(dateFormat);
    }
};
export const parseDateTimeValue = (value, params) => {
    var _a;
    // remove `"`
    // e.g. "2023-05-12T08:03:53.000Z" -> 2023-05-12T08:03:53.000Z
    value = value === null || value === void 0 ? void 0 : value.replace(/["']/g, '');
    if (!value) {
        return;
    }
    const isMySQL = (_a = params.isMysql) === null || _a === void 0 ? void 0 : _a.call(params, params.col.source_id);
    let d = dayjs(value);
    if (!d.isValid()) {
        // insert a datetime value, copy the value without refreshing
        // e.g. value = 2023-05-12T03:49:25.000Z
        // feed custom parse format
        d = dayjs(value, isMySQL ? 'YYYY-MM-DD HH:mm:ss' : 'YYYY-MM-DD HH:mm:ssZ');
    }
    // users can change the datetime format in UI
    // `value` would be always in YYYY-MM-DD HH:mm:ss(Z / +xx:yy) format
    // therefore, here we reformat to the correct datetime format based on the meta
    value = d.format(constructDateTimeFormat(params.col));
    if (!d.isValid()) {
        // return empty string for invalid datetime
        return null;
    }
    return value;
};
export const serializeDateOrDateTimeValue = (value, params) => {
    var _a, _b, _c, _d;
    if (!value)
        return null;
    value = value === null || value === void 0 ? void 0 : value.toString().trim();
    let isDateOnly = false;
    if (typeof value === 'string' && value.length < 11) {
        isDateOnly = true;
    }
    let parsedDateOrDateTime;
    // If clipboardItem column is date or datetime, then use the dbCellValue from clipboardItem
    if ([UITypes.Date, UITypes.DateTime].includes((_b = (_a = params.clipboardItem) === null || _a === void 0 ? void 0 : _a.column) === null || _b === void 0 ? void 0 : _b.uidt) &&
        params.clipboardItem.dbCellValue) {
        const formatting = ((_c = params.clipboardItem) === null || _c === void 0 ? void 0 : _c.column.uidt) === UITypes.Date
            ? 'YYYY-MM-DD'
            : 'YYYY-MM-DD HH:mm:ssZ';
        parsedDateOrDateTime = dayjs(params.clipboardItem.dbCellValue, formatting);
    }
    // If clipboardItem not present or invalid, then use default method to parse the value
    if (!parsedDateOrDateTime || !parsedDateOrDateTime.isValid()) {
        const formatting = isDateOnly
            ? (_d = parseProp(params.col.meta).date_format) !== null && _d !== void 0 ? _d : 'YYYY-MM-DD'
            : constructDateTimeFormat(params.col);
        parsedDateOrDateTime = dayjs(value, formatting);
    }
    if (!parsedDateOrDateTime.isValid()) {
        parsedDateOrDateTime = dayjs(value, getDateTimeFormat(value));
        if (!parsedDateOrDateTime.isValid()) {
            parsedDateOrDateTime = dayjs(value, getDateFormat(value));
        }
    }
    if (!parsedDateOrDateTime.isValid()) {
        return null;
    }
    return params.col.uidt === UITypes.Date
        ? parsedDateOrDateTime.format('YYYY-MM-DD')
        : parsedDateOrDateTime.utc().format('YYYY-MM-DD HH:mm:ssZ');
};
//# sourceMappingURL=data:application/json;base64,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