import { ncIsNullOrUndefined, ncIsNumber, ncIsUndefined } from '../../../lib/is';
import { floatAddDumb, floatDivDumb, floatSubDumb } from './decimal';
const fillHandlerSuffixRegex = /(.*)(\d+)$/;
const getModifierForNumber = ({ group, nullPrefix, }) => {
    var _a, _b;
    let sumOfModifier = 0;
    let lastData = Number(group[nullPrefix].data[1]);
    sumOfModifier = floatSubDumb(lastData, Number(group[nullPrefix].data[0]));
    for (const current of group[nullPrefix].data.slice(2)) {
        sumOfModifier += floatSubDumb(Number(current), lastData);
        lastData = Number(current);
    }
    return {
        modifier: floatDivDumb(sumOfModifier, ((_b = (_a = group[nullPrefix]) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.length) - 1),
        lastData,
    };
};
// follow google sheet behavior
export function populateFillHandleStringNumber({ highlightedData, numberOfRows, }) {
    var _a, _b;
    const nullPrefix = Symbol('nullPrefix');
    const emptyCell = Symbol('empty');
    const group = {};
    const groupIndex = {};
    const rowToFill = numberOfRows - highlightedData.length;
    if (rowToFill <= 0) {
        return [];
    }
    let highLightIndex = 0;
    // group row values by prefix / suffix
    for (const highlightedRow of highlightedData) {
        let index;
        let groupKey;
        if (typeof highlightedRow === 'string') {
            // check if number
            if (!ncIsNullOrUndefined(highlightedRow) &&
                highlightedRow !== '' &&
                ncIsNumber(Number(highlightedRow))) {
                groupKey = nullPrefix;
                index = highlightedRow;
            }
            else {
                const regexResult = highlightedRow.match(fillHandlerSuffixRegex);
                if (!regexResult) {
                    if (highlightedRow !== '') {
                        groupKey = highlightedRow;
                    }
                }
                else {
                    const [_match, ...rest] = regexResult;
                    groupKey = rest[0];
                    index = rest[1];
                    if (groupKey === '') {
                        groupKey = nullPrefix;
                    }
                }
            }
        }
        else if (typeof highlightedRow === 'number') {
            groupKey = nullPrefix;
            index = highlightedRow;
        }
        if (ncIsNullOrUndefined(groupKey) && ncIsNullOrUndefined(index)) {
            groupIndex[highLightIndex++] = {
                group: {
                    data: [],
                    modifier: 0,
                    prefix: emptyCell,
                    lastIndex: undefined,
                },
                row: undefined,
            };
            continue;
        }
        if (!group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix]) {
            group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix] = {
                prefix: groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix,
                data: [],
                modifier: 0,
                lastIndex: index,
            };
        }
        const groupData = group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix].data;
        groupData.push(index);
        groupIndex[highLightIndex++] = {
            group: group[groupKey !== null && groupKey !== void 0 ? groupKey : nullPrefix],
            row: index,
        };
    }
    // loop once per group to calculate / set modifier
    for (const [_prefix, groupRecord] of Object.entries(group)) {
        if (groupRecord.data.length > 1) {
            let lastData = Number(groupRecord.data[1]);
            let modifier = lastData - Number(groupRecord.data[0]);
            for (const current of groupRecord.data.slice(2)) {
                if (Number(current) - lastData !== modifier) {
                    modifier = 0;
                    break;
                }
                lastData = Number(current);
            }
            groupRecord.modifier = modifier;
            groupRecord.lastIndex = lastData;
        }
    }
    // for pure number, the logic is different following google sheet
    if (((_b = (_a = group[nullPrefix]) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.length) > 1) {
        const { lastData, modifier } = getModifierForNumber({
            group,
            nullPrefix,
        });
        group[nullPrefix].modifier = modifier;
        group[nullPrefix].lastIndex = lastData;
    }
    const result = [];
    for (let fillingIndex = 0; fillingIndex < rowToFill; fillingIndex++) {
        const groupOfIndex = groupIndex[fillingIndex % highlightedData.length];
        if (emptyCell === groupOfIndex.group.prefix) {
            result.push(null);
        }
        else if (typeof groupOfIndex.group.prefix === 'string' &&
            groupOfIndex.group.modifier === 0) {
            const rowStr = ncIsUndefined(groupOfIndex.row) ? '' : groupOfIndex.row;
            result.push(`${groupOfIndex.group.prefix}${rowStr}`);
        }
        else {
            // if the modifier has decimal, round to nearest decimal
            if (groupOfIndex.group.modifier - Math.floor(groupOfIndex.group.modifier) >
                0) {
                groupOfIndex.group.lastIndex = floatAddDumb(groupOfIndex.group.lastIndex, groupOfIndex.group.modifier);
            }
            else {
                groupOfIndex.group.lastIndex += groupOfIndex.group.modifier;
            }
            result.push(`${groupOfIndex.group.prefix === nullPrefix
                ? ''
                : groupOfIndex.group.prefix}${Math.abs(groupOfIndex.group.lastIndex)}`);
        }
    }
    return result;
}
// simply copy the value repeatedly
export function populateFillHandleStrictCopy({ highlightedData, numberOfRows, }) {
    const result = [];
    for (let i = 0; i < numberOfRows - highlightedData.length; i++) {
        result.push(highlightedData[i % highlightedData.length]);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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