import { populateFillHandleStrictCopy, populateFillHandleStringNumber, } from './fill-handler';
describe('fill-handler.utils', () => {
    describe('populateFillHandleStringNumber', () => {
        it('will populate single number value', () => {
            const data = [33];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 3,
            });
            expect(result).toEqual(['33', '33']);
        });
        it('will populate number value', () => {
            const data = ['2', '4', '6', 8];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 8,
            });
            expect(result).toEqual(['10', '12', '14', '16']);
        });
        it('will populate combined string value', () => {
            const data = ['1A1', '2', '4', '1A2', '6', 8, '1A3'];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A4',
                '10',
                '12',
                '1A5',
                '14',
                '16',
                '1A6',
                '1A7',
                '18',
            ]);
        });
        it('will populate combined string value without suffix', () => {
            const data = ['1A1', '1A2', '1A3', '1A', '1A4'];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A1',
                '1A2',
                '1A3',
                '1A',
                '1A4',
                '1A1',
                '1A2',
                '1A3',
                '1A',
                '1A4',
                '1A1',
            ]);
        });
        it('will populate combined value with empty cell', () => {
            const data = ['1A1', '1A2', '', null, undefined, '1A3'];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A4',
                '1A5',
                null,
                null,
                null,
                '1A6',
                '1A7',
                '1A8',
                null,
                null,
            ]);
        });
        it('will populate descending combined string value', () => {
            const data = ['1A4', '4', '3', '1A3', '2', 1, '1A2'];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 16,
            });
            expect(result).toEqual([
                '1A1',
                '0',
                '1',
                '1A0',
                '2',
                '3',
                '1A1',
                '1A2',
                '4',
            ]);
        });
        it('will populate decimal value', () => {
            const data = ['33.11', '33.12', '33.13'];
            const result = populateFillHandleStringNumber({
                highlightedData: data,
                column: {},
                numberOfRows: 14,
            });
            expect(result).toEqual([
                '33.14',
                '33.15',
                '33.16',
                '33.17',
                '33.18',
                '33.19',
                '33.2',
                '33.21',
                '33.22',
                '33.23',
                '33.24',
            ]);
        });
    });
    describe('populateFillHandleStrictCopy', () => {
        it('will populate number value by strict copy', () => {
            const data = ['2', '4', '6', 8];
            const result = populateFillHandleStrictCopy({
                highlightedData: data,
                column: {},
                numberOfRows: 8,
            });
            expect(result).toEqual(['2', '4', '6', 8]);
        });
        it('will populate number value by strict copy with combination and null values', () => {
            const data = ['2', '4', '6', 8, '1A', '1B', null, undefined, ''];
            const result = populateFillHandleStrictCopy({
                highlightedData: data,
                column: {},
                numberOfRows: 20,
            });
            expect(result).toEqual([
                '2',
                '4',
                '6',
                8,
                '1A',
                '1B',
                null,
                undefined,
                '',
                '2',
                '4',
            ]);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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