import UITypes from '../../../lib/UITypes';
import { getMetaWithCompositeKey } from '../../../lib/helpers/metaHelpers';
export function getLookupColumnType({ col, meta, metas, baseId, visitedIds = new Set(), }) {
    var _a, _b;
    const currentBaseId = baseId || (meta === null || meta === void 0 ? void 0 : meta.base_id);
    const colOptions = col.colOptions;
    const relationColumnOptions = colOptions.fk_relation_column_id
        ? (_b = (_a = meta === null || meta === void 0 ? void 0 : meta.columns) === null || _a === void 0 ? void 0 : _a.find((c) => c.id === colOptions.fk_relation_column_id)) === null || _b === void 0 ? void 0 : _b.colOptions
        : null;
    const relatedTableMeta = (relationColumnOptions === null || relationColumnOptions === void 0 ? void 0 : relationColumnOptions.fk_related_model_id) &&
        getMetaWithCompositeKey(metas, currentBaseId, relationColumnOptions.fk_related_model_id);
    const childColumn = relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns.find((c) => c.id === colOptions.fk_lookup_column_id);
    // if child column is lookup column, then recursively find the column type
    // and check for circular dependency
    if (childColumn &&
        childColumn.uidt === UITypes.Lookup &&
        !visitedIds.has(childColumn.id) &&
        (relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.columns)) {
        visitedIds.add(childColumn.id);
        return getLookupColumnType({
            col: childColumn,
            meta: relatedTableMeta,
            metas: metas,
            baseId: (relatedTableMeta === null || relatedTableMeta === void 0 ? void 0 : relatedTableMeta.base_id) || baseId,
            visitedIds: visitedIds,
        });
    }
    return (childColumn === null || childColumn === void 0 ? void 0 : childColumn.uidt) || null;
}
//# sourceMappingURL=data:application/json;base64,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