export const arrayToNested = ({ data, getIdHandler, getFkHandler, childAssignHandler, parentFkId, level = 0, maxLevel = 5, }) => {
    let recordsOnLevel;
    if (level === 0) {
        recordsOnLevel = data.filter((row) => !getFkHandler(row));
    }
    else {
        recordsOnLevel = data.filter((row) => getFkHandler(row) === parentFkId);
    }
    if (level < maxLevel) {
        for (const row of recordsOnLevel) {
            childAssignHandler(row, arrayToNested({
                data,
                getIdHandler,
                parentFkId: getIdHandler(row),
                childAssignHandler,
                getFkHandler,
                level: level + 1,
                maxLevel,
            }));
        }
    }
    return recordsOnLevel;
};
export const traverseNested = (params) => {
    for (const each of params.nestedData) {
        params.onEach(each);
        traverseNested({
            nestedData: params.getChildField(each),
            getChildField: params.getChildField,
            onEach: params.onEach,
        });
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVjdXJzaXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vc3JjL2xpYi9jb2x1bW5IZWxwZXIvdXRpbHMvcmVjdXJzaXZlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FBRyxDQUFDLEVBQzVCLElBQUksRUFDSixZQUFZLEVBQ1osWUFBWSxFQUNaLGtCQUFrQixFQUNsQixVQUFVLEVBQ1YsS0FBSyxHQUFHLENBQUMsRUFDVCxRQUFRLEdBQUcsQ0FBQyxHQVNiLEVBQUUsRUFBRTtJQUNILElBQUksY0FBYyxDQUFDO0lBQ25CLElBQUksS0FBSyxLQUFLLENBQUMsRUFBRSxDQUFDO1FBQ2hCLGNBQWMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQzVELENBQUM7U0FBTSxDQUFDO1FBQ04sY0FBYyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsS0FBSyxVQUFVLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBQ0QsSUFBSSxLQUFLLEdBQUcsUUFBUSxFQUFFLENBQUM7UUFDckIsS0FBSyxNQUFNLEdBQUcsSUFBSSxjQUFjLEVBQUUsQ0FBQztZQUNqQyxrQkFBa0IsQ0FDaEIsR0FBRyxFQUNILGFBQWEsQ0FBQztnQkFDWixJQUFJO2dCQUNKLFlBQVk7Z0JBQ1osVUFBVSxFQUFFLFlBQVksQ0FBQyxHQUFHLENBQUM7Z0JBQzdCLGtCQUFrQjtnQkFDbEIsWUFBWTtnQkFDWixLQUFLLEVBQUUsS0FBSyxHQUFHLENBQUM7Z0JBQ2hCLFFBQVE7YUFDVCxDQUFDLENBQ0gsQ0FBQztRQUNKLENBQUM7SUFDSCxDQUFDO0lBQ0QsT0FBTyxjQUFjLENBQUM7QUFDeEIsQ0FBQyxDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sY0FBYyxHQUFHLENBQUksTUFJakMsRUFBRSxFQUFFO0lBQ0gsS0FBSyxNQUFNLElBQUksSUFBSSxNQUFNLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDckMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwQixjQUFjLENBQUM7WUFDYixVQUFVLEVBQUUsTUFBTSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUM7WUFDdEMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxhQUFhO1lBQ25DLE1BQU0sRUFBRSxNQUFNLENBQUMsTUFBTTtTQUN0QixDQUFDLENBQUM7SUFDTCxDQUFDO0FBQ0gsQ0FBQyxDQUFDIn0=