import { RelationTypes } from '../../../lib/globals';
import { isSystemColumn } from '../../../lib/helperFunctions';
import UITypes, { isCreatedOrLastModifiedByCol, isCreatedOrLastModifiedTimeCol, isLinksOrLTAR, isVirtualCol, } from '../../../lib/UITypes';
import { isButton } from './cell';
export const isLTAR = (uidt, _colOptions) => {
    if (!uidt)
        return false;
    return isLinksOrLTAR(uidt);
};
export const isHm = (column) => {
    var _a;
    return isLTAR(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === RelationTypes.HAS_MANY;
};
export const isMm = (column) => {
    var _a;
    return isLTAR(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === RelationTypes.MANY_TO_MANY;
};
export const isBt = (column) => {
    var _a;
    return isLTAR(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === RelationTypes.BELONGS_TO;
};
export const isOo = (column) => {
    var _a;
    return isLTAR(column.uidt, column.colOptions) &&
        ((_a = column.colOptions) === null || _a === void 0 ? void 0 : _a.type) === RelationTypes.ONE_TO_ONE;
};
export const isLookup = (column) => column.uidt === UITypes.Lookup;
export const isRollup = (column) => column.uidt === UITypes.Rollup;
export const isFormula = (column) => column.uidt === UITypes.Formula;
export const isQrCode = (column) => column.uidt === UITypes.QrCode;
export const isBarcode = (column) => column.uidt === UITypes.Barcode;
export const isCount = (column) => column.uidt === UITypes.Count;
export const isLink = (column) => column.uidt === UITypes.Links;
export function isReadOnlyVirtualCell(col) {
    return (isRollup(col) ||
        isFormula(col) ||
        isBarcode(col) ||
        isLookup(col) ||
        isQrCode(col) ||
        isSystemColumn(col) ||
        isCreatedOrLastModifiedTimeCol(col) ||
        isCreatedOrLastModifiedByCol(col));
}
export const isReadonlyVirtualColumn = (col) => {
    return (isSystemColumn(col) ||
        isLookup(col) ||
        isRollup(col) ||
        isFormula(col) ||
        isButton(col) ||
        isVirtualCol(col) ||
        isCreatedOrLastModifiedTimeCol(col) ||
        isCreatedOrLastModifiedByCol(col));
};
//# sourceMappingURL=data:application/json;base64,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