import { ncIsNumber } from './is';
export const getGroupDecimalSymbolFromLocale = (locale) => {
    var _a, _b;
    let group = ',';
    let decimal = '.';
    if (!locale) {
        return {
            group,
            decimal,
        };
    }
    const formatter = new Intl.NumberFormat(locale || 'en-US');
    if (!formatter.formatToParts) {
        return {
            group,
            decimal,
        };
    }
    // Use formatToParts to extract the characters used for grouping (thousands) and decimal
    const parts = formatter.formatToParts(12345.6);
    // Extract group separator (e.g., '.' in 'de-DE', ',' in 'en-US')
    group = ((_a = parts.find((p) => p.type === 'group')) === null || _a === void 0 ? void 0 : _a.value) || group;
    // Extract decimal separator (e.g., ',' in 'de-DE', '.' in 'en-US')
    decimal = ((_b = parts.find((p) => p.type === 'decimal')) === null || _b === void 0 ? void 0 : _b.value) || decimal;
    return {
        group,
        decimal,
    };
};
export const getNumericValue = (value, locale) => {
    // accept valid decimal string as well, like '9.123', '9.1234', '9.123456789'
    if (/^(?:\d+(?:\.\d+)?|\.\d+)$/.test(value)) {
        return {
            value: value,
            pointDecimalValue: value,
            numericValue: parseFloat(value),
            isValid: true,
        };
    }
    const { group, decimal } = getGroupDecimalSymbolFromLocale(locale);
    const [integerString, decimalString] = value.split(decimal);
    // check if there's group after decimal symbol
    if (decimalString &&
        decimalString.length > 0 &&
        decimalString.indexOf(group) >= 0) {
        return {
            value: value,
            pointDecimalValue: undefined,
            numericValue: undefined,
            isValid: false,
        };
    }
    const integerParts = integerString.split(group);
    // check if there's group that doesn't have 3 digit
    if (integerParts.slice(1).some((p) => p.length !== 3)) {
        return {
            value: value,
            pointDecimalValue: undefined,
            numericValue: undefined,
            isValid: false,
        };
    }
    const valueToParse = value
        .replace(new RegExp(`\\${group}`, 'g'), '')
        .replace(new RegExp(`\\${decimal}`, 'g'), '.')
        .replace(/[^\d.-]/g, '') // 3. Remove any non-digit, non-dot, non-minus characters (e.g., currency symbols, spaces)
        .trim();
    const numericValue = parseFloat(valueToParse);
    const isValid = ncIsNumber(numericValue);
    return {
        value: value,
        pointDecimalValue: isValid ? valueToParse : undefined,
        numericValue: isValid ? numericValue : undefined,
        isValid,
    };
};
//# sourceMappingURL=data:application/json;base64,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