import { ChartTypes } from './charts';
export var WidgetTypes;
(function (WidgetTypes) {
    WidgetTypes["CHART"] = "chart";
    WidgetTypes["METRIC"] = "metric";
    WidgetTypes["GAUGE"] = "gauge";
    WidgetTypes["TEXT"] = "text";
    WidgetTypes["TABLE"] = "table";
    WidgetTypes["IFRAME"] = "iframe";
})(WidgetTypes || (WidgetTypes = {}));
export const WidgetChartLabelMap = {
    [ChartTypes.BAR]: 'Bar Chart',
    [ChartTypes.LINE]: 'Line Chart',
    [ChartTypes.PIE]: 'Pie Chart',
    [ChartTypes.DONUT]: 'Donut Chart',
    [ChartTypes.SCATTER]: 'Scatter Plot',
    [WidgetTypes.TABLE]: 'Table',
    [WidgetTypes.METRIC]: 'Metric',
    [WidgetTypes.GAUGE]: 'Gauge',
    [WidgetTypes.TEXT]: 'Text',
    [WidgetTypes.IFRAME]: 'iFrame',
};
export var WidgetDataSourceTypes;
(function (WidgetDataSourceTypes) {
    WidgetDataSourceTypes["VIEW"] = "view";
    WidgetDataSourceTypes["MODEL"] = "model";
    WidgetDataSourceTypes["FILTER"] = "filter";
})(WidgetDataSourceTypes || (WidgetDataSourceTypes = {}));
export var TextWidgetTypes;
(function (TextWidgetTypes) {
    TextWidgetTypes["Markdown"] = "markdown";
    TextWidgetTypes["Text"] = "text";
})(TextWidgetTypes || (TextWidgetTypes = {}));
export * from './charts';
export * from './widgetUtils';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2Rhc2hib2FyZC9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFxQixNQUFNLFVBQVUsQ0FBQztBQW9CekQsTUFBTSxDQUFOLElBQVksV0FPWDtBQVBELFdBQVksV0FBVztJQUNyQiw4QkFBZSxDQUFBO0lBQ2YsZ0NBQWlCLENBQUE7SUFDakIsOEJBQWUsQ0FBQTtJQUNmLDRCQUFhLENBQUE7SUFDYiw4QkFBZSxDQUFBO0lBQ2YsZ0NBQWlCLENBQUE7QUFDbkIsQ0FBQyxFQVBXLFdBQVcsS0FBWCxXQUFXLFFBT3RCO0FBRUQsTUFBTSxDQUFDLE1BQU0sbUJBQW1CLEdBQUc7SUFDakMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEVBQUUsV0FBVztJQUM3QixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxZQUFZO0lBQy9CLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFLFdBQVc7SUFDN0IsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLEVBQUUsYUFBYTtJQUNqQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRSxjQUFjO0lBQ3BDLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxFQUFFLE9BQU87SUFDNUIsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLEVBQUUsUUFBUTtJQUM5QixDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsRUFBRSxPQUFPO0lBQzVCLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxFQUFFLE1BQU07SUFDMUIsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLEVBQUUsUUFBUTtDQUMvQixDQUFDO0FBRUYsTUFBTSxDQUFOLElBQVkscUJBSVg7QUFKRCxXQUFZLHFCQUFxQjtJQUMvQixzQ0FBYSxDQUFBO0lBQ2Isd0NBQWUsQ0FBQTtJQUNmLDBDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFKVyxxQkFBcUIsS0FBckIscUJBQXFCLFFBSWhDO0FBaURELE1BQU0sQ0FBTixJQUFZLGVBR1g7QUFIRCxXQUFZLGVBQWU7SUFDekIsd0NBQXFCLENBQUE7SUFDckIsZ0NBQWEsQ0FBQTtBQUNmLENBQUMsRUFIVyxlQUFlLEtBQWYsZUFBZSxRQUcxQjtBQTRLRCxjQUFjLFVBQVUsQ0FBQztBQUN6QixjQUFjLGVBQWUsQ0FBQyJ9