import { durationOptions } from './UITypes';
// pad zero
// mm && ss
// e.g.  3 -> 03
// e.g. 12 -> 12
// sss
// e.g.  1 -> 001
// e.g. 10 -> 010
const padZero = (val, isSSS = false) => {
    return `${val}`.padStart(isSSS ? 3 : 2, '0');
};
export const convertMS2Duration = (val, durationType) => {
    if (val === '' || val === null || val === undefined) {
        return val;
    }
    // 600.000 s --> 10:00 (10 mins)
    const milliseconds = Math.round((val % 1) * 1000);
    const centiseconds = Math.round(milliseconds / 10);
    const deciseconds = Math.round(centiseconds / 10);
    const hours = Math.floor(parseInt(val, 10) / (60 * 60));
    const minutes = Math.floor((parseInt(val, 10) - hours * 60 * 60) / 60);
    const seconds = parseInt(val, 10) - hours * 60 * 60 - minutes * 60;
    if (durationType === 0) {
        // h:mm
        return `${padZero(hours)}:${padZero(minutes + (seconds >= 30 ? 1 : 0))}`;
    }
    else if (durationType === 1) {
        // h:mm:ss
        return `${padZero(hours)}:${padZero(minutes)}:${padZero(seconds)}`;
    }
    else if (durationType === 2) {
        // h:mm:ss.s
        return `${padZero(hours)}:${padZero(minutes)}:${padZero(seconds)}.${deciseconds}`;
    }
    else if (durationType === 3) {
        // h:mm:ss.ss
        return `${padZero(hours)}:${padZero(minutes)}:${padZero(seconds)}.${padZero(centiseconds)}`;
    }
    else if (durationType === 4) {
        // h:mm:ss.sss
        return `${padZero(hours)}:${padZero(minutes)}:${padZero(seconds)}.${padZero(milliseconds, true)}`;
    }
    return val;
};
export const convertDurationToSeconds = (val, durationType) => {
    // 10:00 (10 mins) -> 600.000 s
    const res = {
        _sec: 0,
        _isValid: true,
    };
    const durationRegex = durationOptions[durationType].regex;
    if (durationRegex.test(val)) {
        let h, mm, ss;
        const groups = val.match(durationRegex);
        if (groups[0] && groups[1] && !groups[2] && !groups[3] && !groups[4]) {
            const val = parseInt(groups[1], 10);
            if (groups.input.slice(-1) === ':') {
                // e.g. 30:
                h = groups[1];
                mm = 0;
                ss = 0;
            }
            else if (durationType === 0) {
                // consider it as minutes
                // e.g. 360 -> 06:00
                h = Math.floor(val / 60);
                mm = Math.floor(val - (h * 3600) / 60);
                ss = 0;
            }
            else {
                // consider it as seconds
                // e.g. 3600 -> 01:00:00
                h = Math.floor(groups[1] / 3600);
                mm = Math.floor(groups[1] / 60) % 60;
                ss = val % 60;
            }
        }
        else if (durationType !== 0 && groups[1] && groups[2] && !groups[3]) {
            // 10:10 means mm:ss instead of h:mm
            // 10:10:10 means h:mm:ss
            h = 0;
            mm = groups[1];
            ss = groups[2];
        }
        else {
            h = groups[1] || 0;
            mm = groups[2] || 0;
            ss = groups[3] || 0;
        }
        if (durationType === 0) {
            // h:mm
            res._sec = h * 3600 + mm * 60;
        }
        else if (durationType === 1) {
            // h:mm:ss
            res._sec = h * 3600 + mm * 60 + ss * 1;
        }
        else if (durationType === 2) {
            // h:mm:ss.s (deciseconds)
            const ds = groups[4] || 0;
            const len = (Math.log(ds) * Math.LOG10E + 1) | 0;
            const ms = 
            // e.g. len = 4: 1234 -> 1, 1456 -> 1
            // e.g. len = 3:  123 -> 1,  191 -> 2
            // e.g. len = 2:   12 -> 1 ,  16 -> 2
            (len === 4
                ? Math.round(ds / 1000)
                : len === 3
                    ? Math.round(ds / 100)
                    : len === 2
                        ? Math.round(ds / 10)
                        : // take whatever it is
                            ds) * 100;
            res._sec = h * 3600 + mm * 60 + ss * 1 + ms / 1000;
        }
        else if (durationType === 3) {
            // h:mm:ss.ss (centiseconds)
            const cs = groups[4] || 0;
            const len = (Math.log(cs) * Math.LOG10E + 1) | 0;
            const ms = 
            // e.g. len = 4: 1234 -> 12, 1285 -> 13
            // e.g. len = 3:  123 -> 12,  128 -> 13
            // check the third digit
            (len === 4
                ? Math.round(cs / 100)
                : len === 3
                    ? Math.round(cs / 10)
                    : // take whatever it is
                        cs) * 10;
            res._sec = h * 3600 + mm * 60 + ss * 1 + ms / 1000;
        }
        else if (durationType === 4) {
            // h:mm:ss.sss (milliseconds)
            let ms = groups[4] || 0;
            const len = (Math.log(ms) * Math.LOG10E + 1) | 0;
            ms =
                // e.g. 1235 -> 124
                // e.g. 1234 -> 123
                (len === 4
                    ? Math.round(ms / 10)
                    : // take whatever it is
                        ms) * 1;
            res._sec = h * 3600 + mm * 60 + ss * 1 + ms / 1000;
        }
    }
    else {
        res._isValid = false;
    }
    return res;
};
//# sourceMappingURL=data:application/json;base64,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