export declare enum OrgUserRoles {
    SUPER_ADMIN = "super",
    CREATOR = "org-level-creator",
    VIEWER = "org-level-viewer"
}
export declare enum CloudOrgUserRoles {
    CREATOR = "cloud-org-level-creator",
    VIEWER = "cloud-org-level-viewer",
    OWNER = "cloud-org-level-owner"
}
export declare enum ProjectRoles {
    OWNER = "owner",
    CREATOR = "creator",
    INHERIT = "inherit",
    EDITOR = "editor",
    COMMENTER = "commenter",
    VIEWER = "viewer",
    NO_ACCESS = "no-access"
}
export declare enum WorkspaceUserRoles {
    OWNER = "workspace-level-owner",
    CREATOR = "workspace-level-creator",
    INHERIT = "workspace-level-inherit",
    EDITOR = "workspace-level-editor",
    COMMENTER = "workspace-level-commenter",
    VIEWER = "workspace-level-viewer",
    NO_ACCESS = "workspace-level-no-access"
}
export declare enum TeamUserRoles {
    MEMBER = "member",
    OWNER = "owner"
}
export declare enum AppEvents {
    PROJECT_CREATE = "base.create",
    PROJECT_INVITE = "base.invite",
    PROJECT_USER_UPDATE = "base.user.update",
    PROJECT_USER_RESEND_INVITE = "base.user.resend.invite",
    PROJECT_TEAM_INVITE = "base.team.invite",
    PROJECT_TEAM_UPDATE = "base.team.update",
    PROJECT_TEAM_DELETE = "base.team.delete",
    PROJECT_DELETE = "base.delete",
    PROJECT_UPDATE = "base.update",
    PROJECT_CLONE = "base.clone",
    WELCOME = "app.welcome",
    WORKSPACE_USER_INVITE = "workspace.invite",
    WORKSPACE_USER_UPDATE = "workspace.user.update",
    WORKSPACE_USER_DELETE = "workspace.user.delete",
    WORKSPACE_TEAM_INVITE = "workspace.team.invite",
    WORKSPACE_TEAM_UPDATE = "workspace.team.update",
    WORKSPACE_TEAM_DELETE = "workspace.team.delete",
    WORKSPACE_CREATE = "workspace.create",
    WORKSPACE_DELETE = "workspace.delete",
    WORKSPACE_UPDATE = "workspace.update",
    WORKSPACE_UPGRADE_REQUEST = "workspace.upgrade.request",
    USER_SIGNUP = "user.signup",
    USER_SIGNIN = "user.signin",
    USER_INVITE = "user.invite",
    USER_UPDATE = "user.update",
    USER_PASSWORD_RESET = "user.password.reset",
    USER_PASSWORD_CHANGE = "user.password.change",
    USER_PASSWORD_FORGOT = "user.password.forgot",
    USER_DELETE = "user.delete",
    USER_EMAIL_VERIFICATION = "user.email.verification",
    TEAM_CREATE = "team.create",
    TEAM_UPDATE = "team.update",
    TEAM_DELETE = "team.delete",
    TEAM_MEMBER_ADD = "team.member.add",
    TEAM_MEMBER_UPDATE = "team.member.update",
    TEAM_MEMBER_DELETE = "team.member.delete",
    TABLE_CREATE = "table.create",
    TABLE_DELETE = "table.delete",
    TABLE_UPDATE = "table.update",
    VIEW_CREATE = "view.create",
    VIEW_DELETE = "view.delete",
    VIEW_UPDATE = "view.update",
    SHARED_VIEW_CREATE = "shared.view.create",
    SHARED_VIEW_DELETE = "shared.view.delete",
    SHARED_VIEW_UPDATE = "shared.view.update",
    FILTER_CREATE = "filter.create",
    FILTER_DELETE = "filter.delete",
    FILTER_UPDATE = "filter.update",
    SORT_CREATE = "sort.create",
    SORT_DELETE = "sort.delete",
    SORT_UPDATE = "sort.update",
    COLUMN_CREATE = "column.create",
    COLUMN_DELETE = "column.delete",
    COLUMN_UPDATE = "column.update",
    DATA_CREATE = "data.create",
    DATA_DELETE = "data.delete",
    DATA_UPDATE = "data.update",
    ORG_USER_INVITE = "org.user.invite",
    ORG_USER_RESEND_INVITE = "org.user.resend.invite",
    VIEW_COLUMN_CREATE = "view.column.create",
    VIEW_COLUMN_UPDATE = "view.column.update",
    API_TOKEN_CREATE = "api.token.create",
    API_TOKEN_DELETE = "api.token.delete",
    API_TOKEN_UPDATE = "api.token.update",
    IMAGE_UPLOAD = "image.upload",
    FORM_COLUMN_UPDATE = "form.column.update",
    FORM_CREATE = "form.create",
    FORM_UPDATE = "form.update",
    GALLERY_CREATE = "gallery.create",
    GALLERY_UPDATE = "gallery.update",
    MAP_CREATE = "map.create",
    MAP_UPDATE = "map.update",
    MAP_DELETE = "map.delete",
    KANBAN_CREATE = "kanban.create",
    KANBAN_UPDATE = "kanban.update",
    META_DIFF_SYNC = "meta.diff.sync",
    GRID_CREATE = "grid.create",
    GRID_UPDATE = "grid.update",
    GRID_COLUMN_UPDATE = "grid.column.update",
    WEBHOOK_CREATE = "webhook.create",
    WEBHOOK_UPDATE = "webhook.update",
    WEBHOOK_DELETE = "webhook.delete",
    WEBHOOK_TEST = "webhook.test",
    WEBHOOK_TRIGGER = "webhook.trigger",
    UI_ACL_UPDATE = "ui.acl.update",
    ORG_API_TOKEN_CREATE = "org.api.token.create",
    ORG_API_TOKEN_DELETE = "org.api.token.delete",
    ORG_API_TOKEN_UPDATE = "org.api.token.update",
    PLUGIN_TEST = "plugin.test",
    PLUGIN_INSTALL = "plugin.install",
    PLUGIN_UNINSTALL = "plugin.uninstall",
    SYNC_SOURCE_CREATE = "sync.source.create",
    SYNC_SOURCE_UPDATE = "sync.source.update",
    SYNC_SOURCE_DELETE = "sync.source.delete",
    RELATION_DELETE = "relation.delete",
    RELATION_CREATE = "relation.create",
    SHARED_BASE_GENERATE_LINK = "shared.base.generate.link",
    SHARED_BASE_DELETE_LINK = "shared.base.delete.link",
    ATTACHMENT_UPLOAD = "attachment.upload",
    APIS_CREATED = "apis.created",
    EXTENSION_CREATE = "extension.create",
    EXTENSION_UPDATE = "extension.update",
    EXTENSION_DELETE = "extension.delete",
    COMMENT_CREATE = "comment.create",
    COMMENT_DELETE = "comment.delete",
    COMMENT_UPDATE = "comment.update",
    INTEGRATION_DELETE = "integration.delete",
    INTEGRATION_CREATE = "integration.create",
    INTEGRATION_UPDATE = "integration.update",
    ROW_USER_MENTION = "row.user.mention",
    CALENDAR_CREATE = "calendar.create",
    FORM_DUPLICATE = "form.duplicate",
    CALENDAR_UPDATE = "calendar.update",
    CALENDAR_DELETE = "calendar.delete",
    FORM_DELETE = "form.delete",
    SOURCE_CREATE = "source.create",
    SOURCE_UPDATE = "source.update",
    SOURCE_DELETE = "source.delete",
    SHARED_BASE_REVOKE_LINK = "shared.base.revoke.link",
    GRID_DELETE = "grid.delete",
    GRID_DUPLICATE = "grid.duplicate",
    KANBAN_DELETE = "kanban.delete",
    KANBAN_DUPLICATE = "kanban.duplicate",
    GALLERY_DELETE = "gallery.delete",
    GALLERY_DUPLICATE = "gallery.duplicate",
    BASE_DUPLICATE_START = "base.duplicate.start",
    BASE_DUPLICATE_COMPLETE = "base.duplicate.complete",
    BASE_DUPLICATE_FAIL = "base.duplicate.fail",
    TABLE_DUPLICATE_START = "table.duplicate.start",
    TABLE_DUPLICATE_COMPLETE = "table.duplicate.complete",
    TABLE_DUPLICATE_FAIL = "table.duplicate.fail",
    COLUMN_DUPLICATE_START = "column.duplicate.start",
    COLUMN_DUPLICATE_COMPLETE = "column.duplicate.complete",
    COLUMN_DUPLICATE_FAIL = "column.duplicate.fail",
    VIEW_DUPLICATE_START = "view.duplicate.start",
    VIEW_DUPLICATE_COMPLETE = "view.duplicate.complete",
    VIEW_DUPLICATE_FAIL = "view.duplicate.fail",
    USER_SIGNOUT = "user.signout",
    PROJECT_USER_DELETE = "base.user.delete",
    UI_ACL = "model.role.ui.acl",
    SNAPSHOT_CREATE = "snapshot.create",
    SNAPSHOT_DELETE = "snapshot.delete",
    SNAPSHOT_RESTORE = "snapshot.restore",
    DATA_EXPORT = "data.export",
    DATA_IMPORT = "data.import",
    USER_PROFILE_UPDATE = "user.profile.update",
    SCRIPT_CREATE = "script.create",
    SCRIPT_DELETE = "script.delete",
    SCRIPT_UPDATE = "script.update",
    SCRIPT_DUPLICATE = "script.duplicate",
    DASHBOARD_CREATE = "dashboard.create",
    DASHBOARD_UPDATE = "dashboard.update",
    DASHBOARD_DELETE = "dashboard.delete",
    SHARED_DASHBOARD_GENERATE_LINK = "shared.dashboard.generate.link",
    SHARED_DASHBOARD_UPDATE_LINK = "shared.dashboard.update.link",
    SHARED_DASHBOARD_DELETE_LINK = "shared.dashboard.delete.link",
    DASHBOARD_DUPLICATE_START = "dashboard.duplicate.start",
    DASHBOARD_DUPLICATE_COMPLETE = "dashboard.duplicate.complete",
    DASHBOARD_DUPLICATE_FAIL = "dashboard.duplicate.fail",
    WIDGET_CREATE = "widget.create",
    WIDGET_UPDATE = "widget.update",
    WIDGET_DELETE = "widget.delete",
    WIDGET_DUPLICATE = "widget.duplicate",
    PERMISSION_CREATE = "permission.create",
    PERMISSION_UPDATE = "permission.update",
    PERMISSION_DELETE = "permission.delete",
    WORKFLOW_CREATE = "workflow.create",
    WORKFLOW_UPDATE = "workflow.update",
    WORKFLOW_DELETE = "workflow.delete",
    WORKFLOW_DUPLICATE = "workflow.duplicate",
    WORKFLOW_EXECUTE = "workflow.execute"
}
export declare enum ClickhouseTables {
    API_CALLS = "usage_api_calls",
    API_COUNT = "usage_api_count",
    NOTIFICATION = "nc_notification",
    PAGE_SNAPSHOT = "docs_page_snapshot",
    TELEMETRY = "usage_telemetry",
    AUDIT = "nc_audit"
}
export declare enum WorkspaceStatus {
    CREATING = 0,
    CREATED = 1,
    DELETING = 2,
    DELETED = 3,
    FAILED = 4
}
export declare enum WorkspacePlan {
    FREE = "free",
    TEAM = "team",
    BUSINESS = "business"
}
export declare const RoleLabels: {
    "workspace-level-owner": string;
    "workspace-level-creator": string;
    "workspace-level-editor": string;
    "workspace-level-commenter": string;
    "workspace-level-viewer": string;
    "workspace-level-inherit": string;
    "workspace-level-no-access": string;
    owner: string;
    creator: string;
    editor: string;
    commenter: string;
    viewer: string;
    inherit: string;
    "no-access": string;
    super: string;
    "org-level-creator": string;
    "org-level-viewer": string;
    "cloud-org-level-owner": string;
    "cloud-org-level-creator": string;
    "cloud-org-level-viewer": string;
};
export declare const RoleColors: {
    "workspace-level-owner": string;
    "workspace-level-creator": string;
    "workspace-level-editor": string;
    "workspace-level-commenter": string;
    "workspace-level-viewer": string;
    "workspace-level-inherit": string;
    "workspace-level-no-access": string;
    owner: string;
    creator: string;
    editor: string;
    commenter: string;
    viewer: string;
    inherit: string;
    super: string;
    "no-access": string;
    "org-level-creator": string;
    "org-level-viewer": string;
    "cloud-org-level-owner": string;
    "cloud-org-level-creator": string;
    "cloud-org-level-viewer": string;
};
export declare const RoleDescriptions: {
    "workspace-level-owner": string;
    "workspace-level-creator": string;
    "workspace-level-editor": string;
    "workspace-level-commenter": string;
    "workspace-level-viewer": string;
    "workspace-level-inherit": string;
    "workspace-level-no-access": string;
    owner: string;
    creator: string;
    editor: string;
    commenter: string;
    viewer: string;
    inherit: string;
    "no-access": string;
    super: string;
    "org-level-creator": string;
    "org-level-viewer": string;
    "cloud-org-level-owner": string;
    "cloud-org-level-creator": string;
    "cloud-org-level-viewer": string;
};
export declare const RoleIcons: {
    "workspace-level-owner": string;
    "workspace-level-creator": string;
    "workspace-level-editor": string;
    "workspace-level-commenter": string;
    "workspace-level-viewer": string;
    "workspace-level-inherit": string;
    "workspace-level-no-access": string;
    owner: string;
    creator: string;
    editor: string;
    commenter: string;
    viewer: string;
    inherit: string;
    "no-access": string;
    super: string;
    "org-level-creator": string;
    "org-level-viewer": string;
    "cloud-org-level-owner": string;
    "cloud-org-level-creator": string;
    "cloud-org-level-viewer": string;
};
export declare const WorkspaceRolesToProjectRoles: {
    "workspace-level-owner": ProjectRoles;
    "workspace-level-creator": ProjectRoles;
    "workspace-level-editor": ProjectRoles;
    "workspace-level-commenter": ProjectRoles;
    "workspace-level-viewer": ProjectRoles;
    "workspace-level-no-access": ProjectRoles;
    "workspace-level-inherit": ProjectRoles;
};
export declare const OrderedWorkspaceRoles: WorkspaceUserRoles[];
export declare const OrderedOrgRoles: OrgUserRoles[];
export declare const OrderedProjectRoles: ProjectRoles[];
export declare enum APIContext {
    VIEW_COLUMNS = "fields",
    FILTERS = "filters",
    SORTS = "sorts"
}
export declare enum SourceRestriction {
    SCHEMA_READONLY = "is_schema_readonly",
    DATA_READONLY = "is_data_readonly"
}
export declare enum ClientType {
    MYSQL = "mysql2",
    PG = "pg",
    SQLITE = "sqlite3",
    VITESS = "vitess",
    SNOWFLAKE = "snowflake",
    DATABRICKS = "databricks"
}
export declare enum SSLUsage {
    No = "No",
    Allowed = "Allowed",
    Preferred = "Preferred",
    Required = "Required",
    RequiredWithCa = "Required-CA",
    RequiredWithIdentity = "Required-Identity"
}
export declare enum SyncDataType {
    NOCODB = "nocodb",
    MICROSOFT_ACCESS = "microsoft-access",
    TABLEAU = "tableau",
    ORACLE = "oracle",
    OPENAI = "openai",
    CLAUDE = "claude",
    OLLAMA = "ollama",
    GROQ = "groq",
    SLACK = "slack",
    DISCORD = "discord",
    TWILLO = "twillo",
    MICROSOFT_OUTLOOK = "microsoft-outlook",
    MICROSOFT_TEAMS = "microsoft-teams",
    TELEGRAM = "telegram",
    GMAIL = "gmail",
    WHATSAPP = "whatsapp",
    ASANA = "asana",
    JIRA = "jira",
    MIRO = "miro",
    TRELLO = "trello",
    SALESFORCE = "salesforce",
    PIPEDRIVE = "pipedrive",
    MICROSOFT_DYNAMICS_365 = "microsoft-dynamics-365",
    ZOHO_CRM = "zoho-crm",
    HUBSPOT = "hubspot",
    MAILCHIMP = "mailchimp",
    SURVEYMONKEY = "surveymonkey",
    TYPEFORM = "typeform",
    WORKDAY = "workday",
    GREENHOUSE = "greenhouse",
    LEVER = "lever",
    GITHUB = "github",
    GITLAB = "gitlab",
    BITBUCKET = "bitbucket",
    STRIPE = "stripe",
    QUICKBOOKS = "quickbooks",
    FRESHDESK = "freshdesk",
    INTERCOM = "intercom",
    ZENDESK = "zendesk",
    HUBSPOT_SERVICE_HUB = "hubspot-service-hub",
    SALESFORCE_SERVICE_CLOUD = "salesforce-service-cloud",
    BOX = "box",
    GOOGLE_DRIVE = "google-drive",
    DROPBOX = "dropbox",
    APPLE_NUMBERS = "apple-numbers",
    GOOGLE_CALENDAR = "google-calendar",
    MICROSOFT_EXCEL = "microsoft-excel",
    GOOGLE_SHEETS = "google-sheets"
}
export declare enum IntegrationCategoryType {
    DATABASE = "database",
    AI = "ai",
    COMMUNICATION = "communication",
    SPREAD_SHEET = "spread-sheet",
    PROJECT_MANAGEMENT = "project-management",
    CRM = "crm",
    MARKETING = "marketing",
    ATS = "ats",
    DEVELOPMENT = "development",
    FINANCE = "finance",
    TICKETING = "ticketing",
    STORAGE = "storage",
    OTHERS = "others",
    SYNC = "sync",
    AUTH = "auth"
}
export declare enum ViewLockType {
    Personal = "personal",
    Locked = "locked",
    Collaborative = "collaborative"
}
export declare enum PublicAttachmentScope {
    WORKSPACEPICS = "workspacePics",
    PROFILEPICS = "profilePics",
    ORGANIZATIONPICS = "organizationPics",
    OAUTHCLIENTS = "oauthClients"
}
export declare enum IconType {
    IMAGE = "IMAGE",
    EMOJI = "EMOJI",
    ICON = "ICON"
}
export declare enum NcApiVersion {
    V1 = 0,
    V2 = 1,
    V3 = 2
}
export declare enum HookOperationCode {
    insert = 1,// 1
    update = 2,// 2
    delete = 4,// 4
    trigger = 8
}
export declare enum WebhookActions {
    INSERT = "insert",
    UPDATE = "update",
    DELETE = "delete"
}
export declare enum WebhookEvents {
    AFTER = "after",
    BEFORE = "before",
    MANUAL = "manual",
    VIEW = "view",
    FIELD = "field"
}
export declare enum ViewSettingOverrideOptions {
    FIELD_VISIBILITY = "fieldVisibility",
    FIELD_ORDER = "fieldOrder",
    COLUMN_WIDTH = "columnWidth",
    ROW_HEIGHT = "rowHeight",
    FILTER_CONDITION = "filterCondition",
    SORT = "sort",
    GROUP = "group",
    ROW_COLORING = "rowColoring"
}
export declare enum MetaEventType {
    COLUMN_ADDED = "COLUMN_ADDED",
    COLUMN_UPDATED = "COLUMN_UPDATED",
    COLUMN_DELETED = "COLUMN_DELETED"
}
export declare enum MetaEntityType {
    BASE = "BASE",
    TABLE = "TABLE",
    COLUMN = "COLUMN",
    VIEW = "VIEW",
    FILTER = "FILTER",
    SORT = "SORT",
    VIEW_ROW_COLOR = "VIEW_ROW_COLOR"
}
