export var OrgUserRoles;
(function (OrgUserRoles) {
    OrgUserRoles["SUPER_ADMIN"] = "super";
    OrgUserRoles["CREATOR"] = "org-level-creator";
    OrgUserRoles["VIEWER"] = "org-level-viewer";
})(OrgUserRoles || (OrgUserRoles = {}));
export var CloudOrgUserRoles;
(function (CloudOrgUserRoles) {
    CloudOrgUserRoles["CREATOR"] = "cloud-org-level-creator";
    CloudOrgUserRoles["VIEWER"] = "cloud-org-level-viewer";
    CloudOrgUserRoles["OWNER"] = "cloud-org-level-owner";
})(CloudOrgUserRoles || (CloudOrgUserRoles = {}));
export var ProjectRoles;
(function (ProjectRoles) {
    ProjectRoles["OWNER"] = "owner";
    ProjectRoles["CREATOR"] = "creator";
    ProjectRoles["INHERIT"] = "inherit";
    ProjectRoles["EDITOR"] = "editor";
    ProjectRoles["COMMENTER"] = "commenter";
    ProjectRoles["VIEWER"] = "viewer";
    ProjectRoles["NO_ACCESS"] = "no-access";
})(ProjectRoles || (ProjectRoles = {}));
export var WorkspaceUserRoles;
(function (WorkspaceUserRoles) {
    WorkspaceUserRoles["OWNER"] = "workspace-level-owner";
    WorkspaceUserRoles["CREATOR"] = "workspace-level-creator";
    WorkspaceUserRoles["INHERIT"] = "workspace-level-inherit";
    WorkspaceUserRoles["EDITOR"] = "workspace-level-editor";
    WorkspaceUserRoles["COMMENTER"] = "workspace-level-commenter";
    WorkspaceUserRoles["VIEWER"] = "workspace-level-viewer";
    WorkspaceUserRoles["NO_ACCESS"] = "workspace-level-no-access";
})(WorkspaceUserRoles || (WorkspaceUserRoles = {}));
export var TeamUserRoles;
(function (TeamUserRoles) {
    TeamUserRoles["MEMBER"] = "member";
    TeamUserRoles["OWNER"] = "owner";
})(TeamUserRoles || (TeamUserRoles = {}));
export var AppEvents;
(function (AppEvents) {
    AppEvents["PROJECT_CREATE"] = "base.create";
    AppEvents["PROJECT_INVITE"] = "base.invite";
    AppEvents["PROJECT_USER_UPDATE"] = "base.user.update";
    AppEvents["PROJECT_USER_RESEND_INVITE"] = "base.user.resend.invite";
    AppEvents["PROJECT_TEAM_INVITE"] = "base.team.invite";
    AppEvents["PROJECT_TEAM_UPDATE"] = "base.team.update";
    AppEvents["PROJECT_TEAM_DELETE"] = "base.team.delete";
    AppEvents["PROJECT_DELETE"] = "base.delete";
    AppEvents["PROJECT_UPDATE"] = "base.update";
    AppEvents["PROJECT_CLONE"] = "base.clone";
    AppEvents["WELCOME"] = "app.welcome";
    AppEvents["WORKSPACE_USER_INVITE"] = "workspace.invite";
    AppEvents["WORKSPACE_USER_UPDATE"] = "workspace.user.update";
    AppEvents["WORKSPACE_USER_DELETE"] = "workspace.user.delete";
    AppEvents["WORKSPACE_TEAM_INVITE"] = "workspace.team.invite";
    AppEvents["WORKSPACE_TEAM_UPDATE"] = "workspace.team.update";
    AppEvents["WORKSPACE_TEAM_DELETE"] = "workspace.team.delete";
    AppEvents["WORKSPACE_CREATE"] = "workspace.create";
    AppEvents["WORKSPACE_DELETE"] = "workspace.delete";
    AppEvents["WORKSPACE_UPDATE"] = "workspace.update";
    AppEvents["WORKSPACE_UPGRADE_REQUEST"] = "workspace.upgrade.request";
    AppEvents["USER_SIGNUP"] = "user.signup";
    AppEvents["USER_SIGNIN"] = "user.signin";
    AppEvents["USER_INVITE"] = "user.invite";
    AppEvents["USER_UPDATE"] = "user.update";
    AppEvents["USER_PASSWORD_RESET"] = "user.password.reset";
    AppEvents["USER_PASSWORD_CHANGE"] = "user.password.change";
    AppEvents["USER_PASSWORD_FORGOT"] = "user.password.forgot";
    AppEvents["USER_DELETE"] = "user.delete";
    AppEvents["USER_EMAIL_VERIFICATION"] = "user.email.verification";
    AppEvents["TEAM_CREATE"] = "team.create";
    AppEvents["TEAM_UPDATE"] = "team.update";
    AppEvents["TEAM_DELETE"] = "team.delete";
    AppEvents["TEAM_MEMBER_ADD"] = "team.member.add";
    AppEvents["TEAM_MEMBER_UPDATE"] = "team.member.update";
    AppEvents["TEAM_MEMBER_DELETE"] = "team.member.delete";
    AppEvents["TABLE_CREATE"] = "table.create";
    AppEvents["TABLE_DELETE"] = "table.delete";
    AppEvents["TABLE_UPDATE"] = "table.update";
    AppEvents["VIEW_CREATE"] = "view.create";
    AppEvents["VIEW_DELETE"] = "view.delete";
    AppEvents["VIEW_UPDATE"] = "view.update";
    AppEvents["SHARED_VIEW_CREATE"] = "shared.view.create";
    AppEvents["SHARED_VIEW_DELETE"] = "shared.view.delete";
    AppEvents["SHARED_VIEW_UPDATE"] = "shared.view.update";
    AppEvents["FILTER_CREATE"] = "filter.create";
    AppEvents["FILTER_DELETE"] = "filter.delete";
    AppEvents["FILTER_UPDATE"] = "filter.update";
    AppEvents["SORT_CREATE"] = "sort.create";
    AppEvents["SORT_DELETE"] = "sort.delete";
    AppEvents["SORT_UPDATE"] = "sort.update";
    AppEvents["COLUMN_CREATE"] = "column.create";
    AppEvents["COLUMN_DELETE"] = "column.delete";
    AppEvents["COLUMN_UPDATE"] = "column.update";
    AppEvents["DATA_CREATE"] = "data.create";
    AppEvents["DATA_DELETE"] = "data.delete";
    AppEvents["DATA_UPDATE"] = "data.update";
    AppEvents["ORG_USER_INVITE"] = "org.user.invite";
    AppEvents["ORG_USER_RESEND_INVITE"] = "org.user.resend.invite";
    AppEvents["VIEW_COLUMN_CREATE"] = "view.column.create";
    AppEvents["VIEW_COLUMN_UPDATE"] = "view.column.update";
    AppEvents["API_TOKEN_CREATE"] = "api.token.create";
    AppEvents["API_TOKEN_DELETE"] = "api.token.delete";
    AppEvents["API_TOKEN_UPDATE"] = "api.token.update";
    AppEvents["IMAGE_UPLOAD"] = "image.upload";
    AppEvents["FORM_COLUMN_UPDATE"] = "form.column.update";
    AppEvents["FORM_CREATE"] = "form.create";
    AppEvents["FORM_UPDATE"] = "form.update";
    AppEvents["GALLERY_CREATE"] = "gallery.create";
    AppEvents["GALLERY_UPDATE"] = "gallery.update";
    AppEvents["MAP_CREATE"] = "map.create";
    AppEvents["MAP_UPDATE"] = "map.update";
    AppEvents["MAP_DELETE"] = "map.delete";
    AppEvents["KANBAN_CREATE"] = "kanban.create";
    AppEvents["KANBAN_UPDATE"] = "kanban.update";
    AppEvents["META_DIFF_SYNC"] = "meta.diff.sync";
    AppEvents["GRID_CREATE"] = "grid.create";
    AppEvents["GRID_UPDATE"] = "grid.update";
    AppEvents["GRID_COLUMN_UPDATE"] = "grid.column.update";
    AppEvents["WEBHOOK_CREATE"] = "webhook.create";
    AppEvents["WEBHOOK_UPDATE"] = "webhook.update";
    AppEvents["WEBHOOK_DELETE"] = "webhook.delete";
    AppEvents["WEBHOOK_TEST"] = "webhook.test";
    AppEvents["WEBHOOK_TRIGGER"] = "webhook.trigger";
    AppEvents["UI_ACL_UPDATE"] = "ui.acl.update";
    AppEvents["ORG_API_TOKEN_CREATE"] = "org.api.token.create";
    AppEvents["ORG_API_TOKEN_DELETE"] = "org.api.token.delete";
    AppEvents["ORG_API_TOKEN_UPDATE"] = "org.api.token.update";
    AppEvents["PLUGIN_TEST"] = "plugin.test";
    AppEvents["PLUGIN_INSTALL"] = "plugin.install";
    AppEvents["PLUGIN_UNINSTALL"] = "plugin.uninstall";
    AppEvents["SYNC_SOURCE_CREATE"] = "sync.source.create";
    AppEvents["SYNC_SOURCE_UPDATE"] = "sync.source.update";
    AppEvents["SYNC_SOURCE_DELETE"] = "sync.source.delete";
    AppEvents["RELATION_DELETE"] = "relation.delete";
    AppEvents["RELATION_CREATE"] = "relation.create";
    AppEvents["SHARED_BASE_GENERATE_LINK"] = "shared.base.generate.link";
    AppEvents["SHARED_BASE_DELETE_LINK"] = "shared.base.delete.link";
    AppEvents["ATTACHMENT_UPLOAD"] = "attachment.upload";
    AppEvents["APIS_CREATED"] = "apis.created";
    AppEvents["EXTENSION_CREATE"] = "extension.create";
    AppEvents["EXTENSION_UPDATE"] = "extension.update";
    AppEvents["EXTENSION_DELETE"] = "extension.delete";
    AppEvents["COMMENT_CREATE"] = "comment.create";
    AppEvents["COMMENT_DELETE"] = "comment.delete";
    AppEvents["COMMENT_UPDATE"] = "comment.update";
    AppEvents["INTEGRATION_DELETE"] = "integration.delete";
    AppEvents["INTEGRATION_CREATE"] = "integration.create";
    AppEvents["INTEGRATION_UPDATE"] = "integration.update";
    AppEvents["ROW_USER_MENTION"] = "row.user.mention";
    AppEvents["CALENDAR_CREATE"] = "calendar.create";
    AppEvents["FORM_DUPLICATE"] = "form.duplicate";
    AppEvents["CALENDAR_UPDATE"] = "calendar.update";
    AppEvents["CALENDAR_DELETE"] = "calendar.delete";
    AppEvents["FORM_DELETE"] = "form.delete";
    AppEvents["SOURCE_CREATE"] = "source.create";
    AppEvents["SOURCE_UPDATE"] = "source.update";
    AppEvents["SOURCE_DELETE"] = "source.delete";
    AppEvents["SHARED_BASE_REVOKE_LINK"] = "shared.base.revoke.link";
    AppEvents["GRID_DELETE"] = "grid.delete";
    AppEvents["GRID_DUPLICATE"] = "grid.duplicate";
    AppEvents["KANBAN_DELETE"] = "kanban.delete";
    AppEvents["KANBAN_DUPLICATE"] = "kanban.duplicate";
    AppEvents["GALLERY_DELETE"] = "gallery.delete";
    AppEvents["GALLERY_DUPLICATE"] = "gallery.duplicate";
    AppEvents["BASE_DUPLICATE_START"] = "base.duplicate.start";
    AppEvents["BASE_DUPLICATE_COMPLETE"] = "base.duplicate.complete";
    AppEvents["BASE_DUPLICATE_FAIL"] = "base.duplicate.fail";
    AppEvents["TABLE_DUPLICATE_START"] = "table.duplicate.start";
    AppEvents["TABLE_DUPLICATE_COMPLETE"] = "table.duplicate.complete";
    AppEvents["TABLE_DUPLICATE_FAIL"] = "table.duplicate.fail";
    AppEvents["COLUMN_DUPLICATE_START"] = "column.duplicate.start";
    AppEvents["COLUMN_DUPLICATE_COMPLETE"] = "column.duplicate.complete";
    AppEvents["COLUMN_DUPLICATE_FAIL"] = "column.duplicate.fail";
    AppEvents["VIEW_DUPLICATE_START"] = "view.duplicate.start";
    AppEvents["VIEW_DUPLICATE_COMPLETE"] = "view.duplicate.complete";
    AppEvents["VIEW_DUPLICATE_FAIL"] = "view.duplicate.fail";
    AppEvents["USER_SIGNOUT"] = "user.signout";
    AppEvents["PROJECT_USER_DELETE"] = "base.user.delete";
    AppEvents["UI_ACL"] = "model.role.ui.acl";
    AppEvents["SNAPSHOT_CREATE"] = "snapshot.create";
    AppEvents["SNAPSHOT_DELETE"] = "snapshot.delete";
    AppEvents["SNAPSHOT_RESTORE"] = "snapshot.restore";
    AppEvents["DATA_EXPORT"] = "data.export";
    AppEvents["DATA_IMPORT"] = "data.import";
    AppEvents["USER_PROFILE_UPDATE"] = "user.profile.update";
    AppEvents["SCRIPT_CREATE"] = "script.create";
    AppEvents["SCRIPT_DELETE"] = "script.delete";
    AppEvents["SCRIPT_UPDATE"] = "script.update";
    AppEvents["SCRIPT_DUPLICATE"] = "script.duplicate";
    AppEvents["DASHBOARD_CREATE"] = "dashboard.create";
    AppEvents["DASHBOARD_UPDATE"] = "dashboard.update";
    AppEvents["DASHBOARD_DELETE"] = "dashboard.delete";
    AppEvents["SHARED_DASHBOARD_GENERATE_LINK"] = "shared.dashboard.generate.link";
    AppEvents["SHARED_DASHBOARD_UPDATE_LINK"] = "shared.dashboard.update.link";
    AppEvents["SHARED_DASHBOARD_DELETE_LINK"] = "shared.dashboard.delete.link";
    AppEvents["DASHBOARD_DUPLICATE_START"] = "dashboard.duplicate.start";
    AppEvents["DASHBOARD_DUPLICATE_COMPLETE"] = "dashboard.duplicate.complete";
    AppEvents["DASHBOARD_DUPLICATE_FAIL"] = "dashboard.duplicate.fail";
    AppEvents["WIDGET_CREATE"] = "widget.create";
    AppEvents["WIDGET_UPDATE"] = "widget.update";
    AppEvents["WIDGET_DELETE"] = "widget.delete";
    AppEvents["WIDGET_DUPLICATE"] = "widget.duplicate";
    AppEvents["PERMISSION_CREATE"] = "permission.create";
    AppEvents["PERMISSION_UPDATE"] = "permission.update";
    AppEvents["PERMISSION_DELETE"] = "permission.delete";
    AppEvents["WORKFLOW_CREATE"] = "workflow.create";
    AppEvents["WORKFLOW_UPDATE"] = "workflow.update";
    AppEvents["WORKFLOW_DELETE"] = "workflow.delete";
    AppEvents["WORKFLOW_DUPLICATE"] = "workflow.duplicate";
    AppEvents["WORKFLOW_EXECUTE"] = "workflow.execute";
})(AppEvents || (AppEvents = {}));
export var ClickhouseTables;
(function (ClickhouseTables) {
    ClickhouseTables["API_CALLS"] = "usage_api_calls";
    ClickhouseTables["API_COUNT"] = "usage_api_count";
    ClickhouseTables["NOTIFICATION"] = "nc_notification";
    ClickhouseTables["PAGE_SNAPSHOT"] = "docs_page_snapshot";
    ClickhouseTables["TELEMETRY"] = "usage_telemetry";
    ClickhouseTables["AUDIT"] = "nc_audit";
})(ClickhouseTables || (ClickhouseTables = {}));
export var WorkspaceStatus;
(function (WorkspaceStatus) {
    WorkspaceStatus[WorkspaceStatus["CREATING"] = 0] = "CREATING";
    WorkspaceStatus[WorkspaceStatus["CREATED"] = 1] = "CREATED";
    WorkspaceStatus[WorkspaceStatus["DELETING"] = 2] = "DELETING";
    WorkspaceStatus[WorkspaceStatus["DELETED"] = 3] = "DELETED";
    WorkspaceStatus[WorkspaceStatus["FAILED"] = 4] = "FAILED";
})(WorkspaceStatus || (WorkspaceStatus = {}));
export var WorkspacePlan;
(function (WorkspacePlan) {
    WorkspacePlan["FREE"] = "free";
    WorkspacePlan["TEAM"] = "team";
    WorkspacePlan["BUSINESS"] = "business";
})(WorkspacePlan || (WorkspacePlan = {}));
export const RoleLabels = {
    [WorkspaceUserRoles.OWNER]: 'owner',
    [WorkspaceUserRoles.CREATOR]: 'creator',
    [WorkspaceUserRoles.EDITOR]: 'editor',
    [WorkspaceUserRoles.COMMENTER]: 'commenter',
    [WorkspaceUserRoles.VIEWER]: 'viewer',
    [WorkspaceUserRoles.INHERIT]: 'inherit',
    [WorkspaceUserRoles.NO_ACCESS]: 'noaccess',
    [ProjectRoles.OWNER]: 'owner',
    [ProjectRoles.CREATOR]: 'creator',
    [ProjectRoles.EDITOR]: 'editor',
    [ProjectRoles.COMMENTER]: 'commenter',
    [ProjectRoles.VIEWER]: 'viewer',
    [ProjectRoles.INHERIT]: 'inherit',
    [ProjectRoles.NO_ACCESS]: 'noaccess',
    [OrgUserRoles.SUPER_ADMIN]: 'superAdmin',
    [OrgUserRoles.CREATOR]: 'creator',
    [OrgUserRoles.VIEWER]: 'viewer',
    [CloudOrgUserRoles.OWNER]: 'owner',
    [CloudOrgUserRoles.CREATOR]: 'creator',
    [CloudOrgUserRoles.VIEWER]: 'viewer',
};
export const RoleColors = {
    [WorkspaceUserRoles.OWNER]: 'purple',
    [WorkspaceUserRoles.CREATOR]: 'blue',
    [WorkspaceUserRoles.EDITOR]: 'green',
    [WorkspaceUserRoles.COMMENTER]: 'orange',
    [WorkspaceUserRoles.VIEWER]: 'yellow',
    [WorkspaceUserRoles.INHERIT]: 'gray',
    [WorkspaceUserRoles.NO_ACCESS]: 'red',
    [ProjectRoles.OWNER]: 'purple',
    [ProjectRoles.CREATOR]: 'blue',
    [ProjectRoles.EDITOR]: 'green',
    [ProjectRoles.COMMENTER]: 'orange',
    [ProjectRoles.VIEWER]: 'yellow',
    [ProjectRoles.INHERIT]: 'gray',
    [OrgUserRoles.SUPER_ADMIN]: 'maroon',
    [ProjectRoles.NO_ACCESS]: 'red',
    [OrgUserRoles.CREATOR]: 'blue',
    [OrgUserRoles.VIEWER]: 'yellow',
    [CloudOrgUserRoles.OWNER]: 'purple',
    [CloudOrgUserRoles.CREATOR]: 'blue',
    [CloudOrgUserRoles.VIEWER]: 'yellow',
};
export const RoleDescriptions = {
    [WorkspaceUserRoles.OWNER]: 'Has full control over all workspace bases, settings, and billing',
    [WorkspaceUserRoles.CREATOR]: 'Can create, configure, and edit all bases within the workspace',
    [WorkspaceUserRoles.EDITOR]: 'Can add, edit, and delete records, but cannot modify base configurations',
    [WorkspaceUserRoles.COMMENTER]: 'Can view and comment on records within workspace bases',
    [WorkspaceUserRoles.VIEWER]: 'Can only view records within workspace bases',
    [WorkspaceUserRoles.INHERIT]: 'Inherits role from workspace-level team assignment',
    [WorkspaceUserRoles.NO_ACCESS]: 'No access to this workspace',
    [ProjectRoles.OWNER]: 'Has full control over the base, including configuration and deletion rights',
    [ProjectRoles.CREATOR]: 'Can fully configure the base but cannot delete it',
    [ProjectRoles.EDITOR]: 'Can add, edit, and delete records, but cannot modify base configurations',
    [ProjectRoles.COMMENTER]: 'Can view and comment on records within the base',
    [ProjectRoles.VIEWER]: 'Can only view records within the base',
    [ProjectRoles.INHERIT]: 'Inherits role from base-level team, or workspace level if no base-level team',
    [ProjectRoles.NO_ACCESS]: 'No access to this base',
    [OrgUserRoles.SUPER_ADMIN]: 'Full access to all',
    [OrgUserRoles.CREATOR]: 'Can fully configure and edit bases',
    [OrgUserRoles.VIEWER]: 'Can only view records in bases',
    [CloudOrgUserRoles.OWNER]: 'Full access to organization and workspaces',
    [CloudOrgUserRoles.CREATOR]: 'Can create and manage domains, users and workspaces',
    [CloudOrgUserRoles.VIEWER]: 'Can only view organization and workspaces',
};
export const RoleIcons = {
    [WorkspaceUserRoles.OWNER]: 'role_owner',
    [WorkspaceUserRoles.CREATOR]: 'role_creator',
    [WorkspaceUserRoles.EDITOR]: 'role_editor',
    [WorkspaceUserRoles.COMMENTER]: 'role_commenter',
    [WorkspaceUserRoles.VIEWER]: 'role_viewer',
    [WorkspaceUserRoles.INHERIT]: 'role_inherit',
    [WorkspaceUserRoles.NO_ACCESS]: 'role_no_access',
    [ProjectRoles.OWNER]: 'role_owner',
    [ProjectRoles.CREATOR]: 'role_creator',
    [ProjectRoles.EDITOR]: 'role_editor',
    [ProjectRoles.COMMENTER]: 'role_commenter',
    [ProjectRoles.VIEWER]: 'role_viewer',
    [ProjectRoles.INHERIT]: 'role_inherit',
    [ProjectRoles.NO_ACCESS]: 'role_no_access',
    [OrgUserRoles.SUPER_ADMIN]: 'role_super',
    [OrgUserRoles.CREATOR]: 'role_creator',
    [OrgUserRoles.VIEWER]: 'role_viewer',
    [CloudOrgUserRoles.OWNER]: 'role_owner',
    [CloudOrgUserRoles.CREATOR]: 'role_creator',
    [CloudOrgUserRoles.VIEWER]: 'role_viewer',
};
export const WorkspaceRolesToProjectRoles = {
    [WorkspaceUserRoles.OWNER]: ProjectRoles.OWNER,
    [WorkspaceUserRoles.CREATOR]: ProjectRoles.CREATOR,
    [WorkspaceUserRoles.EDITOR]: ProjectRoles.EDITOR,
    [WorkspaceUserRoles.COMMENTER]: ProjectRoles.COMMENTER,
    [WorkspaceUserRoles.VIEWER]: ProjectRoles.VIEWER,
    [WorkspaceUserRoles.NO_ACCESS]: ProjectRoles.NO_ACCESS,
    [WorkspaceUserRoles.INHERIT]: ProjectRoles.INHERIT,
};
export const OrderedWorkspaceRoles = [
    WorkspaceUserRoles.OWNER,
    WorkspaceUserRoles.CREATOR,
    WorkspaceUserRoles.INHERIT,
    WorkspaceUserRoles.EDITOR,
    WorkspaceUserRoles.COMMENTER,
    WorkspaceUserRoles.VIEWER,
    WorkspaceUserRoles.NO_ACCESS,
];
export const OrderedOrgRoles = [
    OrgUserRoles.SUPER_ADMIN,
    OrgUserRoles.CREATOR,
    OrgUserRoles.VIEWER,
];
export const OrderedProjectRoles = [
    ProjectRoles.OWNER,
    ProjectRoles.CREATOR,
    ProjectRoles.INHERIT,
    ProjectRoles.EDITOR,
    ProjectRoles.COMMENTER,
    ProjectRoles.VIEWER,
    ProjectRoles.NO_ACCESS,
];
export var APIContext;
(function (APIContext) {
    APIContext["VIEW_COLUMNS"] = "fields";
    APIContext["FILTERS"] = "filters";
    APIContext["SORTS"] = "sorts";
})(APIContext || (APIContext = {}));
export var SourceRestriction;
(function (SourceRestriction) {
    SourceRestriction["SCHEMA_READONLY"] = "is_schema_readonly";
    SourceRestriction["DATA_READONLY"] = "is_data_readonly";
})(SourceRestriction || (SourceRestriction = {}));
export var ClientType;
(function (ClientType) {
    ClientType["MYSQL"] = "mysql2";
    ClientType["PG"] = "pg";
    ClientType["SQLITE"] = "sqlite3";
    ClientType["VITESS"] = "vitess";
    ClientType["SNOWFLAKE"] = "snowflake";
    ClientType["DATABRICKS"] = "databricks";
})(ClientType || (ClientType = {}));
export var SSLUsage;
(function (SSLUsage) {
    SSLUsage["No"] = "No";
    SSLUsage["Allowed"] = "Allowed";
    SSLUsage["Preferred"] = "Preferred";
    SSLUsage["Required"] = "Required";
    SSLUsage["RequiredWithCa"] = "Required-CA";
    SSLUsage["RequiredWithIdentity"] = "Required-Identity";
})(SSLUsage || (SSLUsage = {}));
export var SyncDataType;
(function (SyncDataType) {
    // Database
    SyncDataType["NOCODB"] = "nocodb";
    SyncDataType["MICROSOFT_ACCESS"] = "microsoft-access";
    SyncDataType["TABLEAU"] = "tableau";
    SyncDataType["ORACLE"] = "oracle";
    // AI
    SyncDataType["OPENAI"] = "openai";
    SyncDataType["CLAUDE"] = "claude";
    SyncDataType["OLLAMA"] = "ollama";
    SyncDataType["GROQ"] = "groq";
    // Communication
    SyncDataType["SLACK"] = "slack";
    SyncDataType["DISCORD"] = "discord";
    SyncDataType["TWILLO"] = "twillo";
    SyncDataType["MICROSOFT_OUTLOOK"] = "microsoft-outlook";
    SyncDataType["MICROSOFT_TEAMS"] = "microsoft-teams";
    SyncDataType["TELEGRAM"] = "telegram";
    SyncDataType["GMAIL"] = "gmail";
    SyncDataType["WHATSAPP"] = "whatsapp";
    // Project Management
    SyncDataType["ASANA"] = "asana";
    SyncDataType["JIRA"] = "jira";
    SyncDataType["MIRO"] = "miro";
    SyncDataType["TRELLO"] = "trello";
    // CRM
    SyncDataType["SALESFORCE"] = "salesforce";
    SyncDataType["PIPEDRIVE"] = "pipedrive";
    SyncDataType["MICROSOFT_DYNAMICS_365"] = "microsoft-dynamics-365";
    SyncDataType["ZOHO_CRM"] = "zoho-crm";
    // Marketing
    SyncDataType["HUBSPOT"] = "hubspot";
    SyncDataType["MAILCHIMP"] = "mailchimp";
    SyncDataType["SURVEYMONKEY"] = "surveymonkey";
    SyncDataType["TYPEFORM"] = "typeform";
    // ATS
    SyncDataType["WORKDAY"] = "workday";
    SyncDataType["GREENHOUSE"] = "greenhouse";
    SyncDataType["LEVER"] = "lever";
    // Development
    SyncDataType["GITHUB"] = "github";
    SyncDataType["GITLAB"] = "gitlab";
    SyncDataType["BITBUCKET"] = "bitbucket";
    // Finance
    SyncDataType["STRIPE"] = "stripe";
    SyncDataType["QUICKBOOKS"] = "quickbooks";
    // Ticketing
    SyncDataType["FRESHDESK"] = "freshdesk";
    SyncDataType["INTERCOM"] = "intercom";
    SyncDataType["ZENDESK"] = "zendesk";
    SyncDataType["HUBSPOT_SERVICE_HUB"] = "hubspot-service-hub";
    SyncDataType["SALESFORCE_SERVICE_CLOUD"] = "salesforce-service-cloud";
    // Storage
    SyncDataType["BOX"] = "box";
    SyncDataType["GOOGLE_DRIVE"] = "google-drive";
    SyncDataType["DROPBOX"] = "dropbox";
    // Others
    SyncDataType["APPLE_NUMBERS"] = "apple-numbers";
    SyncDataType["GOOGLE_CALENDAR"] = "google-calendar";
    SyncDataType["MICROSOFT_EXCEL"] = "microsoft-excel";
    SyncDataType["GOOGLE_SHEETS"] = "google-sheets";
})(SyncDataType || (SyncDataType = {}));
export var IntegrationCategoryType;
(function (IntegrationCategoryType) {
    IntegrationCategoryType["DATABASE"] = "database";
    IntegrationCategoryType["AI"] = "ai";
    IntegrationCategoryType["COMMUNICATION"] = "communication";
    IntegrationCategoryType["SPREAD_SHEET"] = "spread-sheet";
    IntegrationCategoryType["PROJECT_MANAGEMENT"] = "project-management";
    IntegrationCategoryType["CRM"] = "crm";
    IntegrationCategoryType["MARKETING"] = "marketing";
    IntegrationCategoryType["ATS"] = "ats";
    IntegrationCategoryType["DEVELOPMENT"] = "development";
    IntegrationCategoryType["FINANCE"] = "finance";
    IntegrationCategoryType["TICKETING"] = "ticketing";
    IntegrationCategoryType["STORAGE"] = "storage";
    IntegrationCategoryType["OTHERS"] = "others";
    IntegrationCategoryType["SYNC"] = "sync";
    IntegrationCategoryType["AUTH"] = "auth";
})(IntegrationCategoryType || (IntegrationCategoryType = {}));
export var ViewLockType;
(function (ViewLockType) {
    ViewLockType["Personal"] = "personal";
    ViewLockType["Locked"] = "locked";
    ViewLockType["Collaborative"] = "collaborative";
})(ViewLockType || (ViewLockType = {}));
export var PublicAttachmentScope;
(function (PublicAttachmentScope) {
    PublicAttachmentScope["WORKSPACEPICS"] = "workspacePics";
    PublicAttachmentScope["PROFILEPICS"] = "profilePics";
    PublicAttachmentScope["ORGANIZATIONPICS"] = "organizationPics";
    PublicAttachmentScope["OAUTHCLIENTS"] = "oauthClients";
})(PublicAttachmentScope || (PublicAttachmentScope = {}));
export var IconType;
(function (IconType) {
    IconType["IMAGE"] = "IMAGE";
    IconType["EMOJI"] = "EMOJI";
    IconType["ICON"] = "ICON";
})(IconType || (IconType = {}));
export var NcApiVersion;
(function (NcApiVersion) {
    NcApiVersion[NcApiVersion["V1"] = 0] = "V1";
    NcApiVersion[NcApiVersion["V2"] = 1] = "V2";
    NcApiVersion[NcApiVersion["V3"] = 2] = "V3";
})(NcApiVersion || (NcApiVersion = {}));
export var HookOperationCode;
(function (HookOperationCode) {
    HookOperationCode[HookOperationCode["insert"] = 1] = "insert";
    HookOperationCode[HookOperationCode["update"] = 2] = "update";
    HookOperationCode[HookOperationCode["delete"] = 4] = "delete";
    HookOperationCode[HookOperationCode["trigger"] = 8] = "trigger";
})(HookOperationCode || (HookOperationCode = {}));
export var WebhookActions;
(function (WebhookActions) {
    WebhookActions["INSERT"] = "insert";
    WebhookActions["UPDATE"] = "update";
    WebhookActions["DELETE"] = "delete";
})(WebhookActions || (WebhookActions = {}));
export var WebhookEvents;
(function (WebhookEvents) {
    WebhookEvents["AFTER"] = "after";
    WebhookEvents["BEFORE"] = "before";
    WebhookEvents["MANUAL"] = "manual";
    WebhookEvents["VIEW"] = "view";
    WebhookEvents["FIELD"] = "field";
})(WebhookEvents || (WebhookEvents = {}));
export var ViewSettingOverrideOptions;
(function (ViewSettingOverrideOptions) {
    ViewSettingOverrideOptions["FIELD_VISIBILITY"] = "fieldVisibility";
    ViewSettingOverrideOptions["FIELD_ORDER"] = "fieldOrder";
    ViewSettingOverrideOptions["COLUMN_WIDTH"] = "columnWidth";
    ViewSettingOverrideOptions["ROW_HEIGHT"] = "rowHeight";
    ViewSettingOverrideOptions["FILTER_CONDITION"] = "filterCondition";
    ViewSettingOverrideOptions["SORT"] = "sort";
    ViewSettingOverrideOptions["GROUP"] = "group";
    ViewSettingOverrideOptions["ROW_COLORING"] = "rowColoring";
})(ViewSettingOverrideOptions || (ViewSettingOverrideOptions = {}));
export var MetaEventType;
(function (MetaEventType) {
    MetaEventType["COLUMN_ADDED"] = "COLUMN_ADDED";
    MetaEventType["COLUMN_UPDATED"] = "COLUMN_UPDATED";
    MetaEventType["COLUMN_DELETED"] = "COLUMN_DELETED";
})(MetaEventType || (MetaEventType = {}));
export var MetaEntityType;
(function (MetaEntityType) {
    MetaEntityType["BASE"] = "BASE";
    MetaEntityType["TABLE"] = "TABLE";
    MetaEntityType["COLUMN"] = "COLUMN";
    MetaEntityType["VIEW"] = "VIEW";
    MetaEntityType["FILTER"] = "FILTER";
    MetaEntityType["SORT"] = "SORT";
    MetaEntityType["VIEW_ROW_COLOR"] = "VIEW_ROW_COLOR";
})(MetaEntityType || (MetaEntityType = {}));
//# sourceMappingURL=data:application/json;base64,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