import { NcBaseErrorv2 } from '../../lib/error/nc-base.error';
import { presetErrorCodexMap } from '../../lib/error-handler/preset-error-codex-map';
export class NcErrorCodexManager {
    constructor() {
        this.errorCodexMap = {};
        this.setErrorCodexes(presetErrorCodexMap);
    }
    setErrorCodex(errorType, handler) {
        this.errorCodexMap[errorType] = handler;
    }
    setErrorCodexes(handlers) {
        this.errorCodexMap = Object.assign(Object.assign({}, this.errorCodexMap), handlers);
    }
    generateError(error, args) {
        const errorHelper = this.errorCodexMap[error];
        const { params, customMessage, details } = args || {};
        if (!errorHelper) {
            return {
                message: 'An error occurred',
                code: 500,
                details: details,
            };
        }
        let message;
        const messageHelper = customMessage || errorHelper.message;
        if (typeof messageHelper === 'function') {
            message = messageHelper(...(Array.isArray(params) ? params : [params]));
        }
        else {
            message = messageHelper;
        }
        return new NcBaseErrorv2(message, errorHelper.code, error, {
            details: details,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmMtZXJyb3ItY29kZXgtbWFuYWdlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvZXJyb3ItaGFuZGxlci9uYy1lcnJvci1jb2RleC1tYW5hZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxhQUFhLEVBQWUsTUFBTSwyQkFBMkIsQ0FBQztBQUV2RSxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSw0Q0FBNEMsQ0FBQztBQUVqRixNQUFNLE9BQU8sbUJBQW1CO0lBQzlCO1FBSUEsa0JBQWEsR0FTVCxFQUFFLENBQUM7UUFaTCxJQUFJLENBQUMsZUFBZSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQWFELGFBQWEsQ0FDWCxTQUFzQixFQUN0QixPQUlDO1FBRUQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsR0FBRyxPQUFPLENBQUM7SUFDMUMsQ0FBQztJQUVELGVBQWUsQ0FDYixRQVNDO1FBRUQsSUFBSSxDQUFDLGFBQWEsbUNBQVEsSUFBSSxDQUFDLGFBQWEsR0FBSyxRQUFRLENBQUUsQ0FBQztJQUM5RCxDQUFDO0lBRUQsYUFBYSxDQUFDLEtBQWtCLEVBQUUsSUFBa0I7UUFDbEQsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5QyxNQUFNLEVBQUUsTUFBTSxFQUFFLGFBQWEsRUFBRSxPQUFPLEVBQUUsR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDO1FBRXRELElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNqQixPQUFPO2dCQUNMLE9BQU8sRUFBRSxtQkFBbUI7Z0JBQzVCLElBQUksRUFBRSxHQUFHO2dCQUNULE9BQU8sRUFBRSxPQUFPO2FBQ2pCLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxPQUFlLENBQUM7UUFDcEIsTUFBTSxhQUFhLEdBQUcsYUFBYSxJQUFJLFdBQVcsQ0FBQyxPQUFPLENBQUM7UUFFM0QsSUFBSSxPQUFPLGFBQWEsS0FBSyxVQUFVLEVBQUUsQ0FBQztZQUN4QyxPQUFPLEdBQUcsYUFBYSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQzFFLENBQUM7YUFBTSxDQUFDO1lBQ04sT0FBTyxHQUFHLGFBQWEsQ0FBQztRQUMxQixDQUFDO1FBRUQsT0FBTyxJQUFJLGFBQWEsQ0FBQyxPQUFPLEVBQUUsV0FBVyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDekQsT0FBTyxFQUFFLE9BQU87U0FDakIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGIn0=