import { NcSDKErrorV2 } from '../errorUtils';
import { NcErrorType } from '../globals';
import { parseLexingError, parseParsingError, } from '../parser/queryFilter/error-message-parser';
export class InvalidFilterError extends NcSDKErrorV2 {
    constructor(info) {
        var _a;
        let message = (_a = info.message) !== null && _a !== void 0 ? _a : 'Invalid filter';
        if (info.lexingError && info.lexingError.length > 0) {
            const lexingErrorMessage = info.lexingError
                .map((k) => parseLexingError(k))
                .join(', ');
            message = lexingErrorMessage;
        }
        else if (info.parsingError && info.parsingError.length > 0) {
            const parsingErrorMessage = info.parsingError
                .map((k) => parseParsingError(k))
                .join(', ');
            message = parsingErrorMessage;
        }
        super({
            message,
            error: NcErrorType.ERR_INVALID_FILTER,
            getStatus: () => 422,
        });
        this.innerInfo = info;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52YWxpZC1maWx0ZXIuZXJyb3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2Vycm9yL2ludmFsaWQtZmlsdGVyLmVycm9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDN0MsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLFlBQVksQ0FBQztBQUN6QyxPQUFPLEVBQ0wsZ0JBQWdCLEVBQ2hCLGlCQUFpQixHQUNsQixNQUFNLDRDQUE0QyxDQUFDO0FBT3BELE1BQU0sT0FBTyxrQkFBbUIsU0FBUSxZQUFZO0lBQ2xELFlBQVksSUFBNEI7O1FBQ3RDLElBQUksT0FBTyxHQUFHLE1BQUEsSUFBSSxDQUFDLE9BQU8sbUNBQUksZ0JBQWdCLENBQUM7UUFDL0MsSUFBSSxJQUFJLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQ3BELE1BQU0sa0JBQWtCLEdBQUcsSUFBSSxDQUFDLFdBQVc7aUJBQ3hDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUM7aUJBQy9CLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNkLE9BQU8sR0FBRyxrQkFBa0IsQ0FBQztRQUMvQixDQUFDO2FBQU0sSUFBSSxJQUFJLENBQUMsWUFBWSxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO1lBQzdELE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxDQUFDLFlBQVk7aUJBQzFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDLENBQUM7aUJBQ2hDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNkLE9BQU8sR0FBRyxtQkFBbUIsQ0FBQztRQUNoQyxDQUFDO1FBQ0QsS0FBSyxDQUFDO1lBQ0osT0FBTztZQUNQLEtBQUssRUFBRSxXQUFXLENBQUMsa0JBQWtCO1lBQ3JDLFNBQVMsRUFBRSxHQUFHLEVBQUUsQ0FBQyxHQUFHO1NBQ3JCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO0lBQ3hCLENBQUM7Q0FFRiJ9