import { NcErrorType } from '../../lib/globals';
export declare class NcBaseError extends Error {
    constructor(message: string);
}
export declare class BadRequestV2 extends NcBaseError {
}
export declare class NotAllowed extends NcBaseError {
}
export declare class Unauthorized extends NcBaseError {
}
export declare class Forbidden extends NcBaseError {
}
export declare class NotFound extends NcBaseError {
}
export declare class SsoError extends NcBaseError {
}
export declare class MetaError extends NcBaseError {
    constructor(param: {
        message: string;
        sql: string;
    });
}
export declare class ExternalError extends NcBaseError {
    constructor(error: Error);
}
export declare class ExternalTimeout extends ExternalError {
}
export declare class UnprocessableEntity extends NcBaseError {
}
export declare class OptionsNotExistsError extends BadRequestV2 {
    constructor({ columnTitle, options, validOptions, }: {
        columnTitle: string;
        options: string[];
        validOptions: string[];
    });
    columnTitle: string;
    options: string[];
    validOptions: string[];
}
export declare class UniqueConstraintViolationError extends BadRequestV2 {
    constructor({ value, fieldName }: {
        value: string;
        fieldName: string;
    });
    value: string;
    fieldName: string;
}
export declare class TestConnectionError extends NcBaseError {
    sql_code?: string;
    constructor(message: string, sql_code?: string);
}
export type NcErrorArgs = {
    params?: string | string[];
    customMessage?: string | ((...args: string[]) => string);
    details?: any;
};
export declare class NcBaseErrorv2 extends NcBaseError {
    error: NcErrorType;
    code: number;
    details?: any;
    constructor(message: string, code: number, error: NcErrorType, args?: NcErrorArgs);
}
