export class NcBaseError extends Error {
    constructor(message) {
        super(message);
    }
}
export class BadRequestV2 extends NcBaseError {
}
export class NotAllowed extends NcBaseError {
}
export class Unauthorized extends NcBaseError {
}
export class Forbidden extends NcBaseError {
}
export class NotFound extends NcBaseError {
}
export class SsoError extends NcBaseError {
}
export class MetaError extends NcBaseError {
    constructor(param) {
        super(param.message);
        Object.assign(this, param);
    }
}
export class ExternalError extends NcBaseError {
    constructor(error) {
        super(error.message);
        Object.assign(this, error);
    }
}
export class ExternalTimeout extends ExternalError {
}
export class UnprocessableEntity extends NcBaseError {
}
export class OptionsNotExistsError extends BadRequestV2 {
    constructor({ columnTitle, options, validOptions, }) {
        super(`Invalid option(s) "${options.join(', ')}" provided for column "${columnTitle}". Valid options are "${validOptions.join(', ')}"`);
        this.columnTitle = columnTitle;
        this.options = options;
        this.validOptions = validOptions;
    }
}
export class UniqueConstraintViolationError extends BadRequestV2 {
    constructor({ value, fieldName }) {
        let message = `${fieldName} field unique constraint violation. Value '${value}' already exists.`;
        if (value === 'unknown') {
            message = `${fieldName} field unique constraint violation.`;
        }
        super(message);
        this.value = value;
        this.fieldName = fieldName;
    }
}
export class TestConnectionError extends NcBaseError {
    constructor(message, sql_code) {
        super(message);
        this.sql_code = sql_code;
    }
}
export class NcBaseErrorv2 extends NcBaseError {
    constructor(message, code, error, args) {
        super(message);
        this.error = error;
        this.code = code;
        this.details = args === null || args === void 0 ? void 0 : args.details;
    }
}
//# sourceMappingURL=data:application/json;base64,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