var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import UITypes, { isNumericCol, numericUITypes } from '../../lib/UITypes';
import { isDateMonthFormat } from '../../lib/dateTimeHelper';
import { parseProp } from '../../lib/helperFunctions';
export function isDateType(uidt) {
    return [
        UITypes.Date,
        UITypes.DateTime,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
    ].includes(uidt);
}
const getEqText = (fieldUiType) => {
    if (isNumericCol(fieldUiType) || fieldUiType === UITypes.Time) {
        return '=';
    }
    else if ([
        UITypes.SingleSelect,
        UITypes.Collaborator,
        UITypes.LinkToAnotherRecord,
        UITypes.Date,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
        UITypes.DateTime,
    ].includes(fieldUiType)) {
        return 'is';
    }
    return 'is equal';
};
const getNeqText = (fieldUiType) => {
    if (isNumericCol(fieldUiType) || fieldUiType === UITypes.Time) {
        return '!=';
    }
    else if ([
        UITypes.SingleSelect,
        UITypes.Collaborator,
        UITypes.LinkToAnotherRecord,
        UITypes.Date,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
        UITypes.DateTime,
    ].includes(fieldUiType)) {
        return 'is not';
    }
    return 'is not equal';
};
const getLikeText = (fieldUiType) => {
    if (fieldUiType === UITypes.Attachment) {
        return 'filenames contain';
    }
    return 'is like';
};
const getNotLikeText = (fieldUiType) => {
    if (fieldUiType === UITypes.Attachment) {
        return "filenames don't contain";
    }
    return 'is not like';
};
const getGtText = (fieldUiType) => {
    if ([
        UITypes.Date,
        UITypes.DateTime,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is after';
    }
    return '>';
};
const getLtText = (fieldUiType) => {
    if ([
        UITypes.Date,
        UITypes.DateTime,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is before';
    }
    return '<';
};
const getGteText = (fieldUiType) => {
    if ([
        UITypes.Date,
        UITypes.DateTime,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is on or after';
    }
    return '>=';
};
const getLteText = (fieldUiType) => {
    if ([
        UITypes.Date,
        UITypes.DateTime,
        UITypes.CreatedTime,
        UITypes.LastModifiedTime,
    ].includes(fieldUiType)) {
        return 'is on or before';
    }
    return '<=';
};
// Helper functions for type-specific semantic types
const getTypeSpecificSemantic = (baseSemantic, fieldUiType) => {
    if (isNumericCol(fieldUiType)) {
        return `${baseSemantic}_numeric`;
    }
    else if (isDateType(fieldUiType)) {
        return `${baseSemantic}_date`;
    }
    else if ([
        UITypes.SingleLineText,
        UITypes.LongText,
        UITypes.Email,
        UITypes.PhoneNumber,
        UITypes.URL,
    ].includes(fieldUiType)) {
        return `${baseSemantic}_text`;
    }
    else if ([UITypes.SingleSelect, UITypes.MultiSelect].includes(fieldUiType)) {
        return `${baseSemantic}_select`;
    }
    else if ([UITypes.Checkbox].includes(fieldUiType)) {
        return `${baseSemantic}_boolean`;
    }
    else if ([UITypes.User, UITypes.CreatedBy, UITypes.LastModifiedBy].includes(fieldUiType)) {
        return `${baseSemantic}_user`;
    }
    else if ([UITypes.Attachment].includes(fieldUiType)) {
        return `${baseSemantic}_attachment`;
    }
    else if ([UITypes.LinkToAnotherRecord, UITypes.Lookup].includes(fieldUiType)) {
        return `${baseSemantic}_link`;
    }
    return baseSemantic; // fallback to base semantic
};
export const comparisonOpList = (fieldUiType, _dateFormat) => [
    {
        text: 'is checked',
        value: 'checked',
        ignoreVal: true,
        includedTypes: [UITypes.Checkbox],
        semanticType: 'boolean_equality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('equality', fieldUiType),
    },
    {
        text: 'is not checked',
        value: 'notchecked',
        ignoreVal: true,
        includedTypes: [UITypes.Checkbox],
        semanticType: 'boolean_inequality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('inequality', fieldUiType),
    },
    {
        text: getEqText(fieldUiType),
        value: 'eq',
        ignoreVal: false,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.MultiSelect,
            UITypes.Attachment,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'equality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('equality', fieldUiType),
    },
    {
        text: getNeqText(fieldUiType),
        value: 'neq',
        ignoreVal: false,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.MultiSelect,
            UITypes.Attachment,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'inequality',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('inequality', fieldUiType),
    },
    {
        text: getLikeText(fieldUiType),
        value: 'like',
        ignoreVal: false,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
            ...numericUITypes,
        ],
        semanticType: 'pattern_match',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('pattern_match', fieldUiType),
    },
    {
        text: getNotLikeText(fieldUiType),
        value: 'nlike',
        ignoreVal: false,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
            ...numericUITypes,
        ],
        semanticType: 'pattern_not_match',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('pattern_not_match', fieldUiType),
    },
    {
        text: 'is empty',
        value: 'empty',
        ignoreVal: true,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Attachment,
            UITypes.LinkToAnotherRecord,
            UITypes.Lookup,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
            ...numericUITypes,
        ],
        semanticType: 'empty_check',
    },
    {
        text: 'is not empty',
        value: 'notempty',
        ignoreVal: true,
        excludedTypes: [
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Attachment,
            UITypes.LinkToAnotherRecord,
            UITypes.Lookup,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
            ...numericUITypes,
        ],
        semanticType: 'not_empty_check',
    },
    {
        text: 'is null',
        value: 'null',
        ignoreVal: true,
        excludedTypes: [
            ...numericUITypes,
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Attachment,
            UITypes.LinkToAnotherRecord,
            UITypes.Lookup,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
        ],
        semanticType: 'null_check',
    },
    {
        text: 'is not null',
        value: 'notnull',
        ignoreVal: true,
        excludedTypes: [
            ...numericUITypes,
            UITypes.Checkbox,
            UITypes.SingleSelect,
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
            UITypes.Collaborator,
            UITypes.Attachment,
            UITypes.LinkToAnotherRecord,
            UITypes.Lookup,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
            UITypes.Time,
        ],
        semanticType: 'not_null_check',
    },
    {
        text: 'contains all of',
        value: 'allof',
        ignoreVal: false,
        includedTypes: [
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'contains_all',
    },
    {
        text: 'contains any of',
        value: 'anyof',
        ignoreVal: false,
        includedTypes: [
            UITypes.MultiSelect,
            UITypes.SingleSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'contains_any',
    },
    {
        text: 'does not contain all of',
        value: 'nallof',
        ignoreVal: false,
        includedTypes: [
            UITypes.MultiSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'not_contains_all',
    },
    {
        text: 'does not contain any of',
        value: 'nanyof',
        ignoreVal: false,
        includedTypes: [
            UITypes.MultiSelect,
            UITypes.SingleSelect,
            UITypes.User,
            UITypes.CreatedBy,
            UITypes.LastModifiedBy,
        ],
        semanticType: 'not_contains_any',
    },
    {
        text: getGtText(fieldUiType),
        value: 'gt',
        ignoreVal: false,
        includedTypes: [
            ...numericUITypes,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.LastModifiedTime,
            UITypes.CreatedTime,
            UITypes.Time,
        ],
        semanticType: 'greater_than',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('greater_than', fieldUiType),
    },
    {
        text: getLtText(fieldUiType),
        value: 'lt',
        ignoreVal: false,
        includedTypes: [
            ...numericUITypes,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.LastModifiedTime,
            UITypes.CreatedTime,
            UITypes.Time,
        ],
        semanticType: 'less_than',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('less_than', fieldUiType),
    },
    {
        text: getGteText(fieldUiType),
        value: 'gte',
        ignoreVal: false,
        includedTypes: [
            ...numericUITypes,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.LastModifiedTime,
            UITypes.CreatedTime,
            UITypes.Time,
        ],
        semanticType: 'greater_than_or_equal',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('greater_than_or_equal', fieldUiType),
    },
    {
        text: getLteText(fieldUiType),
        value: 'lte',
        ignoreVal: false,
        includedTypes: [
            ...numericUITypes,
            UITypes.Date,
            UITypes.DateTime,
            UITypes.Time,
            UITypes.CreatedTime,
            UITypes.LastModifiedTime,
        ],
        semanticType: 'less_than_or_equal',
        typeSpecificSemantic: (fieldUiType) => getTypeSpecificSemantic('less_than_or_equal', fieldUiType),
    },
    {
        text: 'is within',
        value: 'isWithin',
        ignoreVal: true,
        includedTypes: [
            UITypes.Date,
            UITypes.DateTime,
            UITypes.LastModifiedTime,
            UITypes.CreatedTime,
        ],
        semanticType: 'date_range',
    },
    {
        text: 'is blank',
        value: 'blank',
        ignoreVal: true,
        excludedTypes: [UITypes.Checkbox, UITypes.Links, UITypes.Rollup],
        semanticType: 'blank_check',
    },
    {
        text: 'is not blank',
        value: 'notblank',
        ignoreVal: true,
        excludedTypes: [UITypes.Checkbox, UITypes.Links, UITypes.Rollup],
        semanticType: 'not_blank_check',
    },
];
export const comparisonSubOpList = (
// TODO: type
comparison_op, dateFormat) => {
    const isDateMonth = dateFormat && isDateMonthFormat(dateFormat);
    if (comparison_op === 'isWithin') {
        return [
            {
                text: 'the past week',
                value: 'pastWeek',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the past month',
                value: 'pastMonth',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the past year',
                value: 'pastYear',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the next week',
                value: 'nextWeek',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the next month',
                value: 'nextMonth',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the next year',
                value: 'nextYear',
                ignoreVal: true,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the next number of days',
                value: 'nextNumberOfDays',
                ignoreVal: false,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
            {
                text: 'the past number of days',
                value: 'pastNumberOfDays',
                ignoreVal: false,
                includedTypes: [
                    UITypes.Date,
                    UITypes.DateTime,
                    UITypes.LastModifiedTime,
                    UITypes.CreatedTime,
                ],
            },
        ];
    }
    return [
        {
            text: 'today',
            value: 'today',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'tomorrow',
            value: 'tomorrow',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'yesterday',
            value: 'yesterday',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one week ago',
            value: 'oneWeekAgo',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one week from now',
            value: 'oneWeekFromNow',
            ignoreVal: true,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'one month ago',
            value: 'oneMonthAgo',
            ignoreVal: true,
            includedTypes: [
                UITypes.Date,
                UITypes.DateTime,
                UITypes.LastModifiedTime,
                UITypes.CreatedTime,
            ],
        },
        {
            text: 'one month from now',
            value: 'oneMonthFromNow',
            ignoreVal: true,
            includedTypes: [
                UITypes.Date,
                UITypes.DateTime,
                UITypes.LastModifiedTime,
                UITypes.CreatedTime,
            ],
        },
        {
            text: 'number of days ago',
            value: 'daysAgo',
            ignoreVal: false,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: 'number of days from now',
            value: 'daysFromNow',
            ignoreVal: false,
            includedTypes: [
                ...(isDateMonth
                    ? []
                    : [
                        UITypes.Date,
                        UITypes.DateTime,
                        UITypes.LastModifiedTime,
                        UITypes.CreatedTime,
                    ]),
            ],
        },
        {
            text: isDateMonth ? 'exact month' : 'exact date',
            value: 'exactDate',
            ignoreVal: false,
            includedTypes: [
                UITypes.Date,
                UITypes.DateTime,
                UITypes.LastModifiedTime,
                UITypes.CreatedTime,
            ],
        },
    ];
};
export const getPlaceholderNewRow = (filters, columns, option) => {
    var _a, _b, _c;
    if (filters.some((filter) => filter.logical_op === 'or')) {
        return {};
    }
    const placeholderNewRow = {};
    for (const eachFilter of filters) {
        if (['checked', 'notchecked', 'allof', 'eq'].includes(eachFilter.comparison_op)) {
            const column = columns.find((col) => col.id === eachFilter.fk_column_id);
            if (column) {
                if ([
                    UITypes.Number,
                    UITypes.Decimal,
                    UITypes.SingleLineText,
                    UITypes.LongText,
                    UITypes.SingleSelect,
                    UITypes.GeoData,
                    UITypes.Email,
                    UITypes.PhoneNumber,
                    UITypes.URL,
                    UITypes.Time,
                    UITypes.Year,
                    UITypes.Currency,
                    UITypes.Percent,
                    UITypes.Rating,
                    UITypes.Duration,
                    UITypes.JSON,
                    // User is using allOf and anyOf so we cannot include it here
                    // UITypes.User,
                ].includes(column.uidt) ||
                    ([UITypes.Date, UITypes.DateTime].includes(column.uidt) &&
                        eachFilter.comparison_sub_op === 'exactDate')) {
                    placeholderNewRow[column.title] = eachFilter.value;
                }
                else if ([UITypes.Checkbox].includes(column.uidt) &&
                    ['checked', 'notchecked'].includes(eachFilter.comparison_op)) {
                    placeholderNewRow[column.title] =
                        eachFilter.comparison_op === 'checked';
                }
                else if ([UITypes.MultiSelect].includes(column.uidt) &&
                    ['allof'].includes(eachFilter.comparison_op)) {
                    placeholderNewRow[column.title] = eachFilter.value;
                }
                else if ([UITypes.User].includes(column.uidt) &&
                    ['allof'].includes(eachFilter.comparison_op)) {
                    const isMulti = (_a = parseProp(column.meta)) === null || _a === void 0 ? void 0 : _a.is_multi;
                    if (isMulti || ((_c = (_b = eachFilter.value) === null || _b === void 0 ? void 0 : _b.indexOf) === null || _c === void 0 ? void 0 : _c.call(_b, ',')) < 0) {
                        const assignedValue = eachFilter.value
                            .split(',')
                            .map((k) => { var _a; return (k === '@me' ? (_a = option === null || option === void 0 ? void 0 : option.currentUser) === null || _a === void 0 ? void 0 : _a.id : k); })
                            .filter((k) => k)
                            .join(',');
                        placeholderNewRow[column.title] = assignedValue;
                    }
                }
            }
        }
    }
    return placeholderNewRow;
};
export const isComparisonOpAllowed = (filter, compOp, uidt, showNullAndEmptyInFilter) => {
    const isNullOrEmptyOp = ['empty', 'notempty', 'null', 'notnull'].includes(compOp.value);
    if (compOp.includedTypes) {
        // include allowed values only if selected column type matches
        if (filter.fk_column_id && compOp.includedTypes.includes(uidt)) {
            // for 'empty', 'notempty', 'null', 'notnull',
            // show them based on `showNullAndEmptyInFilter` in Base Settings
            return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
        }
        else {
            return false;
        }
    }
    else if (compOp.excludedTypes) {
        // include not allowed values only if selected column type not matches
        if (filter.fk_column_id && !compOp.excludedTypes.includes(uidt)) {
            // for 'empty', 'notempty', 'null', 'notnull',
            // show them based on `showNullAndEmptyInFilter` in Base Settings
            return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
        }
        else {
            return false;
        }
    }
    // explicitly include for non-null / non-empty ops
    return isNullOrEmptyOp ? showNullAndEmptyInFilter : true;
};
export const getFilterCount = (filters) => {
    var _a;
    let result = 0;
    for (const filter of filters) {
        if (filter.is_group) {
            result += getFilterCount((_a = filter.children) !== null && _a !== void 0 ? _a : []);
        }
        else {
            result += 1;
        }
    }
    return result;
};
export const deleteFilterWithSub = ($api, filter) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    let result = [];
    if (filter.is_group && ((_a = filter.children) === null || _a === void 0 ? void 0 : _a.length) > 0) {
        for (const child of filter.children) {
            result = [...result, ...(yield deleteFilterWithSub($api, child))];
        }
    }
    yield $api.dbTableFilter.delete(filter.id);
    result.push(filter.id);
    return result;
});
//# sourceMappingURL=data:application/json;base64,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