import { ColumnType, FilterType } from '../lib/Api';
import { FilterParseError } from './filterHelpers';
import { NcContext } from './ncTypes';
export { COMPARISON_OPS, COMPARISON_SUB_OPS, GROUPBY_COMPARISON_OPS, IS_WITHIN_COMPARISON_SUB_OPS, } from '../lib/parser/queryFilter/query-filter-lexer';
export interface FilterTypeWithMeta extends FilterType {
    meta?: {
        timezone?: string;
    };
}
export declare function extractFilterFromXwhere(context: Pick<NcContext, 'api_version'> & Pick<NcContext, 'timezone'>, { str, aliasColObjMap, throwErrorIfInvalid, errors, }: {
    str: string | string[];
    aliasColObjMap: {
        [columnAlias: string]: ColumnType;
    };
    throwErrorIfInvalid?: boolean;
    errors?: FilterParseError[];
}): {
    filters?: FilterType[];
    errors?: FilterParseError[];
};
