import { testExtractFilterFromXwhere } from './filterHelpers_old.spec';
import { extractFilterFromXwhere } from './filterHelpers_withparser';
import UITypes from './UITypes';
const context = { timezone: 'Asia/Calcutta' };
testExtractFilterFromXwhere('filterHelpers_withparser', (str, aliasColObjMap, throwErrorIfInvalid) => {
    return extractFilterFromXwhere(context, {
        str,
        aliasColObjMap,
        throwErrorIfInvalid,
    });
});
describe('filterHelpers_withparser_specific', () => {
    describe('extractFilterFromXwhere', () => {
        describe('logical', () => {
            it('will parse basic logical query', () => {
                var _a;
                // isWithin need to have specific suboperator :|
                const query = '(Date,isWithin,pastMonth)~and(Name,like,Hello)';
                const columnAlias = {
                    Date: {
                        id: 'field1',
                        column_name: 'col1',
                        title: 'Date',
                        uidt: UITypes.DateTime,
                    },
                    Name: {
                        id: 'field2',
                        column_name: 'col2',
                        title: 'Name',
                        uidt: UITypes.SingleLineText,
                    },
                };
                const result = extractFilterFromXwhere(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('and');
            });
            it('will parse nested logical query', () => {
                var _a;
                // isWithin need to have specific suboperator :|
                const query = '(Date,isWithin,pastMonth)~or((Name,like,Hello)~and(Name,like,World))';
                const columnAlias = {
                    Date: {
                        id: 'field1',
                        column_name: 'col1',
                        title: 'Date',
                        uidt: UITypes.DateTime,
                    },
                    Name: {
                        id: 'field2',
                        column_name: 'col2',
                        title: 'Name',
                        uidt: UITypes.SingleLineText,
                    },
                };
                const result = extractFilterFromXwhere(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('or');
            });
            it('will parse multiselect with ~or connection', () => {
                var _a;
                const query = '(fMultiSelect,allof,jun)~or(fMultiSelect,allof,may)';
                const columnAlias = {
                    fMultiSelect: {
                        id: 'field1',
                        column_name: 'fMultiSelect',
                        title: 'fMultiSelect',
                        uidt: UITypes.MultiSelect,
                    },
                };
                const result = extractFilterFromXwhere(context, {
                    str: query,
                    aliasColObjMap: columnAlias,
                });
                expect(result).toBeDefined();
                expect(result.filters).toBeDefined();
                expect(result.filters.length).toBe(1);
                expect((_a = result.filters[0].children) === null || _a === void 0 ? void 0 : _a[1].logical_op).toBe('or');
            });
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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