export interface Validation {
    type: GenericValidationType | StringValidationType | NumberValidationType | DateValidationType | TimeValidationType | YearValidationType | SelectValidationType | AttachmentValidationType | null;
    [key: string]: any;
}
export type ValidationType = Exclude<Validation['type'], null | GenericValidationType>;
export declare enum GenericValidationType {
    Required = "required"
}
export declare enum StringValidationType {
    MinLength = "minLength",
    MaxLength = "maxLength",
    StartsWith = "startsWith",
    EndsWith = "endsWith",
    Includes = "includes",
    NotIncludes = "notIncludes",
    Regex = "regex",
    Email = "email",
    BusinessEmail = "businessEmail",
    PhoneNumber = "phoneNumber",
    Url = "url"
}
export declare enum NumberValidationType {
    Min = "min",
    Max = "max"
}
export declare enum DateValidationType {
    MinDate = "minDate",
    MaxDate = "maxDate"
}
export declare enum TimeValidationType {
    MinTime = "minTime",
    MaxTime = "maxTime"
}
export declare enum YearValidationType {
    MinYear = "minYear",
    MaxYear = "maxYear"
}
export declare enum SelectValidationType {
    MinSelected = "minSelected",
    MaxSelected = "maxSelected",
    LimitOptions = "limitOptions"
}
export declare enum AttachmentValidationType {
    FileTypes = "fileTypes",
    FileSize = "fileSize",
    FileCount = "fileCount"
}
export interface RequiredValidation extends Validation {
    type: GenericValidationType.Required;
}
export declare const oppositeValidationTypeMap: {
    maxLength: StringValidationType;
    notIncludes: StringValidationType;
    max: NumberValidationType;
    maxYear: YearValidationType;
    maxDate: DateValidationType;
    maxTime: TimeValidationType;
    maxSelected: SelectValidationType;
};
export declare const hideExtraFieldsMetaKey = "hideExtraFields";
