export var GenericValidationType;
(function (GenericValidationType) {
    GenericValidationType["Required"] = "required";
})(GenericValidationType || (GenericValidationType = {}));
export var StringValidationType;
(function (StringValidationType) {
    StringValidationType["MinLength"] = "minLength";
    StringValidationType["MaxLength"] = "maxLength";
    StringValidationType["StartsWith"] = "startsWith";
    StringValidationType["EndsWith"] = "endsWith";
    StringValidationType["Includes"] = "includes";
    StringValidationType["NotIncludes"] = "notIncludes";
    StringValidationType["Regex"] = "regex";
    StringValidationType["Email"] = "email";
    StringValidationType["BusinessEmail"] = "businessEmail";
    StringValidationType["PhoneNumber"] = "phoneNumber";
    StringValidationType["Url"] = "url";
})(StringValidationType || (StringValidationType = {}));
export var NumberValidationType;
(function (NumberValidationType) {
    NumberValidationType["Min"] = "min";
    NumberValidationType["Max"] = "max";
})(NumberValidationType || (NumberValidationType = {}));
export var DateValidationType;
(function (DateValidationType) {
    DateValidationType["MinDate"] = "minDate";
    DateValidationType["MaxDate"] = "maxDate";
})(DateValidationType || (DateValidationType = {}));
export var TimeValidationType;
(function (TimeValidationType) {
    TimeValidationType["MinTime"] = "minTime";
    TimeValidationType["MaxTime"] = "maxTime";
})(TimeValidationType || (TimeValidationType = {}));
export var YearValidationType;
(function (YearValidationType) {
    YearValidationType["MinYear"] = "minYear";
    YearValidationType["MaxYear"] = "maxYear";
})(YearValidationType || (YearValidationType = {}));
export var SelectValidationType;
(function (SelectValidationType) {
    SelectValidationType["MinSelected"] = "minSelected";
    SelectValidationType["MaxSelected"] = "maxSelected";
    SelectValidationType["LimitOptions"] = "limitOptions";
})(SelectValidationType || (SelectValidationType = {}));
export var AttachmentValidationType;
(function (AttachmentValidationType) {
    AttachmentValidationType["FileTypes"] = "fileTypes";
    AttachmentValidationType["FileSize"] = "fileSize";
    AttachmentValidationType["FileCount"] = "fileCount";
})(AttachmentValidationType || (AttachmentValidationType = {}));
export const oppositeValidationTypeMap = {
    [StringValidationType.MaxLength]: StringValidationType.MinLength,
    [StringValidationType.NotIncludes]: StringValidationType.Includes,
    [NumberValidationType.Max]: NumberValidationType.Min,
    [YearValidationType.MaxYear]: YearValidationType.MinYear,
    [DateValidationType.MaxDate]: DateValidationType.MinDate,
    [TimeValidationType.MaxTime]: TimeValidationType.MinTime,
    [SelectValidationType.MaxSelected]: SelectValidationType.MinSelected,
};
export const hideExtraFieldsMetaKey = 'hideExtraFields';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9saWIvZm9ybS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFvQkEsTUFBTSxDQUFOLElBQVkscUJBRVg7QUFGRCxXQUFZLHFCQUFxQjtJQUMvQiw4Q0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBRlcscUJBQXFCLEtBQXJCLHFCQUFxQixRQUVoQztBQUVELE1BQU0sQ0FBTixJQUFZLG9CQVlYO0FBWkQsV0FBWSxvQkFBb0I7SUFDOUIsK0NBQXVCLENBQUE7SUFDdkIsK0NBQXVCLENBQUE7SUFDdkIsaURBQXlCLENBQUE7SUFDekIsNkNBQXFCLENBQUE7SUFDckIsNkNBQXFCLENBQUE7SUFDckIsbURBQTJCLENBQUE7SUFDM0IsdUNBQWUsQ0FBQTtJQUNmLHVDQUFlLENBQUE7SUFDZix1REFBK0IsQ0FBQTtJQUMvQixtREFBMkIsQ0FBQTtJQUMzQixtQ0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQVpXLG9CQUFvQixLQUFwQixvQkFBb0IsUUFZL0I7QUFFRCxNQUFNLENBQU4sSUFBWSxvQkFHWDtBQUhELFdBQVksb0JBQW9CO0lBQzlCLG1DQUFXLENBQUE7SUFDWCxtQ0FBVyxDQUFBO0FBQ2IsQ0FBQyxFQUhXLG9CQUFvQixLQUFwQixvQkFBb0IsUUFHL0I7QUFFRCxNQUFNLENBQU4sSUFBWSxrQkFHWDtBQUhELFdBQVksa0JBQWtCO0lBQzVCLHlDQUFtQixDQUFBO0lBQ25CLHlDQUFtQixDQUFBO0FBQ3JCLENBQUMsRUFIVyxrQkFBa0IsS0FBbEIsa0JBQWtCLFFBRzdCO0FBRUQsTUFBTSxDQUFOLElBQVksa0JBR1g7QUFIRCxXQUFZLGtCQUFrQjtJQUM1Qix5Q0FBbUIsQ0FBQTtJQUNuQix5Q0FBbUIsQ0FBQTtBQUNyQixDQUFDLEVBSFcsa0JBQWtCLEtBQWxCLGtCQUFrQixRQUc3QjtBQUVELE1BQU0sQ0FBTixJQUFZLGtCQUdYO0FBSEQsV0FBWSxrQkFBa0I7SUFDNUIseUNBQW1CLENBQUE7SUFDbkIseUNBQW1CLENBQUE7QUFDckIsQ0FBQyxFQUhXLGtCQUFrQixLQUFsQixrQkFBa0IsUUFHN0I7QUFFRCxNQUFNLENBQU4sSUFBWSxvQkFJWDtBQUpELFdBQVksb0JBQW9CO0lBQzlCLG1EQUEyQixDQUFBO0lBQzNCLG1EQUEyQixDQUFBO0lBQzNCLHFEQUE2QixDQUFBO0FBQy9CLENBQUMsRUFKVyxvQkFBb0IsS0FBcEIsb0JBQW9CLFFBSS9CO0FBRUQsTUFBTSxDQUFOLElBQVksd0JBSVg7QUFKRCxXQUFZLHdCQUF3QjtJQUNsQyxtREFBdUIsQ0FBQTtJQUN2QixpREFBcUIsQ0FBQTtJQUNyQixtREFBdUIsQ0FBQTtBQUN6QixDQUFDLEVBSlcsd0JBQXdCLEtBQXhCLHdCQUF3QixRQUluQztBQU1ELE1BQU0sQ0FBQyxNQUFNLHlCQUF5QixHQUFHO0lBQ3ZDLENBQUMsb0JBQW9CLENBQUMsU0FBUyxDQUFDLEVBQUUsb0JBQW9CLENBQUMsU0FBUztJQUNoRSxDQUFDLG9CQUFvQixDQUFDLFdBQVcsQ0FBQyxFQUFFLG9CQUFvQixDQUFDLFFBQVE7SUFDakUsQ0FBQyxvQkFBb0IsQ0FBQyxHQUFHLENBQUMsRUFBRSxvQkFBb0IsQ0FBQyxHQUFHO0lBQ3BELENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLEVBQUUsa0JBQWtCLENBQUMsT0FBTztJQUN4RCxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxFQUFFLGtCQUFrQixDQUFDLE9BQU87SUFDeEQsQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsRUFBRSxrQkFBa0IsQ0FBQyxPQUFPO0lBQ3hELENBQUMsb0JBQW9CLENBQUMsV0FBVyxDQUFDLEVBQUUsb0JBQW9CLENBQUMsV0FBVztDQUNyRSxDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sc0JBQXNCLEdBQUcsaUJBQWlCLENBQUMifQ==