import { escapeRegexString, getRowColPositionFromIndex, } from '../../lib/stringHelpers';
import { FormulaError } from './error';
import { FormulaErrorType } from './enums';
const REGEX_ERROR_AT_CHARACTER = /\sat character (\d+)/;
export function handleFormulaError({ formula, error, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    let position;
    let identifierLength;
    if ((_a = error.extra) === null || _a === void 0 ? void 0 : _a.position) {
        position = error.extra.position.index;
        identifierLength = error.extra.position.length;
    }
    else if ((_c = (_b = error.extra) === null || _b === void 0 ? void 0 : _b.columnName) !== null && _c !== void 0 ? _c : (_d = error.extra) === null || _d === void 0 ? void 0 : _d.calleeName) {
        const needle = (_f = (_e = error.extra) === null || _e === void 0 ? void 0 : _e.columnName) !== null && _f !== void 0 ? _f : (_g = error.extra) === null || _g === void 0 ? void 0 : _g.calleeName;
        const identifierMatch = formula.match(new RegExp(`\\b${escapeRegexString(needle)}\\b`));
        if (typeof (identifierMatch === null || identifierMatch === void 0 ? void 0 : identifierMatch.index) === 'number') {
            position = identifierMatch.index;
            identifierLength = needle.length;
        }
    }
    else {
        const message = error.message;
        // check for error character at
        const errorAtRegex = message.match(REGEX_ERROR_AT_CHARACTER);
        if (errorAtRegex === null || errorAtRegex === void 0 ? void 0 : errorAtRegex[0]) {
            position = Number(errorAtRegex[1]);
            identifierLength = 1;
        }
    }
    if (typeof position === 'number') {
        const colRowPosition = getRowColPositionFromIndex({
            stack: formula,
            position,
        });
        throw new FormulaError((_h = error.type) !== null && _h !== void 0 ? _h : FormulaErrorType.INVALID_SYNTAX, Object.assign(Object.assign({}, ((_j = error.extra) !== null && _j !== void 0 ? _j : {})), { position: Object.assign(Object.assign({}, colRowPosition), { length: identifierLength }) }), error.message);
    }
    else {
        throw error;
    }
}
//# sourceMappingURL=data:application/json;base64,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