var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { formulaJsep } from './formula/jsepInstances';
export * from './formula/enums';
export * from './formula/error';
export * from './formula/formulas';
export * from './formula/handle-formula-error';
export * from './formula/hooks';
export * from './formula/operators';
export * from './formula/types';
export * from './formula/validate-extract-tree';
export * from './formula/jsepInstances';
export function substituteColumnAliasWithIdInFormula(formula, columns) {
    return __awaiter(this, void 0, void 0, function* () {
        const substituteId = (pt) => __awaiter(this, void 0, void 0, function* () {
            if (pt.type === 'CallExpression') {
                for (const arg of pt.arguments || []) {
                    yield substituteId(arg);
                }
            }
            else if (pt.type === 'Literal') {
                return;
            }
            else if (pt.type === 'Identifier') {
                const colNameOrId = pt.name;
                const column = columns.find((c) => c.id === colNameOrId ||
                    c.column_name === colNameOrId ||
                    c.title === colNameOrId);
                pt.name = '{' + column.id + '}';
            }
            else if (pt.type === 'BinaryExpression') {
                yield substituteId(pt.left);
                yield substituteId(pt.right);
            }
        });
        const parsedFormula = formulaJsep(formula);
        yield substituteId(parsedFormula);
        return jsepTreeToFormula(parsedFormula);
    });
}
export function substituteColumnIdWithAliasInFormula(formula, columns, rawFormula) {
    const substituteId = (pt, ptRaw) => {
        var _a;
        if (pt.type === 'CallExpression') {
            let i = 0;
            for (const arg of pt.arguments || []) {
                substituteId(arg, (_a = ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.arguments) === null || _a === void 0 ? void 0 : _a[i++]);
            }
        }
        else if (pt.type === 'Literal') {
            return;
        }
        else if (pt.type === 'Identifier') {
            const colNameOrId = pt === null || pt === void 0 ? void 0 : pt.name;
            const column = columns.find((c) => c.id === colNameOrId ||
                c.column_name === colNameOrId ||
                c.title === colNameOrId);
            pt.name = (column === null || column === void 0 ? void 0 : column.title) || (ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.name) || (pt === null || pt === void 0 ? void 0 : pt.name);
        }
        else if (pt.type === 'BinaryExpression') {
            substituteId(pt.left, ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.left);
            substituteId(pt.right, ptRaw === null || ptRaw === void 0 ? void 0 : ptRaw.right);
        }
    };
    const parsedFormula = formulaJsep(formula);
    const parsedRawFormula = rawFormula && formulaJsep(rawFormula);
    substituteId(parsedFormula, parsedRawFormula);
    return jsepTreeToFormula(parsedFormula);
}
// isCallExpId - is the identifier part of a call expression
// in case of call expression, we don't want to wrap the identifier in curly brackets
export function jsepTreeToFormula(node, isCallExpId = false) {
    if (node.type === 'BinaryExpression' || node.type === 'LogicalExpression') {
        return ('(' +
            jsepTreeToFormula(node.left) +
            ' ' +
            node.operator +
            ' ' +
            jsepTreeToFormula(node.right) +
            ')');
    }
    if (node.type === 'UnaryExpression') {
        return node.operator + jsepTreeToFormula(node.argument);
    }
    if (node.type === 'MemberExpression') {
        return (jsepTreeToFormula(node.object) +
            '[' +
            jsepTreeToFormula(node.property) +
            ']');
    }
    if (node.type === 'Identifier') {
        if (!isCallExpId)
            return '{' + node.name + '}';
        return node.name;
    }
    if (node.type === 'Literal') {
        if (typeof node.value === 'string') {
            return String.raw `"${escapeLiteral(node.raw.slice(1, -1))}"`;
        }
        return '' + node.value;
    }
    if (node.type === 'CallExpression') {
        return (jsepTreeToFormula(node.callee, true) +
            '(' +
            node.arguments.map((argPt) => jsepTreeToFormula(argPt)).join(', ') +
            ')');
    }
    if (node.type === 'ArrayExpression') {
        return ('[' +
            node.elements.map((elePt) => jsepTreeToFormula(elePt)).join(', ') +
            ']');
    }
    if (node.type === 'Compound') {
        return node.body.map((e) => jsepTreeToFormula(e)).join(' ');
    }
    if (node.type === 'ConditionalExpression') {
        return (jsepTreeToFormula(node.test) +
            ' ? ' +
            jsepTreeToFormula(node.consequent) +
            ' : ' +
            jsepTreeToFormula(node.alternate));
    }
    return '';
}
function escapeLiteral(v) {
    return (v
        // 1️⃣ Temporarily protect real newline
        .replace(/\\n/g, '__NC_NEWLINE__')
        // 2️⃣ Escape unescaped backslashes (replace \ to \\, escape only unescaped \)
        .replace(/([^\\]|^)\\(?!\\)/g, `$1\\\\`)
        // 3️⃣ Escape quotes (replace " to \" and ' to \')
        .replace(/([^\\]|^)"/g, `$1\\"`)
        .replace(/([^\\]|^)'/g, `$1\\'`)
        // 4️⃣ Restore protected newline and tab
        .replace(/__NC_NEWLINE__/g, '\\n'));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybXVsYUhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL2Zvcm11bGFIZWxwZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUNBLE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSx5QkFBeUIsQ0FBQztBQUV0RCxjQUFjLGlCQUFpQixDQUFDO0FBQ2hDLGNBQWMsaUJBQWlCLENBQUM7QUFDaEMsY0FBYyxvQkFBb0IsQ0FBQztBQUNuQyxjQUFjLGdDQUFnQyxDQUFDO0FBQy9DLGNBQWMsaUJBQWlCLENBQUM7QUFDaEMsY0FBYyxxQkFBcUIsQ0FBQztBQUNwQyxjQUFjLGlCQUFpQixDQUFDO0FBQ2hDLGNBQWMsaUNBQWlDLENBQUM7QUFDaEQsY0FBYyx5QkFBeUIsQ0FBQztBQUV4QyxNQUFNLFVBQWdCLG9DQUFvQyxDQUN4RCxPQUFPLEVBQ1AsT0FBcUI7O1FBRXJCLE1BQU0sWUFBWSxHQUFHLENBQU8sRUFBTyxFQUFFLEVBQUU7WUFDckMsSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLGdCQUFnQixFQUFFLENBQUM7Z0JBQ2pDLEtBQUssTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLFNBQVMsSUFBSSxFQUFFLEVBQUUsQ0FBQztvQkFDckMsTUFBTSxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQzFCLENBQUM7WUFDSCxDQUFDO2lCQUFNLElBQUksRUFBRSxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUUsQ0FBQztnQkFDakMsT0FBTztZQUNULENBQUM7aUJBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLFlBQVksRUFBRSxDQUFDO2dCQUNwQyxNQUFNLFdBQVcsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDO2dCQUM1QixNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsSUFBSSxDQUN6QixDQUFDLENBQUMsRUFBRSxFQUFFLENBQ0osQ0FBQyxDQUFDLEVBQUUsS0FBSyxXQUFXO29CQUNwQixDQUFDLENBQUMsV0FBVyxLQUFLLFdBQVc7b0JBQzdCLENBQUMsQ0FBQyxLQUFLLEtBQUssV0FBVyxDQUMxQixDQUFDO2dCQUNGLEVBQUUsQ0FBQyxJQUFJLEdBQUcsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLEdBQUcsR0FBRyxDQUFDO1lBQ2xDLENBQUM7aUJBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLGtCQUFrQixFQUFFLENBQUM7Z0JBQzFDLE1BQU0sWUFBWSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDNUIsTUFBTSxZQUFZLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQy9CLENBQUM7UUFDSCxDQUFDLENBQUEsQ0FBQztRQUNGLE1BQU0sYUFBYSxHQUFHLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMzQyxNQUFNLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUNsQyxPQUFPLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQzFDLENBQUM7Q0FBQTtBQUVELE1BQU0sVUFBVSxvQ0FBb0MsQ0FDbEQsT0FBTyxFQUNQLE9BQXFCLEVBQ3JCLFVBQVc7SUFFWCxNQUFNLFlBQVksR0FBRyxDQUFDLEVBQU8sRUFBRSxLQUFXLEVBQUUsRUFBRTs7UUFDNUMsSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLGdCQUFnQixFQUFFLENBQUM7WUFDakMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ1YsS0FBSyxNQUFNLEdBQUcsSUFBSSxFQUFFLENBQUMsU0FBUyxJQUFJLEVBQUUsRUFBRSxDQUFDO2dCQUNyQyxZQUFZLENBQUMsR0FBRyxFQUFFLE1BQUEsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFNBQVMsMENBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1lBQzdDLENBQUM7UUFDSCxDQUFDO2FBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ2pDLE9BQU87UUFDVCxDQUFDO2FBQU0sSUFBSSxFQUFFLENBQUMsSUFBSSxLQUFLLFlBQVksRUFBRSxDQUFDO1lBQ3BDLE1BQU0sV0FBVyxHQUFHLEVBQUUsYUFBRixFQUFFLHVCQUFGLEVBQUUsQ0FBRSxJQUFJLENBQUM7WUFDN0IsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FDekIsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUNKLENBQUMsQ0FBQyxFQUFFLEtBQUssV0FBVztnQkFDcEIsQ0FBQyxDQUFDLFdBQVcsS0FBSyxXQUFXO2dCQUM3QixDQUFDLENBQUMsS0FBSyxLQUFLLFdBQVcsQ0FDMUIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQSxNQUFNLGFBQU4sTUFBTSx1QkFBTixNQUFNLENBQUUsS0FBSyxNQUFJLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxJQUFJLENBQUEsS0FBSSxFQUFFLGFBQUYsRUFBRSx1QkFBRixFQUFFLENBQUUsSUFBSSxDQUFBLENBQUM7UUFDckQsQ0FBQzthQUFNLElBQUksRUFBRSxDQUFDLElBQUksS0FBSyxrQkFBa0IsRUFBRSxDQUFDO1lBQzFDLFlBQVksQ0FBQyxFQUFFLENBQUMsSUFBSSxFQUFFLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxJQUFJLENBQUMsQ0FBQztZQUNuQyxZQUFZLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsS0FBSyxDQUFDLENBQUM7UUFDdkMsQ0FBQztJQUNILENBQUMsQ0FBQztJQUVGLE1BQU0sYUFBYSxHQUFHLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMzQyxNQUFNLGdCQUFnQixHQUFHLFVBQVUsSUFBSSxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDL0QsWUFBWSxDQUFDLGFBQWEsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO0lBQzlDLE9BQU8saUJBQWlCLENBQUMsYUFBYSxDQUFDLENBQUM7QUFDMUMsQ0FBQztBQUVELDREQUE0RDtBQUM1RCxxRkFBcUY7QUFDckYsTUFBTSxVQUFVLGlCQUFpQixDQUFDLElBQUksRUFBRSxXQUFXLEdBQUcsS0FBSztJQUN6RCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssa0JBQWtCLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxtQkFBbUIsRUFBRSxDQUFDO1FBQzFFLE9BQU8sQ0FDTCxHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztZQUM1QixHQUFHO1lBQ0gsSUFBSSxDQUFDLFFBQVE7WUFDYixHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUM3QixHQUFHLENBQ0osQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssaUJBQWlCLEVBQUUsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQyxRQUFRLEdBQUcsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssa0JBQWtCLEVBQUUsQ0FBQztRQUNyQyxPQUFPLENBQ0wsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUM5QixHQUFHO1lBQ0gsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoQyxHQUFHLENBQ0osQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssWUFBWSxFQUFFLENBQUM7UUFDL0IsSUFBSSxDQUFDLFdBQVc7WUFBRSxPQUFPLEdBQUcsR0FBRyxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQztRQUMvQyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUVELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxTQUFTLEVBQUUsQ0FBQztRQUM1QixJQUFJLE9BQU8sSUFBSSxDQUFDLEtBQUssS0FBSyxRQUFRLEVBQUUsQ0FBQztZQUNuQyxPQUFPLE1BQU0sQ0FBQyxHQUFHLENBQUEsSUFBSSxhQUFhLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDO1FBQy9ELENBQUM7UUFDRCxPQUFPLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssZ0JBQWdCLEVBQUUsQ0FBQztRQUNuQyxPQUFPLENBQ0wsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUM7WUFDcEMsR0FBRztZQUNILElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDbEUsR0FBRyxDQUNKLENBQUM7SUFDSixDQUFDO0lBRUQsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLGlCQUFpQixFQUFFLENBQUM7UUFDcEMsT0FBTyxDQUNMLEdBQUc7WUFDSCxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ2pFLEdBQUcsQ0FDSixDQUFDO0lBQ0osQ0FBQztJQUVELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxVQUFVLEVBQUUsQ0FBQztRQUM3QixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRUQsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLHVCQUF1QixFQUFFLENBQUM7UUFDMUMsT0FBTyxDQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDNUIsS0FBSztZQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDbEMsS0FBSztZQUNMLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FDbEMsQ0FBQztJQUNKLENBQUM7SUFFRCxPQUFPLEVBQUUsQ0FBQztBQUNaLENBQUM7QUFFRCxTQUFTLGFBQWEsQ0FBQyxDQUFTO0lBQzlCLE9BQU8sQ0FDTCxDQUFDO1FBQ0MsdUNBQXVDO1NBQ3RDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUM7UUFFbEMsOEVBQThFO1NBQzdFLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxRQUFRLENBQUM7UUFFeEMsa0RBQWtEO1NBQ2pELE9BQU8sQ0FBQyxhQUFhLEVBQUUsT0FBTyxDQUFDO1NBQy9CLE9BQU8sQ0FBQyxhQUFhLEVBQUUsT0FBTyxDQUFDO1FBRWhDLHdDQUF3QztTQUN2QyxPQUFPLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQ3JDLENBQUM7QUFDSixDQUFDIn0=