var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { FormulaDataTypes, validateFormulaAndExtractTreeWithType, } from './formulaHelpers';
import UITypes from './UITypes';
const base_id = 'pIJkwfxdDwd';
const getMeta = (_context, _param) => __awaiter(void 0, void 0, void 0, function* () {
    return ({
        base_id,
        columns: [],
        id: 'mWhcgaGWdKE',
        title: 'Table1',
    });
});
describe('Formula parsing and type validation', () => {
    it('Simple formula', () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield validateFormulaAndExtractTreeWithType({
            formula: '1 + 2',
            columns: [],
            clientOrSqlUi: 'mysql2',
            getMeta,
        });
        expect(result.dataType).toEqual(FormulaDataTypes.NUMERIC);
    }));
    it('Formula with IF condition', () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield validateFormulaAndExtractTreeWithType({
            formula: 'IF({column}, "Found", BLANK())',
            columns: [
                {
                    base_id,
                    id: 'cid',
                    title: 'column',
                    uidt: UITypes.Number,
                },
            ],
            clientOrSqlUi: 'mysql2',
            getMeta,
        });
        expect(result.dataType).toEqual(FormulaDataTypes.STRING);
    }));
    it('Complex formula', () => __awaiter(void 0, void 0, void 0, function* () {
        const result = yield validateFormulaAndExtractTreeWithType({
            formula: 'SWITCH({column2},"value1",IF({column1}, "Found", BLANK()),"value2", 2)',
            columns: [
                {
                    base_id,
                    id: 'id1',
                    title: 'column1',
                    uidt: UITypes.Number,
                },
                {
                    base_id,
                    id: 'id2',
                    title: 'column2',
                    uidt: UITypes.SingleLineText,
                },
            ],
            clientOrSqlUi: 'mysql2',
            getMeta,
        });
        expect(result.dataType).toEqual(FormulaDataTypes.STRING);
        const result1 = yield validateFormulaAndExtractTreeWithType({
            formula: 'SWITCH({column2},"value1",IF({column1}, 1, 2),"value2", 2)',
            columns: [
                {
                    base_id,
                    id: 'id1',
                    title: 'column1',
                    uidt: UITypes.Number,
                },
                {
                    base_id,
                    id: 'id2',
                    title: 'column2',
                    uidt: UITypes.SingleLineText,
                },
            ],
            clientOrSqlUi: 'mysql2',
            getMeta,
        });
        expect(result1.dataType).toEqual(FormulaDataTypes.NUMERIC);
    }));
    describe('Date and time interaction', () => {
        it('Time - time equals numeric', () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{Time1} - {Time2}',
                columns: [
                    {
                        base_id,
                        id: 'TUrXeTf4JUHdnRvn',
                        title: 'Time1',
                        uidt: UITypes.Time,
                    },
                    {
                        base_id,
                        id: 'J3aD/yLDT2GF6NEB',
                        title: 'Time2',
                        uidt: UITypes.Time,
                    },
                ],
                clientOrSqlUi: 'pg',
                getMeta,
            });
            expect(result.dataType).toEqual(FormulaDataTypes.NUMERIC);
        }));
        it('Time - time equals numeric', () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{Time1} - {Time2}',
                columns: [
                    {
                        base_id,
                        id: 'TUrXeTf4JUHdnRvn',
                        title: 'Time1',
                        uidt: UITypes.Time,
                    },
                    {
                        base_id,
                        id: 'J3aD/yLDT2GF6NEB',
                        title: 'Time2',
                        uidt: UITypes.Time,
                    },
                ],
                clientOrSqlUi: 'pg',
                getMeta,
            });
            expect(result.dataType).toEqual(FormulaDataTypes.NUMERIC);
        }));
        it('Date + time equals date', () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{Date1} + {Time2}',
                columns: [
                    {
                        base_id,
                        id: 'TUrXeTf4JUHdnRvn',
                        title: 'Date1',
                        uidt: UITypes.Date,
                    },
                    {
                        base_id,
                        id: 'J3aD/yLDT2GF6NEB',
                        title: 'Time2',
                        uidt: UITypes.Time,
                    },
                ],
                clientOrSqlUi: 'pg',
                getMeta,
            });
            expect(result.dataType).toEqual(FormulaDataTypes.DATE);
        }));
    });
    describe('binary expression', () => {
        it(`& operator will return string`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '"Hello" & "World"',
                columns: [],
                clientOrSqlUi: 'pg',
                getMeta,
            });
            expect(result.dataType).toBe(FormulaDataTypes.STRING);
        }));
    });
    describe('errors', () => {
        it(`will provide position for syntax error`, () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: '1 +',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 3,
                    row: 0,
                    length: 1,
                });
            }
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: '(1 + 1',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 6,
                    row: 0,
                    length: 1,
                });
            }
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: 'CONCAT)',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 6,
                    row: 0,
                    length: 1,
                });
            }
        }));
        it(`will provide position for column not found`, () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: '1 + __a_',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 4,
                    row: 0,
                    length: 4,
                });
            }
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: '__a_',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 0,
                    row: 0,
                    length: 4,
                });
            }
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: 'CONCAT(__a_  , "A")',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 7,
                    row: 0,
                    length: 6,
                });
            }
        }));
        it(`will handle formula missing parentheses`, () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: 'CONCAT',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.message).toContain('Missing parentheses after function name');
                expect(ex.extra.position).toEqual({
                    column: 6,
                    row: 0,
                    length: 1,
                });
            }
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: 'CONCAT(CONCAT)',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.message).toContain('Missing parentheses after function name');
                expect(ex.extra.position).toEqual({
                    column: 13,
                    row: 0,
                    length: 1,
                });
            }
        }));
        it(`will handle formula minimum argument`, () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                yield validateFormulaAndExtractTreeWithType({
                    formula: 'CONCAT(CONCAT())',
                    columns: [],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                    trackPosition: true,
                });
            }
            catch (ex) {
                expect(ex.extra.position).toEqual({
                    column: 7,
                    row: 0,
                    length: 8,
                });
            }
        }));
    });
    describe('referenced info', () => {
        it(`will return referenced column when directly referenced`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1}',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Number,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn.id).toEqual('id1');
            expect(result.referencedColumn.uidt).toEqual(UITypes.Number);
        }));
        it(`will return referenced column with binary operation`, () => __awaiter(void 0, void 0, void 0, function* () {
            const supportedTypes = [
                UITypes.Decimal,
                UITypes.Currency,
                UITypes.Percent,
                UITypes.SingleLineText,
                UITypes.LongText,
            ];
            for (const supportedType of supportedTypes) {
                const result = yield validateFormulaAndExtractTreeWithType({
                    formula: '{column1} + 3',
                    columns: [
                        {
                            base_id,
                            id: 'id1',
                            title: 'column1',
                            uidt: supportedType,
                        },
                    ],
                    clientOrSqlUi: 'mysql2',
                    getMeta,
                });
                expect(result.referencedColumn.id).toEqual('id1');
                expect(result.referencedColumn.uidt).toEqual(supportedType);
            }
        }));
        it(`will not return referenced column with impure binary operation`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1} + 3',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Number,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn).toBeUndefined();
            expect(result.uidtCandidates).toEqual([UITypes.Decimal]);
        }));
        it(`will not return referenced column when multiple columns is used`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1} + {column2}',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Decimal,
                    },
                    {
                        base_id,
                        id: 'id2',
                        title: 'column2',
                        uidt: UITypes.Decimal,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn).toBeUndefined();
            const result2 = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1} + ({column2} + {column3})',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Decimal,
                    },
                    {
                        base_id,
                        id: 'id2',
                        title: 'column2',
                        uidt: UITypes.Decimal,
                    },
                    {
                        base_id,
                        id: 'id3',
                        title: 'column3',
                        uidt: UITypes.Decimal,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result2.referencedColumn).toBeUndefined();
            const result3 = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1} + ({column2} + 1)',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Decimal,
                    },
                    {
                        base_id,
                        id: 'id2',
                        title: 'column2',
                        uidt: UITypes.Number,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result3.referencedColumn).toBeUndefined();
        }));
        it(`will return referenced column with pure call expression`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: 'MAX({column1}, 3)',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Number,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn.id).toEqual('id1');
            expect(result.referencedColumn.uidt).toEqual(UITypes.Number);
        }));
        it(`will return referenced column with pure call expression for arrays`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1}',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.LinkToAnotherRecord,
                        colOptions: {
                            fk_column_id: '',
                            id: '',
                            type: 'hm',
                            getRelatedTable: () => __awaiter(void 0, void 0, void 0, function* () {
                                return {
                                    base_id,
                                    columns: [
                                        {
                                            base_id,
                                            id: 'col_lok1',
                                            uidt: UITypes.SingleLineText,
                                            title: 'LOK1',
                                            pv: true,
                                        },
                                    ],
                                    id: 'tbl1',
                                    title: 'tbl1',
                                };
                            }),
                        },
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn.id).toEqual('col_lok1');
            expect(result.referencedColumn.uidt).toEqual(UITypes.SingleLineText);
            const result1 = yield validateFormulaAndExtractTreeWithType({
                formula: '{column1}',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Lookup,
                        colOptions: {
                            fk_column_id: '',
                            fk_relation_column_id: 'col_rel1',
                            fk_lookup_column_id: 'col_lok1',
                            getRelationColumn: () => __awaiter(void 0, void 0, void 0, function* () {
                                return {
                                    base_id,
                                    fk_model_id: 'tbl1',
                                    id: 'col_rel1',
                                    uidt: UITypes.SingleLineText,
                                    title: 'LOK1',
                                    colOptions: {
                                        fk_column_id: '',
                                        id: '',
                                        type: 'hm',
                                        getRelatedTable: () => __awaiter(void 0, void 0, void 0, function* () {
                                            return {
                                                base_id,
                                                columns: [
                                                    {
                                                        base_id,
                                                        id: 'col_lok1',
                                                        uidt: UITypes.SingleLineText,
                                                        title: 'LOK1',
                                                        pv: true,
                                                    },
                                                ],
                                                id: 'tbl1',
                                                title: 'tbl1',
                                            };
                                        }),
                                    },
                                };
                            }),
                            getLookupColumn: () => __awaiter(void 0, void 0, void 0, function* () {
                                return {
                                    base_id,
                                    id: 'col_lok1',
                                    uidt: UITypes.SingleLineText,
                                    title: 'LOK1',
                                };
                            }),
                        },
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result1.referencedColumn.id).toEqual('col_lok1');
            expect(result1.referencedColumn.uidt).toEqual(UITypes.SingleLineText);
        }));
        it(`will not return referenced column with impure call expression`, () => __awaiter(void 0, void 0, void 0, function* () {
            const result = yield validateFormulaAndExtractTreeWithType({
                formula: 'CEILING({column1})',
                columns: [
                    {
                        base_id,
                        id: 'id1',
                        title: 'column1',
                        uidt: UITypes.Number,
                    },
                ],
                clientOrSqlUi: 'mysql2',
                getMeta,
            });
            expect(result.referencedColumn).toBeUndefined();
            expect(result.uidtCandidates).toEqual([UITypes.Decimal]);
        }));
    });
});
//# sourceMappingURL=data:application/json;base64,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