import { ColumnType, FilterType } from './Api';
import { OrgUserRoles, ProjectRoles, WorkspaceUserRoles } from './enums';
import { OnPremPlanTitles, PlanTitles } from './payment';
export declare const enumColors: {
    light: string[];
    dark: string[];
    get: (theme: "light" | "dark", index: number) => string;
};
export declare enum ViewTypes {
    FORM = 1,
    GALLERY = 2,
    GRID = 3,
    KANBAN = 4,
    MAP = 5,
    CALENDAR = 6
}
export declare const viewTypeAlias: Record<ViewTypes, string>;
export declare const viewTypeToStringMap: Record<ViewTypes, string>;
export declare const stringToViewTypeMap: Record<string, ViewTypes>;
export declare const VIEW_GRID_DEFAULT_WIDTH = 200;
export declare enum ProjectTypes {
    DATABASE = "database",
    DOCUMENTATION = "documentation",
    COWRITER = "cowriter",
    DASHBOARD = "dashboard"
}
export declare enum RelationTypes {
    HAS_MANY = "hm",
    BELONGS_TO = "bt",
    MANY_TO_MANY = "mm",
    ONE_TO_ONE = "oo"
}
export declare const ExpandedFormMode: {
    readonly FIELD: "field";
    readonly ATTACHMENT: "attachment";
    readonly DISCUSSION: "discussion";
};
export type ExpandedFormModeType = (typeof ExpandedFormMode)[keyof typeof ExpandedFormMode];
export declare enum ExportTypes {
    EXCEL = "excel",
    CSV = "csv"
}
export declare enum PluginCategory {
    STORAGE = "Storage",
    EMAIL = "Email"
}
export declare enum ModelTypes {
    TABLE = "table",
    VIEW = "view",
    DASHBOARD = "dashboard"
}
export declare enum AutomationTypes {
    SCRIPT = "script",
    WORKFLOW = "workflow"
}
export declare enum ProjectStatus {
    JOB = "job"
}
export declare enum TiptapNodesTypes {
    doc = "doc",
    sec = "sec",
    paragraph = "paragraph",
    text = "text",
    heading = "heading",
    bullet = "bullet",
    ordered = "ordered",
    task = "task",
    quote = "quote",
    divider = "divider",
    codeBlock = "codeBlock",
    image = "image",
    callout = "callout",
    tipCallout = "tipCallout",
    table = "table",
    tableRow = "tableRow",
    tableCell = "tableCell",
    embed = "embed",
    collapsable = "collapsable",
    collapsableContent = "collapsable_content",
    collapsableHeader = "collapsable_header",
    column = "column",
    columnContent = "columnContent",
    linkToPage = "linkToPage",
    attachment = "attachment"
}
export declare enum TiptapMarksTypes {
    strike = "strike",
    bold = "bold",
    italic = "italic",
    link = "link",
    code = "code",
    underline = "underline"
}
export declare enum NcDataErrorCodes {
    NC_ERR_MM_MODEL_NOT_FOUND = "NC_ERR_MM_MODEL_NOT_FOUND"
}
export declare enum NcErrorType {
    ERR_AUTHENTICATION_REQUIRED = "ERR_AUTHENTICATION_REQUIRED",
    ERR_FORBIDDEN = "ERR_FORBIDDEN",
    ERR_API_TOKEN_NOT_ALLOWED = "ERR_API_TOKEN_NOT_ALLOWED",
    ERR_WORKSPACE_NOT_FOUND = "ERR_WORKSPACE_NOT_FOUND",
    ERR_BASE_NOT_FOUND = "ERR_BASE_NOT_FOUND",
    ERR_SOURCE_NOT_FOUND = "ERR_SOURCE_NOT_FOUND",
    ERR_TABLE_NOT_FOUND = "ERR_TABLE_NOT_FOUND",
    ERR_VIEW_NOT_FOUND = "ERR_VIEW_NOT_FOUND",
    ERR_FIELD_NOT_FOUND = "ERR_FIELD_NOT_FOUND",
    ERR_RECORD_NOT_FOUND = "ERR_RECORD_NOT_FOUND",
    ERR_GENERIC_NOT_FOUND = "ERR_GENERIC_NOT_FOUND",
    ERR_HOOK_NOT_FOUND = "ERR_HOOK_NOT_FOUND",
    ERR_REQUIRED_FIELD_MISSING = "ERR_REQUIRED_FIELD_MISSING",
    ERR_DUPLICATE_RECORD = "ERR_DUPLICATE_RECORD",
    ERR_USER_NOT_FOUND = "ERR_USER_NOT_FOUND",
    ERR_TEAM_NOT_FOUND = "ERR_TEAM_NOT_FOUND",
    ERR_INVALID_OFFSET_VALUE = "ERR_INVALID_OFFSET_VALUE",
    ERR_INVALID_PAGE_VALUE = "ERR_INVALID_PAGE_VALUE",
    ERR_INVALID_LIMIT_VALUE = "ERR_INVALID_LIMIT_VALUE",
    ERR_INVALID_FILTER = "ERR_INVALID_FILTER",
    ERR_INVALID_SHARED_VIEW_PASSWORD = "ERR_INVALID_SHARED_VIEW_PASSWORD",
    ERR_INVALID_ATTACHMENT_JSON = "ERR_INVALID_ATTACHMENT_JSON",
    ERR_NOT_IMPLEMENTED = "ERR_NOT_IMPLEMENTED",
    ERR_INTERNAL_SERVER = "ERR_INTERNAL_SERVER",
    ERR_DATABASE_OP_FAILED = "ERR_DATABASE_OP_FAILED",
    ERR_UNKNOWN = "ERR_UNKNOWN",
    ERR_INVALID_JSON = "ERR_INVALID_JSON",
    ERR_INVALID_PK_VALUE = "ERR_INVALID_PK_VALUE",
    ERR_COLUMN_ASSOCIATED_WITH_LINK = "ERR_COLUMN_ASSOCIATED_WITH_LINK",
    ERR_TABLE_ASSOCIATED_WITH_LINK = "ERR_TABLE_ASSOCIATED_WITH_LINK",
    ERR_INTEGRATION_NOT_FOUND = "ERR_INTEGRATION_NOT_FOUND",
    ERR_INTEGRATION_LINKED_WITH_BASES = "ERR_INTEGRATION_LINKED_WITH_BASES",
    ERR_FORMULA = "ERR_FORMULA",
    ERR_CIRCULAR_REF_IN_FORMULA = "ERR_CIRCULAR_REF_IN_FORMULA",
    ERR_PERMISSION_DENIED = "ERR_PERMISSION_DENIED",
    ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE = "ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE",
    ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER = "ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER",
    ERR_REORDER_FAILED = "ERR_REORDER_FAILED",
    ERR_PLAN_LIMIT_EXCEEDED = "ERR_PLAN_LIMIT_EXCEEDED",
    ERR_FEATURE_NOT_SUPPORTED = "ERR_FEATURE_NOT_SUPPORTED",
    ERR_SSO_LOGIN_REQUIRED = "ERR_SSO_LOGIN_REQUIRED",
    ERR_SSO_GENERATED_TOKEN_REQUIRED = "ERR_SSO_GENERATED_TOKEN_REQUIRED",
    ERR_MAX_PAYLOAD_LIMIT_EXCEEDED = "ERR_MAX_PAYLOAD_LIMIT_EXCEEDED",
    ERR_INVALID_VALUE_FOR_FIELD = "ERR_INVALID_VALUE_FOR_FIELD",
    ERR_MAX_WORKSPACE_LIMIT_REACHED = "ERR_MAX_WORKSPACE_LIMIT_REACHED",
    ERR_BASE_COLLABORATION = "ERR_BASE_COLLABORATION",
    ERR_ORG_USER = "ERR_ORG_USER",
    ERR_SYNC_TABLE_OPERATION_PROHIBITED = "ERR_SYNC_TABLE_OPERATION_PROHIBITED",
    ERR_INVALID_REQUEST_BODY = "ERR_INVALID_REQUEST_BODY",
    ERR_DASHBOARD_NOT_FOUND = "ERR_DASHBOARD_NOT_FOUND",
    ERR_WORKFLOW_NOT_FOUND = "ERR_WORKFLOW_NOT_FOUND",
    ERR_WIDGET_NOT_FOUND = "ERR_WIDGET_NOT_FOUND",
    ERR_SHARED_DASHBOARD_PASSWORD_INVALID = "ERR_SHARED_DASHBOARD_PASSWORD_INVALID",
    ERR_DUPLICATE_IN_ALIAS = "ERR_DUPLICATE_IN_ALIAS",
    ERR_OUT_OF_SYNC = "ERR_OUT_OF_SYNC",
    ERR_FILTER_VERIFICATION_FAILED = "ERR_FILTER_VERIFICATION_FAILED",
    ERR_VIEW_COLUMN_NOT_FOUND = "ERR_VIEW_COLUMN_NOT_FOUND",
    ERR_WEBHOOK_ERROR = "ERR_WEBHOOK_ERROR",
    ERR_WEBHOOK_URL_INVALID = "ERR_WEBHOOK_URL_INVALID",
    ERR_BASE_OP_FAILED = "ERR_BASE_OP_FAILED",
    ERR_TABLE_OP_FAILED = "ERR_TABLE_OP_FAILED",
    ERR_COLUMN_OP_FAILED = "ERR_COLUMN_OP_FAILED",
    ERR_DATA_SOURCES_NOT_FOUND = "ERR_DATA_SOURCES_NOT_FOUND",
    ERR_TEST_PLUGIN_FAILED = "ERR_TEST_PLUGIN_FAILED",
    ERR_UNSUPPORTED_RELATION = "ERR_UNSUPPORTED_RELATION",
    ERR_IN_EXTERNAL_DATA_SOURCE = "ERR_IN_EXTERNAL_DATA_SOURCE",
    ERR_EXTERNAL_DATA_SOURCE_TIMEOUT = "ERR_EXTERNAL_DATA_SOURCE_TIMEOUT",
    ERR_RELATION_FIELD_NOT_FOUND = "ERR_RELATION_FIELD_NOT_FOUND",
    ERR_UNSUPPORTED_FILTER_OPERATION = "ERR_UNSUPPORTED_FILTER_OPERATION",
    ERR_STORAGE_FILE_CREATE = "ERR_STORAGE_FILE_CREATE",
    ERR_STORAGE_FILE_READ = "ERR_STORAGE_FILE_READ",
    ERR_STORAGE_FILE_DELETE = "ERR_STORAGE_FILE_DELETE",
    ERR_STORAGE_FILE_STREAM = "ERR_STORAGE_FILE_STREAM",
    ERR_PLAN_ALREADY_EXISTS = "ERR_PLAN_ALREADY_EXISTS",
    ERR_SUBSCRIPTION_ALREADY_EXISTS = "ERR_SUBSCRIPTION_ALREADY_EXISTS",
    ERR_SUBSCRIPTION_NOT_FOUND = "ERR_SUBSCRIPTION_NOT_FOUND",
    ERR_PLAN_NOT_AVAILABLE = "ERR_PLAN_NOT_AVAILABLE",
    ERR_SEAT_COUNT_MISMATCH = "ERR_SEAT_COUNT_MISMATCH",
    ERR_INVALID_PAYMENT_PAYLOAD = "ERR_INVALID_PAYMENT_PAYLOAD",
    ERR_STRIPE_CUSTOMER_NOT_FOUND = "ERR_STRIPE_CUSTOMER_NOT_FOUND",
    ERR_STRIPE_SUBSCRIPTION_NOT_FOUND = "ERR_STRIPE_SUBSCRIPTION_NOT_FOUND",
    ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH = "ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH",
    ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED = "ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED",
    ERR_SUBSCRIPTION_CREATE_FAILED = "ERR_SUBSCRIPTION_CREATE_FAILED",
    ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED = "ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED",
    ERR_API_CLIENT_NOT_FOUND = "ERR_API_CLIENT_NOT_FOUND",
    ERR_EXTENSION_NOT_FOUND = "ERR_EXTENSION_NOT_FOUND",
    ERR_SCRIPT_NOT_FOUND = "ERR_SCRIPT_NOT_FOUND",
    FIELD_UNIQUE_CONSTRAINT_VIOLATION = "FIELD_UNIQUE_CONSTRAINT_VIOLATION",
    ERR_METHOD_NOT_ALLOWED = "ERR_METHOD_NOT_ALLOWED",
    ERR_WORKFLOW_EMPTY_NODE = "ERR_WORKFLOW_EMPTY_NODE",
    ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND = "ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND",
    ERR_WORKFLOW_NODE_EXECUTION_FAILED = "ERR_WORKFLOW_NODE_EXECUTION_FAILED",
    ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED = "ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED",
    ERR_WORKFLOW_NODE_NOT_FOUND = "ERR_WORKFLOW_NODE_NOT_FOUND",
    ERR_WORKFLOW_WAITING_EXECUTIONS = "ERR_WORKFLOW_WAITING_EXECUTIONS"
}
export declare enum ROW_COLORING_MODE {
    FILTER = "filter",
    SELECT = "select"
}
export declare const LongTextAiMetaProp = "ai";
export declare const NO_SCOPE = "nc";
export declare const NON_SEAT_ROLES: (WorkspaceUserRoles | ProjectRoles)[];
export declare const DURATION_TYPE_MAP: {
    0: string;
    1: string;
    2: string;
    3: string;
    4: string;
    'h:mm': number;
    'h:mm:ss': number;
    'h:mm:ss.s': number;
    'h:mm:ss.ss': number;
    'h:mm:ss.sss': number;
};
export declare const CURRENT_USER_TOKEN = "@me";
export type DeepPartial<T> = T extends object ? {
    [P in keyof T]?: DeepPartial<T[P]>;
} : T;
export type RowColoringInfoFilterRow = {
    id: string;
    is_set_as_background: boolean;
    nc_order: number;
    color: string;
    conditions: FilterType[];
    nestedConditions: FilterType[];
};
export type RowColoringInfoSelect = {
    mode: ROW_COLORING_MODE.SELECT;
    fk_column_id: string;
    options: {
        title: string;
        color: string;
    }[];
    selectColumn: ColumnType;
    is_set_as_background: boolean;
};
export type RowColoringInfoFilter = {
    mode: ROW_COLORING_MODE.FILTER;
    conditions: RowColoringInfoFilterRow[];
};
export type RowColoringInfo = {
    fk_model_id: string;
    fk_view_id: string;
} & (RowColoringInfoSelect | RowColoringInfoFilter);
type Roles = OrgUserRoles | ProjectRoles | WorkspaceUserRoles;
type RolesObj = Partial<Record<Roles, boolean>>;
type RolesType = RolesObj | string[] | string;
interface PlanLimitExceededDetailsType {
    plan?: PlanTitles | OnPremPlanTitles;
    limit?: number;
    current?: number;
    higherPlan?: PlanTitles | OnPremPlanTitles;
}
export { Roles, RolesObj, RolesType, PlanLimitExceededDetailsType };
export type RowColoringMode = null | 'SELECT' | 'FILTER';
export declare enum RowHeight {
    SHORT = 0,
    MEDIUM = 1,
    TALL = 2,
    EXTRA = 3
}
export declare const RowHeightMap: {
    short: RowHeight;
    medium: RowHeight;
    tall: RowHeight;
    extra: RowHeight;
    0: string;
    1: string;
    2: string;
    3: string;
};
export declare enum DependencyTableType {
    Column = "column",
    Model = "table",
    View = "view",
    Widget = "widget",
    Workflow = "workflow"
}
export declare enum BaseVersion {
    V2 = 2,
    V3 = 3
}
export declare enum SandboxVersionStatus {
    DRAFT = "draft",
    PUBLISHED = "published"
}
export declare enum SandboxVisibility {
    PUBLIC = "public",
    PRIVATE = "private",
    UNLISTED = "unlisted"
}
export declare enum DeploymentStatus {
    PENDING = "pending",
    IN_PROGRESS = "in_progress",
    SUCCESS = "success",
    FAILED = "failed"
}
export declare enum DeploymentType {
    INSTALL = "install",
    UPDATE = "update"
}
