import { ProjectRoles, WorkspaceUserRoles } from './enums';
export const enumColors = {
    light: [
        '#cfdffe',
        '#d0f1fd',
        '#c2f5e8',
        '#ffdaf6',
        '#ffdce5',
        '#fee2d5',
        '#ffeab6',
        '#d1f7c4',
        '#ede2fe',
        '#eeeeee',
    ],
    dark: [
        '#2d7ff999',
        '#18bfff99',
        '#20d9d299',
        '#ff08c299',
        '#f82b6099',
        '#ff6f2c99',
        '#fcb40099',
        '#20c93399',
        '#8b46ff99',
        '#666',
    ],
    get: (theme, index) => {
        index = Math.abs(index) % enumColors[theme].length;
        return enumColors[theme][index];
    },
};
export var ViewTypes;
(function (ViewTypes) {
    ViewTypes[ViewTypes["FORM"] = 1] = "FORM";
    ViewTypes[ViewTypes["GALLERY"] = 2] = "GALLERY";
    ViewTypes[ViewTypes["GRID"] = 3] = "GRID";
    ViewTypes[ViewTypes["KANBAN"] = 4] = "KANBAN";
    ViewTypes[ViewTypes["MAP"] = 5] = "MAP";
    ViewTypes[ViewTypes["CALENDAR"] = 6] = "CALENDAR";
})(ViewTypes || (ViewTypes = {}));
export const viewTypeAlias = {
    [ViewTypes.FORM]: 'form',
    [ViewTypes.GALLERY]: 'gallery',
    [ViewTypes.GRID]: 'grid',
    [ViewTypes.KANBAN]: 'kanban',
    [ViewTypes.MAP]: 'map',
    [ViewTypes.CALENDAR]: 'calendar',
};
export const viewTypeToStringMap = Object.assign({}, viewTypeAlias);
// Generate reverse mapping from the original viewTypeAlias
export const stringToViewTypeMap = Object.entries(viewTypeAlias).reduce((acc, [key, value]) => {
    acc[value] = Number(key);
    return acc;
}, {});
export const VIEW_GRID_DEFAULT_WIDTH = 200;
export var ProjectTypes;
(function (ProjectTypes) {
    ProjectTypes["DATABASE"] = "database";
    ProjectTypes["DOCUMENTATION"] = "documentation";
    ProjectTypes["COWRITER"] = "cowriter";
    ProjectTypes["DASHBOARD"] = "dashboard";
})(ProjectTypes || (ProjectTypes = {}));
export var RelationTypes;
(function (RelationTypes) {
    RelationTypes["HAS_MANY"] = "hm";
    RelationTypes["BELONGS_TO"] = "bt";
    RelationTypes["MANY_TO_MANY"] = "mm";
    RelationTypes["ONE_TO_ONE"] = "oo";
})(RelationTypes || (RelationTypes = {}));
export const ExpandedFormMode = {
    FIELD: 'field',
    ATTACHMENT: 'attachment',
    DISCUSSION: 'discussion',
};
export var ExportTypes;
(function (ExportTypes) {
    ExportTypes["EXCEL"] = "excel";
    ExportTypes["CSV"] = "csv";
})(ExportTypes || (ExportTypes = {}));
export var PluginCategory;
(function (PluginCategory) {
    PluginCategory["STORAGE"] = "Storage";
    PluginCategory["EMAIL"] = "Email";
})(PluginCategory || (PluginCategory = {}));
export var ModelTypes;
(function (ModelTypes) {
    ModelTypes["TABLE"] = "table";
    ModelTypes["VIEW"] = "view";
    ModelTypes["DASHBOARD"] = "dashboard";
})(ModelTypes || (ModelTypes = {}));
export var AutomationTypes;
(function (AutomationTypes) {
    AutomationTypes["SCRIPT"] = "script";
    AutomationTypes["WORKFLOW"] = "workflow";
})(AutomationTypes || (AutomationTypes = {}));
export var ProjectStatus;
(function (ProjectStatus) {
    ProjectStatus["JOB"] = "job";
})(ProjectStatus || (ProjectStatus = {}));
export var TiptapNodesTypes;
(function (TiptapNodesTypes) {
    TiptapNodesTypes["doc"] = "doc";
    TiptapNodesTypes["sec"] = "sec";
    TiptapNodesTypes["paragraph"] = "paragraph";
    TiptapNodesTypes["text"] = "text";
    TiptapNodesTypes["heading"] = "heading";
    TiptapNodesTypes["bullet"] = "bullet";
    TiptapNodesTypes["ordered"] = "ordered";
    TiptapNodesTypes["task"] = "task";
    TiptapNodesTypes["quote"] = "quote";
    TiptapNodesTypes["divider"] = "divider";
    TiptapNodesTypes["codeBlock"] = "codeBlock";
    TiptapNodesTypes["image"] = "image";
    TiptapNodesTypes["callout"] = "callout";
    TiptapNodesTypes["tipCallout"] = "tipCallout";
    TiptapNodesTypes["table"] = "table";
    TiptapNodesTypes["tableRow"] = "tableRow";
    TiptapNodesTypes["tableCell"] = "tableCell";
    TiptapNodesTypes["embed"] = "embed";
    TiptapNodesTypes["collapsable"] = "collapsable";
    TiptapNodesTypes["collapsableContent"] = "collapsable_content";
    TiptapNodesTypes["collapsableHeader"] = "collapsable_header";
    TiptapNodesTypes["column"] = "column";
    TiptapNodesTypes["columnContent"] = "columnContent";
    TiptapNodesTypes["linkToPage"] = "linkToPage";
    TiptapNodesTypes["attachment"] = "attachment";
})(TiptapNodesTypes || (TiptapNodesTypes = {}));
export var TiptapMarksTypes;
(function (TiptapMarksTypes) {
    TiptapMarksTypes["strike"] = "strike";
    TiptapMarksTypes["bold"] = "bold";
    TiptapMarksTypes["italic"] = "italic";
    TiptapMarksTypes["link"] = "link";
    TiptapMarksTypes["code"] = "code";
    TiptapMarksTypes["underline"] = "underline";
})(TiptapMarksTypes || (TiptapMarksTypes = {}));
export var NcDataErrorCodes;
(function (NcDataErrorCodes) {
    NcDataErrorCodes["NC_ERR_MM_MODEL_NOT_FOUND"] = "NC_ERR_MM_MODEL_NOT_FOUND";
})(NcDataErrorCodes || (NcDataErrorCodes = {}));
export var NcErrorType;
(function (NcErrorType) {
    NcErrorType["ERR_AUTHENTICATION_REQUIRED"] = "ERR_AUTHENTICATION_REQUIRED";
    NcErrorType["ERR_FORBIDDEN"] = "ERR_FORBIDDEN";
    NcErrorType["ERR_API_TOKEN_NOT_ALLOWED"] = "ERR_API_TOKEN_NOT_ALLOWED";
    NcErrorType["ERR_WORKSPACE_NOT_FOUND"] = "ERR_WORKSPACE_NOT_FOUND";
    NcErrorType["ERR_BASE_NOT_FOUND"] = "ERR_BASE_NOT_FOUND";
    NcErrorType["ERR_SOURCE_NOT_FOUND"] = "ERR_SOURCE_NOT_FOUND";
    NcErrorType["ERR_TABLE_NOT_FOUND"] = "ERR_TABLE_NOT_FOUND";
    NcErrorType["ERR_VIEW_NOT_FOUND"] = "ERR_VIEW_NOT_FOUND";
    NcErrorType["ERR_FIELD_NOT_FOUND"] = "ERR_FIELD_NOT_FOUND";
    NcErrorType["ERR_RECORD_NOT_FOUND"] = "ERR_RECORD_NOT_FOUND";
    NcErrorType["ERR_GENERIC_NOT_FOUND"] = "ERR_GENERIC_NOT_FOUND";
    NcErrorType["ERR_HOOK_NOT_FOUND"] = "ERR_HOOK_NOT_FOUND";
    NcErrorType["ERR_REQUIRED_FIELD_MISSING"] = "ERR_REQUIRED_FIELD_MISSING";
    NcErrorType["ERR_DUPLICATE_RECORD"] = "ERR_DUPLICATE_RECORD";
    NcErrorType["ERR_USER_NOT_FOUND"] = "ERR_USER_NOT_FOUND";
    NcErrorType["ERR_TEAM_NOT_FOUND"] = "ERR_TEAM_NOT_FOUND";
    NcErrorType["ERR_INVALID_OFFSET_VALUE"] = "ERR_INVALID_OFFSET_VALUE";
    NcErrorType["ERR_INVALID_PAGE_VALUE"] = "ERR_INVALID_PAGE_VALUE";
    NcErrorType["ERR_INVALID_LIMIT_VALUE"] = "ERR_INVALID_LIMIT_VALUE";
    NcErrorType["ERR_INVALID_FILTER"] = "ERR_INVALID_FILTER";
    NcErrorType["ERR_INVALID_SHARED_VIEW_PASSWORD"] = "ERR_INVALID_SHARED_VIEW_PASSWORD";
    NcErrorType["ERR_INVALID_ATTACHMENT_JSON"] = "ERR_INVALID_ATTACHMENT_JSON";
    NcErrorType["ERR_NOT_IMPLEMENTED"] = "ERR_NOT_IMPLEMENTED";
    NcErrorType["ERR_INTERNAL_SERVER"] = "ERR_INTERNAL_SERVER";
    NcErrorType["ERR_DATABASE_OP_FAILED"] = "ERR_DATABASE_OP_FAILED";
    NcErrorType["ERR_UNKNOWN"] = "ERR_UNKNOWN";
    NcErrorType["ERR_INVALID_JSON"] = "ERR_INVALID_JSON";
    NcErrorType["ERR_INVALID_PK_VALUE"] = "ERR_INVALID_PK_VALUE";
    NcErrorType["ERR_COLUMN_ASSOCIATED_WITH_LINK"] = "ERR_COLUMN_ASSOCIATED_WITH_LINK";
    NcErrorType["ERR_TABLE_ASSOCIATED_WITH_LINK"] = "ERR_TABLE_ASSOCIATED_WITH_LINK";
    NcErrorType["ERR_INTEGRATION_NOT_FOUND"] = "ERR_INTEGRATION_NOT_FOUND";
    NcErrorType["ERR_INTEGRATION_LINKED_WITH_BASES"] = "ERR_INTEGRATION_LINKED_WITH_BASES";
    NcErrorType["ERR_FORMULA"] = "ERR_FORMULA";
    NcErrorType["ERR_CIRCULAR_REF_IN_FORMULA"] = "ERR_CIRCULAR_REF_IN_FORMULA";
    NcErrorType["ERR_PERMISSION_DENIED"] = "ERR_PERMISSION_DENIED";
    NcErrorType["ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE"] = "ERR_INVALID_ATTACHMENT_UPLOAD_SCOPE";
    NcErrorType["ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER"] = "ERR_CANNOT_CALCULATE_INTERMEDIATE_ORDER";
    NcErrorType["ERR_REORDER_FAILED"] = "ERR_REORDER_FAILED";
    NcErrorType["ERR_PLAN_LIMIT_EXCEEDED"] = "ERR_PLAN_LIMIT_EXCEEDED";
    NcErrorType["ERR_FEATURE_NOT_SUPPORTED"] = "ERR_FEATURE_NOT_SUPPORTED";
    NcErrorType["ERR_SSO_LOGIN_REQUIRED"] = "ERR_SSO_LOGIN_REQUIRED";
    NcErrorType["ERR_SSO_GENERATED_TOKEN_REQUIRED"] = "ERR_SSO_GENERATED_TOKEN_REQUIRED";
    NcErrorType["ERR_MAX_PAYLOAD_LIMIT_EXCEEDED"] = "ERR_MAX_PAYLOAD_LIMIT_EXCEEDED";
    NcErrorType["ERR_INVALID_VALUE_FOR_FIELD"] = "ERR_INVALID_VALUE_FOR_FIELD";
    NcErrorType["ERR_MAX_WORKSPACE_LIMIT_REACHED"] = "ERR_MAX_WORKSPACE_LIMIT_REACHED";
    NcErrorType["ERR_BASE_COLLABORATION"] = "ERR_BASE_COLLABORATION";
    NcErrorType["ERR_ORG_USER"] = "ERR_ORG_USER";
    NcErrorType["ERR_SYNC_TABLE_OPERATION_PROHIBITED"] = "ERR_SYNC_TABLE_OPERATION_PROHIBITED";
    NcErrorType["ERR_INVALID_REQUEST_BODY"] = "ERR_INVALID_REQUEST_BODY";
    NcErrorType["ERR_DASHBOARD_NOT_FOUND"] = "ERR_DASHBOARD_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_NOT_FOUND"] = "ERR_WORKFLOW_NOT_FOUND";
    NcErrorType["ERR_WIDGET_NOT_FOUND"] = "ERR_WIDGET_NOT_FOUND";
    NcErrorType["ERR_SHARED_DASHBOARD_PASSWORD_INVALID"] = "ERR_SHARED_DASHBOARD_PASSWORD_INVALID";
    NcErrorType["ERR_DUPLICATE_IN_ALIAS"] = "ERR_DUPLICATE_IN_ALIAS";
    NcErrorType["ERR_OUT_OF_SYNC"] = "ERR_OUT_OF_SYNC";
    NcErrorType["ERR_FILTER_VERIFICATION_FAILED"] = "ERR_FILTER_VERIFICATION_FAILED";
    NcErrorType["ERR_VIEW_COLUMN_NOT_FOUND"] = "ERR_VIEW_COLUMN_NOT_FOUND";
    NcErrorType["ERR_WEBHOOK_ERROR"] = "ERR_WEBHOOK_ERROR";
    NcErrorType["ERR_WEBHOOK_URL_INVALID"] = "ERR_WEBHOOK_URL_INVALID";
    NcErrorType["ERR_BASE_OP_FAILED"] = "ERR_BASE_OP_FAILED";
    NcErrorType["ERR_TABLE_OP_FAILED"] = "ERR_TABLE_OP_FAILED";
    NcErrorType["ERR_COLUMN_OP_FAILED"] = "ERR_COLUMN_OP_FAILED";
    NcErrorType["ERR_DATA_SOURCES_NOT_FOUND"] = "ERR_DATA_SOURCES_NOT_FOUND";
    NcErrorType["ERR_TEST_PLUGIN_FAILED"] = "ERR_TEST_PLUGIN_FAILED";
    NcErrorType["ERR_UNSUPPORTED_RELATION"] = "ERR_UNSUPPORTED_RELATION";
    NcErrorType["ERR_IN_EXTERNAL_DATA_SOURCE"] = "ERR_IN_EXTERNAL_DATA_SOURCE";
    NcErrorType["ERR_EXTERNAL_DATA_SOURCE_TIMEOUT"] = "ERR_EXTERNAL_DATA_SOURCE_TIMEOUT";
    NcErrorType["ERR_RELATION_FIELD_NOT_FOUND"] = "ERR_RELATION_FIELD_NOT_FOUND";
    NcErrorType["ERR_UNSUPPORTED_FILTER_OPERATION"] = "ERR_UNSUPPORTED_FILTER_OPERATION";
    NcErrorType["ERR_STORAGE_FILE_CREATE"] = "ERR_STORAGE_FILE_CREATE";
    NcErrorType["ERR_STORAGE_FILE_READ"] = "ERR_STORAGE_FILE_READ";
    NcErrorType["ERR_STORAGE_FILE_DELETE"] = "ERR_STORAGE_FILE_DELETE";
    NcErrorType["ERR_STORAGE_FILE_STREAM"] = "ERR_STORAGE_FILE_STREAM";
    NcErrorType["ERR_PLAN_ALREADY_EXISTS"] = "ERR_PLAN_ALREADY_EXISTS";
    NcErrorType["ERR_SUBSCRIPTION_ALREADY_EXISTS"] = "ERR_SUBSCRIPTION_ALREADY_EXISTS";
    NcErrorType["ERR_SUBSCRIPTION_NOT_FOUND"] = "ERR_SUBSCRIPTION_NOT_FOUND";
    NcErrorType["ERR_PLAN_NOT_AVAILABLE"] = "ERR_PLAN_NOT_AVAILABLE";
    NcErrorType["ERR_SEAT_COUNT_MISMATCH"] = "ERR_SEAT_COUNT_MISMATCH";
    NcErrorType["ERR_INVALID_PAYMENT_PAYLOAD"] = "ERR_INVALID_PAYMENT_PAYLOAD";
    NcErrorType["ERR_STRIPE_CUSTOMER_NOT_FOUND"] = "ERR_STRIPE_CUSTOMER_NOT_FOUND";
    NcErrorType["ERR_STRIPE_SUBSCRIPTION_NOT_FOUND"] = "ERR_STRIPE_SUBSCRIPTION_NOT_FOUND";
    NcErrorType["ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH"] = "ERR_SUBSCRIPTION_OWNERSHIP_MISMATCH";
    NcErrorType["ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED"] = "ERR_INTERNAL_CUSTOMER_NOT_SUPPORTED";
    NcErrorType["ERR_SUBSCRIPTION_CREATE_FAILED"] = "ERR_SUBSCRIPTION_CREATE_FAILED";
    NcErrorType["ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED"] = "ERR_STRIPE_WEBHOOK_VERIFICATION_FAILED";
    NcErrorType["ERR_API_CLIENT_NOT_FOUND"] = "ERR_API_CLIENT_NOT_FOUND";
    NcErrorType["ERR_EXTENSION_NOT_FOUND"] = "ERR_EXTENSION_NOT_FOUND";
    NcErrorType["ERR_SCRIPT_NOT_FOUND"] = "ERR_SCRIPT_NOT_FOUND";
    NcErrorType["FIELD_UNIQUE_CONSTRAINT_VIOLATION"] = "FIELD_UNIQUE_CONSTRAINT_VIOLATION";
    NcErrorType["ERR_METHOD_NOT_ALLOWED"] = "ERR_METHOD_NOT_ALLOWED";
    // Workflow Errors
    NcErrorType["ERR_WORKFLOW_EMPTY_NODE"] = "ERR_WORKFLOW_EMPTY_NODE";
    NcErrorType["ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND"] = "ERR_WORKFLOW_TRIGGER_NODE_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_NODE_EXECUTION_FAILED"] = "ERR_WORKFLOW_NODE_EXECUTION_FAILED";
    NcErrorType["ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED"] = "ERR_WORKFLOW_MAX_ITERATIONS_EXCEEDED";
    NcErrorType["ERR_WORKFLOW_NODE_NOT_FOUND"] = "ERR_WORKFLOW_NODE_NOT_FOUND";
    NcErrorType["ERR_WORKFLOW_WAITING_EXECUTIONS"] = "ERR_WORKFLOW_WAITING_EXECUTIONS";
})(NcErrorType || (NcErrorType = {}));
export var ROW_COLORING_MODE;
(function (ROW_COLORING_MODE) {
    ROW_COLORING_MODE["FILTER"] = "filter";
    ROW_COLORING_MODE["SELECT"] = "select";
})(ROW_COLORING_MODE || (ROW_COLORING_MODE = {}));
export const LongTextAiMetaProp = 'ai';
export const NO_SCOPE = 'nc';
export const NON_SEAT_ROLES = [
    WorkspaceUserRoles.NO_ACCESS,
    WorkspaceUserRoles.VIEWER,
    WorkspaceUserRoles.INHERIT,
    WorkspaceUserRoles.COMMENTER,
    ProjectRoles.NO_ACCESS,
    ProjectRoles.VIEWER,
    ProjectRoles.INHERIT,
    ProjectRoles.COMMENTER,
];
export const DURATION_TYPE_MAP = {
    0: 'h:mm',
    1: 'h:mm:ss',
    2: 'h:mm:ss.s',
    3: 'h:mm:ss.ss',
    4: 'h:mm:ss.sss',
    'h:mm': 0,
    'h:mm:ss': 1,
    'h:mm:ss.s': 2,
    'h:mm:ss.ss': 3,
    'h:mm:ss.sss': 4,
};
export const CURRENT_USER_TOKEN = '@me';
export var RowHeight;
(function (RowHeight) {
    RowHeight[RowHeight["SHORT"] = 0] = "SHORT";
    RowHeight[RowHeight["MEDIUM"] = 1] = "MEDIUM";
    RowHeight[RowHeight["TALL"] = 2] = "TALL";
    RowHeight[RowHeight["EXTRA"] = 3] = "EXTRA";
})(RowHeight || (RowHeight = {}));
export const RowHeightMap = {
    short: RowHeight.SHORT,
    medium: RowHeight.MEDIUM,
    tall: RowHeight.TALL,
    extra: RowHeight.EXTRA,
    [RowHeight.SHORT]: 'short',
    [RowHeight.MEDIUM]: 'medium',
    [RowHeight.TALL]: 'tall',
    [RowHeight.EXTRA]: 'extra',
};
export var DependencyTableType;
(function (DependencyTableType) {
    DependencyTableType["Column"] = "column";
    DependencyTableType["Model"] = "table";
    DependencyTableType["View"] = "view";
    DependencyTableType["Widget"] = "widget";
    DependencyTableType["Workflow"] = "workflow";
})(DependencyTableType || (DependencyTableType = {}));
export var BaseVersion;
(function (BaseVersion) {
    BaseVersion[BaseVersion["V2"] = 2] = "V2";
    BaseVersion[BaseVersion["V3"] = 3] = "V3";
})(BaseVersion || (BaseVersion = {}));
export var SandboxVersionStatus;
(function (SandboxVersionStatus) {
    SandboxVersionStatus["DRAFT"] = "draft";
    SandboxVersionStatus["PUBLISHED"] = "published";
})(SandboxVersionStatus || (SandboxVersionStatus = {}));
export var SandboxVisibility;
(function (SandboxVisibility) {
    SandboxVisibility["PUBLIC"] = "public";
    SandboxVisibility["PRIVATE"] = "private";
    SandboxVisibility["UNLISTED"] = "unlisted";
})(SandboxVisibility || (SandboxVisibility = {}));
export var DeploymentStatus;
(function (DeploymentStatus) {
    DeploymentStatus["PENDING"] = "pending";
    DeploymentStatus["IN_PROGRESS"] = "in_progress";
    DeploymentStatus["SUCCESS"] = "success";
    DeploymentStatus["FAILED"] = "failed";
})(DeploymentStatus || (DeploymentStatus = {}));
export var DeploymentType;
(function (DeploymentType) {
    DeploymentType["INSTALL"] = "install";
    DeploymentType["UPDATE"] = "update";
})(DeploymentType || (DeploymentType = {}));
//# sourceMappingURL=data:application/json;base64,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