/**
 * Helper to get table metadata using composite key pattern (baseId:tableId)
 * Falls back to tableId-only lookup for backward compatibility
 *
 * @param metas - Record of table metadata keyed by composite key or tableId
 * @param baseId - Base ID for composite key lookup
 * @param tableId - Table ID to look up
 * @returns Table metadata or undefined
 */
export function getMetaWithCompositeKey(metas, baseId, tableId) {
    if (baseId) {
        return metas[`${baseId}:${tableId}`] || metas[tableId];
    }
    return metas[tableId];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0YUhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2hlbHBlcnMvbWV0YUhlbHBlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUE7Ozs7Ozs7O0dBUUc7QUFDSCxNQUFNLFVBQVUsdUJBQXVCLENBQ3JDLEtBQWdDLEVBQ2hDLE1BQTBCLEVBQzFCLE9BQWU7SUFFZixJQUFJLE1BQU0sRUFBRSxDQUFDO1FBQ1gsT0FBTyxLQUFLLENBQUMsR0FBRyxNQUFNLElBQUksT0FBTyxFQUFFLENBQUMsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELE9BQU8sS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ3hCLENBQUMifQ==