import { parseProp, roundUpToPrecision } from '../lib/helperFunctions';
export const numberize = (value) => {
    if (value === undefined || value === null) {
        return value;
    }
    if (typeof value === 'number') {
        return value;
    }
    else {
        const result = parseInt(value);
        if (isNaN(result)) {
            return undefined;
        }
        return result;
    }
};
export const roundTo = (num, precision = 1) => {
    if (!num || Number.isNaN(num))
        return num;
    const factor = Math.pow(10, precision);
    return Math.round(+num * factor) / factor;
};
export const getCurrencyValue = (modelValue, col) => {
    var _a, _b, _c;
    const currencyMeta = Object.assign({ currency_locale: 'en-US', currency_code: 'USD', precision: 2 }, parseProp(col.meta));
    try {
        if (modelValue === null ||
            modelValue === undefined ||
            Number.isNaN(modelValue)) {
            return modelValue === null || modelValue === undefined
                ? ''
                : modelValue;
        }
        const roundedValue = roundUpToPrecision(Number(modelValue), (_a = currencyMeta.precision) !== null && _a !== void 0 ? _a : 2);
        return new Intl.NumberFormat(currencyMeta.currency_locale || 'en-US', {
            style: 'currency',
            currency: currencyMeta.currency_code || 'USD',
            minimumFractionDigits: (_b = currencyMeta.precision) !== null && _b !== void 0 ? _b : 2,
            maximumFractionDigits: (_c = currencyMeta.precision) !== null && _c !== void 0 ? _c : 2,
        }).format(+roundedValue);
    }
    catch (e) {
        return modelValue;
    }
};
//# sourceMappingURL=data:application/json;base64,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