export var OAuthScopes;
(function (OAuthScopes) {
    OAuthScopes["DATA_RECORDS_READ"] = "data.records:read";
    OAuthScopes["DATA_RECORDS_WRITE"] = "data.records:write";
    OAuthScopes["DATA_RECORD_COMMENT_READ"] = "data.records.comment:read";
    OAuthScopes["DATA_RECORD_COMMENT_WRITE"] = "data.records.comment:write";
    OAuthScopes["SCHEMA_BASE_READ"] = "schema.base:read";
    OAuthScopes["SCHEMA_BASE_WRITE"] = "schema.base:write";
    OAuthScopes["SCHEMA_WORKSPACES_READ"] = "schema.workspaces:read";
    OAuthScopes["SCHEMA_WORKSPACES_WRITE"] = "schema.workspaces:write";
    OAuthScopes["WEBHOOK_MANAGE"] = "webhook:manage";
    OAuthScopes["INTEGRATION_MANAGE"] = "integration:manage";
    OAuthScopes["USER_PROFILE_READ"] = "user.profile:read";
    OAuthScopes["AI_ACCESS"] = "ai:access";
})(OAuthScopes || (OAuthScopes = {}));
export const scopeHierarchy = {
    // Data write includes read
    [OAuthScopes.DATA_RECORDS_WRITE]: [OAuthScopes.DATA_RECORDS_READ],
    [OAuthScopes.DATA_RECORD_COMMENT_WRITE]: [
        OAuthScopes.DATA_RECORD_COMMENT_READ,
    ],
    // Schema write includes read
    [OAuthScopes.SCHEMA_BASE_WRITE]: [OAuthScopes.SCHEMA_BASE_READ],
    [OAuthScopes.SCHEMA_WORKSPACES_WRITE]: [OAuthScopes.SCHEMA_WORKSPACES_READ],
};
export const scopeDescriptions = {
    [OAuthScopes.DATA_RECORDS_READ]: {
        name: 'Read Records',
        description: 'View data records and their content',
    },
    [OAuthScopes.DATA_RECORDS_WRITE]: {
        name: 'Write Records',
        description: 'Create, update, and delete data records (includes read access)',
    },
    [OAuthScopes.DATA_RECORD_COMMENT_READ]: {
        name: 'Read Comments',
        description: 'View comments on data records',
    },
    [OAuthScopes.DATA_RECORD_COMMENT_WRITE]: {
        name: 'Write Comments',
        description: 'Add, edit, and delete comments on records (includes read access)',
    },
    [OAuthScopes.SCHEMA_BASE_READ]: {
        name: 'Read Base Schema',
        description: 'View base structure and base configuration',
    },
    [OAuthScopes.SCHEMA_BASE_WRITE]: {
        name: 'Write Base Schema',
        description: 'Modify base structure and configuration (includes read access)',
    },
    [OAuthScopes.SCHEMA_WORKSPACES_READ]: {
        name: 'Read Workspace Schema',
        description: 'View workspace structure and organization',
    },
    [OAuthScopes.SCHEMA_WORKSPACES_WRITE]: {
        name: 'Write Workspace Schema',
        description: 'Modify workspace structure and organization (includes read access)',
    },
    [OAuthScopes.WEBHOOK_MANAGE]: {
        name: 'Manage Webhooks',
        description: 'Create, update, and delete webhook configurations',
    },
    [OAuthScopes.INTEGRATION_MANAGE]: {
        name: 'Manage Integrations',
        description: 'Configure and manage third-party integrations',
    },
    [OAuthScopes.USER_PROFILE_READ]: {
        name: 'Read User Profile',
        description: 'Access user profile information and preferences',
    },
    [OAuthScopes.AI_ACCESS]: {
        name: 'AI Access',
        description: 'Use AI-powered features and functionality',
    },
};
//# sourceMappingURL=data:application/json;base64,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