import { objRemoveEmptyStringProps } from './objectHelpers';
describe('objectHelpers', () => {
    describe('objRemoveEmptyStringProps', () => {
        it('will remove empty string property', () => {
            const a = {
                foo: 'bar',
                boo: '',
                baz: {
                    foo: 'bar',
                    boo: '',
                    baz: [{ foo: 'bar', boo: '' }],
                },
            };
            const expected = {
                foo: 'bar',
                baz: {
                    foo: 'bar',
                    baz: [{ foo: 'bar' }],
                },
            };
            expect(objRemoveEmptyStringProps(a)).toEqual(expected);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2JqZWN0SGVscGVycy5zcGVjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9vYmplY3RIZWxwZXJzLnNwZWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFFNUQsUUFBUSxDQUFDLGVBQWUsRUFBRSxHQUFHLEVBQUU7SUFDN0IsUUFBUSxDQUFDLDJCQUEyQixFQUFFLEdBQUcsRUFBRTtRQUN6QyxFQUFFLENBQUMsbUNBQW1DLEVBQUUsR0FBRyxFQUFFO1lBQzNDLE1BQU0sQ0FBQyxHQUFHO2dCQUNSLEdBQUcsRUFBRSxLQUFLO2dCQUNWLEdBQUcsRUFBRSxFQUFFO2dCQUNQLEdBQUcsRUFBRTtvQkFDSCxHQUFHLEVBQUUsS0FBSztvQkFDVixHQUFHLEVBQUUsRUFBRTtvQkFDUCxHQUFHLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDO2lCQUMvQjthQUNGLENBQUM7WUFDRixNQUFNLFFBQVEsR0FBRztnQkFDZixHQUFHLEVBQUUsS0FBSztnQkFDVixHQUFHLEVBQUU7b0JBQ0gsR0FBRyxFQUFFLEtBQUs7b0JBQ1YsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLENBQUM7aUJBQ3RCO2FBQ0YsQ0FBQztZQUNGLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUN6RCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMifQ==