import { createToken, Lexer } from 'chevrotain';
const IDENTIFIER = createToken({
    name: 'IDENTIFIER',
    pattern: /[^()'",]+/,
});
const COMMA_SUPPORTED_IDENTIFIER = createToken({
    name: 'COMMA_SUPPORTED_IDENTIFIER',
    pattern: /[^()'"]+/,
});
export const COMMON_TOKEN = {
    PAREN_START: createToken({ name: 'PAREN_START', pattern: /\(/ }),
    PAREN_END: createToken({ name: 'PAREN_END', pattern: /\)/ }),
    SQ_BRACKET_START: createToken({ name: 'SQ_BRACKET_START', pattern: /\[/ }),
    SQ_BRACKET_END: createToken({ name: 'SQ_BRACKET_END', pattern: /\]/ }),
    CURLY_START: createToken({ name: 'CURLY_START', pattern: /\{/ }),
    CURLY_END: createToken({ name: 'CURLY_END', pattern: /\}/ }),
    NUMBER_LITERAL: createToken({ name: 'NUMBER_LITERAL', pattern: /[1-9]\d*/ }),
    ALPHABET_LITERAL: createToken({
        name: 'ALPHABET_LITERAL',
        pattern: /[a-zA-Z]\d*/,
    }),
    COMMA: createToken({ name: 'COMMA', pattern: /,/ }),
    WHITESPACE: createToken({
        name: 'WHITESPACE',
        // do not delete the space inside aregex
        pattern: /[ \t\n\r]+/,
    }),
    WHITESPACE_SKIP: createToken({
        name: 'WHITESPACE',
        // do not delete the space inside aregex
        pattern: /[ \t\n\r]+/,
        group: Lexer.SKIPPED,
    }),
    PLUS: createToken({ name: 'PLUS', pattern: /\+/ }),
    MINUS: createToken({ name: 'MINUS', pattern: /-/ }),
    MULTI: createToken({ name: 'MULTI', pattern: /\*/ }),
    DIVIDE: createToken({ name: 'DIVIDE', pattern: /\// }),
    COLON: createToken({ name: 'COLON', pattern: /:/ }),
    SEMICOLON: createToken({ name: 'SEMICOLON', pattern: /;/ }),
    PIPE: createToken({ name: 'PIPE', pattern: /|/ }),
    SLASH: createToken({ name: 'SLASH', pattern: /\// }),
    BACKSLASH: createToken({ name: 'BACKSLASH', pattern: /\\/ }),
    DBL_QUOTE: createToken({ name: 'DBL_QUOTE', pattern: /"/ }),
    SGL_QUOTE: createToken({ name: 'SGL_QUOTE', pattern: /'/ }),
    IDENTIFIER: IDENTIFIER,
    COMMA_SUPPORTED_IDENTIFIER: COMMA_SUPPORTED_IDENTIFIER,
    EMPTY_QUOTED_IDENTIFIER: createToken({
        name: 'EMPTY_QUOTED_IDENTIFIER',
        pattern: /''|""|``/,
        longer_alt: IDENTIFIER,
    }),
    SUP_SGL_QUOTE_IDENTIFIER: createToken({
        name: 'SUP_SGL_QUOTE_IDENTIFIER',
        pattern: /'((?:\\'|[^'])+)'/,
        longer_alt: IDENTIFIER,
    }),
    SUP_DBL_QUOTE_IDENTIFIER: createToken({
        name: 'SUP_DBL_QUOTE_IDENTIFIER',
        pattern: /"((?:\\"|[^"])+)"/,
        longer_alt: IDENTIFIER,
    }),
    SUP_BACK_QUOTE_IDENTIFIER: createToken({
        name: 'SUP_BACK_QUOTE_IDENTIFIER',
        pattern: /`((?:\\`|[^`])+)`/,
        longer_alt: IDENTIFIER,
    }),
};
//# sourceMappingURL=data:application/json;base64,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