export const parseLexingError = (e) => {
    return `Lexing error: ${e.message}, please contact support`;
};
export const parseParsingError = (e) => {
    var _a, _b;
    try {
        if (e.message.toLowerCase().startsWith('expecting token of type --> ')) {
            const operatorRegex = /^Expecting token of type --> (\S+) <-- but found --> '?([^\s']*)'? <--.?/i;
            const tokens = e.message.match(operatorRegex);
            const [expectation, found] = tokens.slice(1, 3);
            switch (expectation) {
                case 'OPERATOR': {
                    return `Invalid filter expression: '${found}' is not a recognized operator. Please use a valid comparison or logical operator`;
                }
                case 'PAREN_END': {
                    return `Invalid filter syntax: expected a closing parentheses ')', but found '${found}'`;
                }
                default: {
                    return `Invalid filter expression: '${found}' is not a valid token`;
                }
            }
        }
        else if (e.message
            .toLowerCase()
            .startsWith('expecting: one of these possible token sequences:')) {
            const optionRegex = /^\s*\d+\.\s*\[(.+)\]/im;
            const foundRegex = /but found: '?([^\s']+)'?/im;
            const messageParts = e.message.split('\n');
            const options = messageParts
                .slice(1, messageParts.length - 1)
                .map((t) => t.match(optionRegex)[1]);
            const found = messageParts
                .slice(messageParts.length - 1)[0]
                .match(foundRegex)[1];
            if (((_b = (_a = e.token) === null || _a === void 0 ? void 0 : _a.tokenType) === null || _b === void 0 ? void 0 : _b.name) === 'IDENTIFIER' &&
                options.some((k) => k === 'IDENTIFIER, COMMA')) {
                return `Invalid filter syntax: expected comma ',' followed with operator (and value) after field`;
            }
            if (options.some((k) => k === 'NOT_OPERATOR' || k === 'PAREN_START')) {
                return `Invalid filter syntax: expected a logical operator like '~not' or opening parenthesis, but found '${found}'`;
            }
        }
    }
    catch (_c) {
        // silent catch
    }
    return e.message;
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3ItbWVzc2FnZS1wYXJzZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL3BhcnNlci9xdWVyeUZpbHRlci9lcnJvci1tZXNzYWdlLXBhcnNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFFQSxNQUFNLENBQUMsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLENBQWUsRUFBRSxFQUFFO0lBQ2xELE9BQU8saUJBQWlCLENBQUMsQ0FBQyxPQUFPLDBCQUEwQixDQUFDO0FBQzlELENBQUMsQ0FBQztBQUVGLE1BQU0sQ0FBQyxNQUFNLGlCQUFpQixHQUFHLENBQUMsQ0FBd0IsRUFBRSxFQUFFOztJQUM1RCxJQUFJLENBQUM7UUFDSCxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLENBQUMsVUFBVSxDQUFDLDhCQUE4QixDQUFDLEVBQUUsQ0FBQztZQUN2RSxNQUFNLGFBQWEsR0FDakIsMkVBQTJFLENBQUM7WUFDOUUsTUFBTSxNQUFNLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDOUMsTUFBTSxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUNoRCxRQUFRLFdBQVcsRUFBRSxDQUFDO2dCQUNwQixLQUFLLFVBQVUsQ0FBQyxDQUFDLENBQUM7b0JBQ2hCLE9BQU8sK0JBQStCLEtBQUssbUZBQW1GLENBQUM7Z0JBQ2pJLENBQUM7Z0JBQ0QsS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDO29CQUNqQixPQUFPLHlFQUF5RSxLQUFLLEdBQUcsQ0FBQztnQkFDM0YsQ0FBQztnQkFDRCxPQUFPLENBQUMsQ0FBQyxDQUFDO29CQUNSLE9BQU8sK0JBQStCLEtBQUssd0JBQXdCLENBQUM7Z0JBQ3RFLENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQzthQUFNLElBQ0wsQ0FBQyxDQUFDLE9BQU87YUFDTixXQUFXLEVBQUU7YUFDYixVQUFVLENBQUMsbURBQW1ELENBQUMsRUFDbEUsQ0FBQztZQUNELE1BQU0sV0FBVyxHQUFHLHdCQUF3QixDQUFDO1lBQzdDLE1BQU0sVUFBVSxHQUFHLDRCQUE0QixDQUFDO1lBQ2hELE1BQU0sWUFBWSxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzNDLE1BQU0sT0FBTyxHQUFHLFlBQVk7aUJBQ3pCLEtBQUssQ0FBQyxDQUFDLEVBQUUsWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7aUJBQ2pDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3ZDLE1BQU0sS0FBSyxHQUFHLFlBQVk7aUJBQ3ZCLEtBQUssQ0FBQyxZQUFZLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztpQkFDakMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3hCLElBQ0UsQ0FBQSxNQUFBLE1BQUEsQ0FBQyxDQUFDLEtBQUssMENBQUUsU0FBUywwQ0FBRSxJQUFJLE1BQUssWUFBWTtnQkFDekMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxLQUFLLG1CQUFtQixDQUFDLEVBQzlDLENBQUM7Z0JBQ0QsT0FBTywwRkFBMEYsQ0FBQztZQUNwRyxDQUFDO1lBQ0QsSUFBSSxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEtBQUssY0FBYyxJQUFJLENBQUMsS0FBSyxhQUFhLENBQUMsRUFBRSxDQUFDO2dCQUNyRSxPQUFPLHFHQUFxRyxLQUFLLEdBQUcsQ0FBQztZQUN2SCxDQUFDO1FBQ0gsQ0FBQztJQUNILENBQUM7SUFBQyxXQUFNLENBQUM7UUFDUCxlQUFlO0lBQ2pCLENBQUM7SUFDRCxPQUFPLENBQUMsQ0FBQyxPQUFPLENBQUM7QUFDbkIsQ0FBQyxDQUFDIn0=