import { InvalidFilterError } from '../../../lib/error/invalid-filter.error';
import { parseVariableAsArray, parseVariableAsString, } from '../common-cst-parser';
export const parseExpressionArguments = (cst) => {
    if (cst.children.VARIABLE) {
        return parseVariableAsArray(cst.children.VARIABLE);
    }
    return undefined;
};
export const parseMultiClause = (cst, opt) => {
    var _a;
    const result = {
        is_group: true,
        logical_op: (_a = opt === null || opt === void 0 ? void 0 : opt.logicalOperator) !== null && _a !== void 0 ? _a : 'and',
        children: [],
    };
    for (let index = 0; index < cst.children.clause.length; index++) {
        const clause = cst.children.clause[index];
        result.children.push(clause.name === 'and_or_clause'
            ? parseAndOrClause(clause)
            : clause.name === 'not_clause'
                ? parseNotClause(clause)
                : parseParenClause(clause));
    }
    return result;
};
export const parseNotClause = (cst) => {
    return parseParenClause(cst.children.clause[0], {
        logicalOperator: 'not',
    });
};
export const parseAndOrClause = (cst) => {
    if (!['~and', '~or'].includes(cst.children.operator[0].image)) {
        throw new InvalidFilterError({
            message: `Invalid filter expression. Expected a valid logical operator like '~or' or '~and', but found '${cst.children.operator[0].image}'`,
        });
    }
    return parseParenClause(cst.children.clause[0], {
        logicalOperator: cst.children.operator[0].image.replace('~', ''),
    });
};
export const parseParenClause = (cst, opt) => {
    const clause = cst.children.clause[0];
    if (clause.name === 'multi_clause') {
        return parseMultiClause(clause, opt);
    }
    else {
        return parseCallExpression(clause, opt);
    }
};
export const parseCallExpression = (cst, opt) => {
    const operator = cst.children.OPERATOR[0].image;
    const result = {
        is_group: false,
        field: parseVariableAsString(cst.children.VARIABLE),
        comparison_op: operator,
        logical_op: opt === null || opt === void 0 ? void 0 : opt.logicalOperator,
    };
    if (cst.children.expression_arguments &&
        cst.children.expression_arguments[0]) {
        const variables = parseExpressionArguments(cst.children.expression_arguments[0]);
        result.value = variables;
    }
    handleBlankOperator(result);
    handleInOperator(result);
    handleOperatorAndValue(result);
    return result;
};
const handleBlankOperator = (filter) => {
    var _a, _b;
    switch (filter.comparison_op) {
        case 'is':
            if (((_a = filter.value) === null || _a === void 0 ? void 0 : _a[0]) === 'blank') {
                filter.comparison_op = 'blank';
                filter.value = undefined;
            }
            else if (((_b = filter.value) === null || _b === void 0 ? void 0 : _b[0]) === 'notblank') {
                filter.comparison_op = 'notblank';
                filter.value = undefined;
            }
            break;
        case 'isblank':
        case 'is_blank':
            filter.comparison_op = 'blank';
            break;
        case 'isnotblank':
        case 'is_not_blank':
        case 'is_notblank':
            filter.comparison_op = 'notblank';
            break;
    }
};
const handleInOperator = (filter) => {
    var _a;
    if (filter.comparison_op === 'in' && !Array.isArray(filter.value)) {
        filter.value = (_a = filter.value) === null || _a === void 0 ? void 0 : _a.split(',');
    }
};
const handleOperatorAndValue = (filter) => {
    if (Array.isArray(filter.value) &&
        [
            'eq',
            'neq',
            'not',
            'like',
            'nlike',
            'empty',
            'notempty',
            'null',
            'notnull',
            'checked',
            'notchecked',
            'blank',
            'notblank',
            'allof',
            'anyof',
            'nallof',
            'nanyof',
            'gt',
            'lt',
            'gte',
            'lte',
            'ge',
            'le',
            'isnot',
            'is',
            'gb_eq',
        ].includes(filter.comparison_op)) {
        if (filter.value.length === filter.value.filter((k) => k === null).length) {
            filter.value = null;
        }
        else {
            filter.value = filter.value.filter((k) => k).join(',');
        }
    }
    // for equality, replace with empty string if value is undefined
    else if (filter.value === undefined &&
        ['eq', 'neq', 'gb_eq'].includes(filter.comparison_op)) {
        filter.value = '';
    }
};
export const parseCst = (cst) => {
    return parseMultiClause(cst);
};
//# sourceMappingURL=data:application/json;base64,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