import { createToken, Lexer } from 'chevrotain';
import { COMMON_TOKEN } from '../common-token';
export const GROUPBY_COMPARISON_OPS = [
    // these are used for groupby
    'gb_eq',
    'gb_null',
];
export const COMPARISON_OPS = [
    'eq',
    'neq',
    'not',
    'like',
    'nlike',
    'empty',
    'notempty',
    'null',
    'notnull',
    'checked',
    'notchecked',
    'blank',
    'notblank',
    'allof',
    'anyof',
    'nallof',
    'nanyof',
    'gt',
    'lt',
    'gte',
    'lte',
    'ge',
    'le',
    'in',
    'isnot',
    'is',
    'isWithin',
    'btw',
    'nbtw',
];
export const COMPARISON_OPS_ALIAS = [
    'isblank',
    'is_blank',
    'isnotblank',
    'is_not_blank',
    'is_notblank',
];
export const IS_WITHIN_COMPARISON_SUB_OPS = [
    'pastWeek',
    'pastMonth',
    'pastYear',
    'nextWeek',
    'nextMonth',
    'nextYear',
    'pastNumberOfDays',
    'nextNumberOfDays',
];
export const COMPARISON_SUB_OPS = [
    'today',
    'tomorrow',
    'yesterday',
    'oneWeekAgo',
    'oneWeekFromNow',
    'oneMonthAgo',
    'oneMonthFromNow',
    'daysAgo',
    'daysFromNow',
    'exactDate',
    ...IS_WITHIN_COMPARISON_SUB_OPS,
];
export const TOKEN_OPERATOR = createToken({
    name: 'OPERATOR',
    pattern: new RegExp(`\\b(${[
        ...COMPARISON_OPS,
        ...COMPARISON_OPS_ALIAS,
        ...GROUPBY_COMPARISON_OPS,
    ].join('|')})\\b`),
    longer_alt: COMMON_TOKEN.IDENTIFIER,
    categories: [COMMON_TOKEN.IDENTIFIER],
});
export const NOT_OPERATOR = createToken({
    name: 'NOT_OPERATOR',
    pattern: /~not/,
    longer_alt: COMMON_TOKEN.IDENTIFIER,
    categories: [COMMON_TOKEN.IDENTIFIER],
});
export const QUERY_FILTER_TOKENS = [
    COMMON_TOKEN.WHITESPACE_SKIP,
    TOKEN_OPERATOR,
    NOT_OPERATOR,
    COMMON_TOKEN.PAREN_START,
    COMMON_TOKEN.PAREN_END,
    COMMON_TOKEN.COMMA,
    COMMON_TOKEN.EMPTY_QUOTED_IDENTIFIER,
    COMMON_TOKEN.SUP_SGL_QUOTE_IDENTIFIER,
    COMMON_TOKEN.SUP_DBL_QUOTE_IDENTIFIER,
    COMMON_TOKEN.IDENTIFIER,
];
export const QueryFilterLexer = new Lexer(QUERY_FILTER_TOKENS);
//# sourceMappingURL=data:application/json;base64,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