export declare enum PlanLimitTypes {
    LIMIT_FREE_WORKSPACE = "limit_free_workspace",
    LIMIT_EDITOR = "limit_editor",
    LIMIT_COMMENTER = "limit_commenter",
    LIMIT_API_PER_SECOND = "limit_api_per_second",
    LIMIT_AI_TOKEN = "limit_ai_token",
    LIMIT_API_CALL = "limit_api_call",
    LIMIT_AUDIT_RETENTION = "limit_audit_retention",
    LIMIT_AUTOMATION_RUN = "limit_automation_run",
    LIMIT_AUTOMATION_RETENTION = "limit_automation_retention",
    LIMIT_WORKFLOW_RUN = "limit_workflow_run",
    LIMIT_WORKFLOW_RETENTION = "limit_workflow_retention",
    LIMIT_WEBHOOK_PER_WORKSPACE = "limit_webhook",
    LIMIT_EXTENSION_PER_WORKSPACE = "limit_extension",
    LIMIT_SNAPSHOT_PER_WORKSPACE = "limit_snapshot",
    LIMIT_STORAGE_PER_WORKSPACE = "limit_storage",
    LIMIT_RECORD_PER_WORKSPACE = "limit_record",
    LIMIT_BASE_PER_WORKSPACE = "limit_base",
    LIMIT_EXTERNAL_SOURCE_PER_WORKSPACE = "limit_external_source",
    LIMIT_TABLE_PER_BASE = "limit_table_per_base",
    LIMIT_COLUMN_PER_TABLE = "limit_column_per_table",
    LIMIT_WEBHOOK_PER_TABLE = "limit_webhook_per_table",
    LIMIT_VIEW_PER_TABLE = "limit_view_per_table",
    LIMIT_FILTER_PER_VIEW = "limit_filter_per_view",
    LIMIT_SORT_PER_VIEW = "limit_sort_per_view",
    LIMIT_ATTACHMENTS_IN_CELL = "limit_attachments_in_cell",
    LIMIT_SCRIPT_PER_WORKSPACE = "limit_script",
    LIMIT_DASHBOARD_PER_WORKSPACE = "limit_dashboard",
    LIMIT_TEAM_MANAGEMENT = "limit_team_management"
}
export declare enum PlanFeatureTypes {
    FEATURE_AI = "feature_ai",
    FEATURE_AI_INTEGRATIONS = "feature_ai_integrations",
    FEATURE_AT_MENTION = "feature_at_mention",
    FEATURE_AUDIT_WORKSPACE = "feature_audit_workspace",
    FEATURE_COMMENT_RESOLVE = "feature_comment_resolve",
    FEATURE_CUSTOM_URL = "feature_custom_url",
    FEATURE_DISCUSSION_MODE = "feature_discussion_mode",
    FEATURE_EXTENSIONS = "feature_extensions",
    FEATURE_FILE_MODE = "feature_file_mode",
    FEATURE_FORM_URL_REDIRECTION = "feature_form_url_redirection",
    FEATURE_FORM_CUSTOM_LOGO = "feature_form_custom_logo",
    FEATURE_FORM_FIELD_ON_CONDITION = "feature_form_field_on_condition",
    FEATURE_FORM_FIELD_VALIDATION = "feature_form_field_validation",
    FEATURE_GROUP_BY_AGGREGATIONS = "feature_group_by_aggregations",
    FEATURE_HIDE_BRANDING = "feature_hide_branding",
    FEATURE_LTAR_LIMIT_SELECTION_BY_FILTER = "feature_ltar_limit_selection_by_filter",
    FEATURE_LOOKUP_LIMIT_RECORDS_BY_FILTER = "feature_lookup_limit_records_by_filter",
    FEATURE_ROLLUP_LIMIT_RECORDS_BY_FILTER = "feature_rollup_limit_records_by_filter",
    FEATURE_PERSONAL_VIEWS = "feature_personal_views",
    FEATURE_SSO = "feature_sso",
    FEATURE_WEBHOOK_CUSTOM_PAYLOAD = "feature_webhook_custom_payload",
    FEATURE_WORKSPACE_CUSTOM_LOGO = "feature_workspace_custom_logo",
    FEATURE_CURRENT_USER_FILTER = "feature_current_user_filter",
    FEATURE_ROW_COLOUR = "feature_row_colour",
    FEATURE_TABLE_AND_FIELD_PERMISSIONS = "feature_table_and_field_permissions",
    FEATURE_PRIVATE_BASES = "feature_private_bases",
    FEATURE_API_MEMBER_MANAGEMENT = "feature_api_member_management",
    FEATURE_TEAM_MANAGEMENT = "feature_team_management",
    FEATURE_API_SCRIPT_MANAGEMENT = "feature_api_script_management",
    FEATURE_API_VIEW_V3 = "feature_api_view_v3",
    FEATURE_CALENDAR_RANGE = "feature_calendar_range",
    FEATURE_AI_PROMPT_FIELD = "feature_ai_prompt_field",
    FEATURE_AI_BUTTON_FIELD = "feature_ai_button_field",
    FEATURE_DUPLICATE_TABLE_TO_OTHER_BASE = "feature_duplicate_table_to_other_base",
    FEATURE_DUPLICATE_TABLE_TO_OTHER_WS = "feature_duplicate_table_to_other_ws",
    FEATURE_COPY_VIEW_SETTING_FROM_OTHER = "feature_copy_view_setting_other",
    FEATURE_CARD_FIELD_HEADER_VISIBILITY = "feature_card_field_header_visibility",
    FEATURE_SYNC = "feature_sync",
    FEATURE_UNIQUE = "feature_unique"
}
export declare enum PlanTitles {
    FREE = "Free",
    PLUS = "Plus",
    BUSINESS = "Business",
    ENTERPRISE = "Enterprise"
}
export declare enum OnPremPlanTitles {
    ENTERPRISE_STARTER = "EnterpriseStarter",
    ENTERPRISE = "Enterprise"
}
export declare enum PlanPriceLookupKeys {
    PLUS_MONTHLY = "plus_monthly",
    PLUS_YEARLY = "plus_yearly",
    BUSINESS_MONTHLY = "business_monthly",
    BUSINESS_YEARLY = "business_yearly"
}
export declare const LoyaltyPriceLookupKeyMap: {
    plus_monthly: string;
    plus_yearly: string;
    business_monthly: string;
    business_yearly: string;
};
export declare const LoyaltyPriceReverseLookupKeyMap: {
    [x: string]: PlanPriceLookupKeys;
};
export declare const PlanMeta: {
    readonly Free: {
        readonly title: PlanTitles.FREE;
        readonly color: "var(--free-plan-color, #F9F9FA)";
        readonly accent: "var(--free-plan-accent, #E7E7E9)";
        readonly primary: "var(--free-plan-primary, #1F293A)";
        readonly bgLight: "var(--free-plan-bg-light, #F9F9FA)";
        readonly bgDark: "var(--free-plan-bg-dark, #F4F4F5)";
        readonly border: "var(--free-plan-border, #E7E7E9)";
        readonly chartFillColor: "var(--color-gray-500, #6A7184)";
        readonly badgeBgColor: "var(--free-plan-badge-bg-color, #F4F4F5)";
        readonly badgeTextColor: "var(--free-plan-badge-text-color, #1F293A)";
    };
    readonly Plus: {
        readonly title: PlanTitles.PLUS;
        readonly color: "var(--plus-plan-color, #EDF9FF)";
        readonly accent: "var(--plus-plan-accent, #AFE5FF)";
        readonly primary: "var(--plus-plan-primary, #207399)";
        readonly bgLight: "var(--plus-plan-bg-light, #EDF9FF)";
        readonly bgDark: "var(--plus-plan-bg-dark, #D7F2FF)";
        readonly border: "var(--plus-plan-border, #AFE5FF)";
        readonly chartFillColor: "var(--plus-plan-chart-fill-color, #207399)";
        readonly badgeBgColor: "var(--plus-plan-badge-bg-color, #D7F2FF)";
        readonly badgeTextColor: "var(--plus-plan-badge-text-color, #207399)";
    };
    readonly Business: {
        readonly title: PlanTitles.BUSINESS;
        readonly color: "var(--business-plan-color, #FAF5FF)";
        readonly accent: "var(--business-plan-accent, #FEB0E8)";
        readonly primary: "var(--business-plan-primary, #972377)";
        readonly bgLight: "var(--business-plan-bg-light, #FFEEFB)";
        readonly bgDark: "var(--business-plan-bg-dark, #FED8F4)";
        readonly border: "var(--business-plan-border, #FEB0E8)";
        readonly chartFillColor: "var(--business-plan-chart-fill-color, #972377)";
        readonly badgeBgColor: "var(--business-plan-badge-bg-color, #FED8F4)";
        readonly badgeTextColor: "var(--business-plan-badge-text-color, #972377)";
    };
    readonly Enterprise: {
        readonly title: PlanTitles.ENTERPRISE;
        readonly color: "var(--enterprise-plan-color, #FFF5EF)";
        readonly accent: "var(--enterprise-plan-accent, #663B1F)";
        readonly primary: "var(--enterprise-plan-primary, #C86827)";
        readonly bgLight: "var(--enterprise-plan-bg-light, #FFF5EF)";
        readonly bgDark: "var(--enterprise-plan-bg-dark, #FEE6D6)";
        readonly border: "var(--enterprise-plan-border, #FDCDAD)";
        readonly chartFillColor: "var(--enterprise-plan-chart-fill-color, #C86827)";
        readonly badgeBgColor: "var(--enterprise-plan-badge-bg-color, #FEE6D6)";
        readonly badgeTextColor: "var(--enterprise-plan-badge-text-color, #C86827)";
    };
};
export declare const PlanOrder: {
    Free: number;
    Plus: number;
    Business: number;
    Enterprise: number;
};
export declare const PlanOrderToPlan: Record<string, PlanTitles>;
export declare const HigherPlan: Record<string, PlanTitles>;
export declare const GRACE_PERIOD_DURATION = 14;
export declare const LOYALTY_GRACE_PERIOD_END_DATE = "2025-09-03";
export declare const SEAT_PRICE_CAP = 9;
export declare const LOYALTY_SEAT_PRICE_CAP = 4;
export declare const PlanLimitUpgradeMessages: Record<PlanLimitTypes, string>;
export declare const PlanFeatureUpgradeMessages: Record<PlanFeatureTypes, string>;
export declare const getUpgradeMessage: (limitOrFeature?: PlanLimitTypes | PlanFeatureTypes | string) => any;
export declare enum ReturnToBillingPage {
    ORG = "org",
    ACCOUNT = "account",
    WS = "ws"
}
