export var PlanLimitTypes;
(function (PlanLimitTypes) {
    PlanLimitTypes["LIMIT_FREE_WORKSPACE"] = "limit_free_workspace";
    PlanLimitTypes["LIMIT_EDITOR"] = "limit_editor";
    PlanLimitTypes["LIMIT_COMMENTER"] = "limit_commenter";
    PlanLimitTypes["LIMIT_API_PER_SECOND"] = "limit_api_per_second";
    PlanLimitTypes["LIMIT_AI_TOKEN"] = "limit_ai_token";
    PlanLimitTypes["LIMIT_API_CALL"] = "limit_api_call";
    PlanLimitTypes["LIMIT_AUDIT_RETENTION"] = "limit_audit_retention";
    PlanLimitTypes["LIMIT_AUTOMATION_RUN"] = "limit_automation_run";
    PlanLimitTypes["LIMIT_AUTOMATION_RETENTION"] = "limit_automation_retention";
    PlanLimitTypes["LIMIT_WORKFLOW_RUN"] = "limit_workflow_run";
    PlanLimitTypes["LIMIT_WORKFLOW_RETENTION"] = "limit_workflow_retention";
    PlanLimitTypes["LIMIT_WEBHOOK_PER_WORKSPACE"] = "limit_webhook";
    PlanLimitTypes["LIMIT_EXTENSION_PER_WORKSPACE"] = "limit_extension";
    PlanLimitTypes["LIMIT_SNAPSHOT_PER_WORKSPACE"] = "limit_snapshot";
    PlanLimitTypes["LIMIT_STORAGE_PER_WORKSPACE"] = "limit_storage";
    PlanLimitTypes["LIMIT_RECORD_PER_WORKSPACE"] = "limit_record";
    PlanLimitTypes["LIMIT_BASE_PER_WORKSPACE"] = "limit_base";
    PlanLimitTypes["LIMIT_EXTERNAL_SOURCE_PER_WORKSPACE"] = "limit_external_source";
    PlanLimitTypes["LIMIT_TABLE_PER_BASE"] = "limit_table_per_base";
    PlanLimitTypes["LIMIT_COLUMN_PER_TABLE"] = "limit_column_per_table";
    PlanLimitTypes["LIMIT_WEBHOOK_PER_TABLE"] = "limit_webhook_per_table";
    PlanLimitTypes["LIMIT_VIEW_PER_TABLE"] = "limit_view_per_table";
    PlanLimitTypes["LIMIT_FILTER_PER_VIEW"] = "limit_filter_per_view";
    PlanLimitTypes["LIMIT_SORT_PER_VIEW"] = "limit_sort_per_view";
    PlanLimitTypes["LIMIT_ATTACHMENTS_IN_CELL"] = "limit_attachments_in_cell";
    PlanLimitTypes["LIMIT_SCRIPT_PER_WORKSPACE"] = "limit_script";
    PlanLimitTypes["LIMIT_DASHBOARD_PER_WORKSPACE"] = "limit_dashboard";
    PlanLimitTypes["LIMIT_TEAM_MANAGEMENT"] = "limit_team_management";
})(PlanLimitTypes || (PlanLimitTypes = {}));
export var PlanFeatureTypes;
(function (PlanFeatureTypes) {
    PlanFeatureTypes["FEATURE_AI"] = "feature_ai";
    PlanFeatureTypes["FEATURE_AI_INTEGRATIONS"] = "feature_ai_integrations";
    PlanFeatureTypes["FEATURE_AT_MENTION"] = "feature_at_mention";
    PlanFeatureTypes["FEATURE_AUDIT_WORKSPACE"] = "feature_audit_workspace";
    PlanFeatureTypes["FEATURE_COMMENT_RESOLVE"] = "feature_comment_resolve";
    PlanFeatureTypes["FEATURE_CUSTOM_URL"] = "feature_custom_url";
    PlanFeatureTypes["FEATURE_DISCUSSION_MODE"] = "feature_discussion_mode";
    PlanFeatureTypes["FEATURE_EXTENSIONS"] = "feature_extensions";
    PlanFeatureTypes["FEATURE_FILE_MODE"] = "feature_file_mode";
    PlanFeatureTypes["FEATURE_FORM_URL_REDIRECTION"] = "feature_form_url_redirection";
    PlanFeatureTypes["FEATURE_FORM_CUSTOM_LOGO"] = "feature_form_custom_logo";
    PlanFeatureTypes["FEATURE_FORM_FIELD_ON_CONDITION"] = "feature_form_field_on_condition";
    PlanFeatureTypes["FEATURE_FORM_FIELD_VALIDATION"] = "feature_form_field_validation";
    PlanFeatureTypes["FEATURE_GROUP_BY_AGGREGATIONS"] = "feature_group_by_aggregations";
    PlanFeatureTypes["FEATURE_HIDE_BRANDING"] = "feature_hide_branding";
    PlanFeatureTypes["FEATURE_LTAR_LIMIT_SELECTION_BY_FILTER"] = "feature_ltar_limit_selection_by_filter";
    PlanFeatureTypes["FEATURE_LOOKUP_LIMIT_RECORDS_BY_FILTER"] = "feature_lookup_limit_records_by_filter";
    PlanFeatureTypes["FEATURE_ROLLUP_LIMIT_RECORDS_BY_FILTER"] = "feature_rollup_limit_records_by_filter";
    PlanFeatureTypes["FEATURE_PERSONAL_VIEWS"] = "feature_personal_views";
    PlanFeatureTypes["FEATURE_SSO"] = "feature_sso";
    PlanFeatureTypes["FEATURE_WEBHOOK_CUSTOM_PAYLOAD"] = "feature_webhook_custom_payload";
    PlanFeatureTypes["FEATURE_WORKSPACE_CUSTOM_LOGO"] = "feature_workspace_custom_logo";
    PlanFeatureTypes["FEATURE_CURRENT_USER_FILTER"] = "feature_current_user_filter";
    PlanFeatureTypes["FEATURE_ROW_COLOUR"] = "feature_row_colour";
    PlanFeatureTypes["FEATURE_TABLE_AND_FIELD_PERMISSIONS"] = "feature_table_and_field_permissions";
    PlanFeatureTypes["FEATURE_PRIVATE_BASES"] = "feature_private_bases";
    PlanFeatureTypes["FEATURE_API_MEMBER_MANAGEMENT"] = "feature_api_member_management";
    PlanFeatureTypes["FEATURE_TEAM_MANAGEMENT"] = "feature_team_management";
    PlanFeatureTypes["FEATURE_API_SCRIPT_MANAGEMENT"] = "feature_api_script_management";
    PlanFeatureTypes["FEATURE_API_VIEW_V3"] = "feature_api_view_v3";
    PlanFeatureTypes["FEATURE_CALENDAR_RANGE"] = "feature_calendar_range";
    PlanFeatureTypes["FEATURE_AI_PROMPT_FIELD"] = "feature_ai_prompt_field";
    PlanFeatureTypes["FEATURE_AI_BUTTON_FIELD"] = "feature_ai_button_field";
    PlanFeatureTypes["FEATURE_DUPLICATE_TABLE_TO_OTHER_BASE"] = "feature_duplicate_table_to_other_base";
    PlanFeatureTypes["FEATURE_DUPLICATE_TABLE_TO_OTHER_WS"] = "feature_duplicate_table_to_other_ws";
    PlanFeatureTypes["FEATURE_COPY_VIEW_SETTING_FROM_OTHER"] = "feature_copy_view_setting_other";
    PlanFeatureTypes["FEATURE_CARD_FIELD_HEADER_VISIBILITY"] = "feature_card_field_header_visibility";
    PlanFeatureTypes["FEATURE_SYNC"] = "feature_sync";
    PlanFeatureTypes["FEATURE_UNIQUE"] = "feature_unique";
})(PlanFeatureTypes || (PlanFeatureTypes = {}));
export var PlanTitles;
(function (PlanTitles) {
    PlanTitles["FREE"] = "Free";
    PlanTitles["PLUS"] = "Plus";
    PlanTitles["BUSINESS"] = "Business";
    PlanTitles["ENTERPRISE"] = "Enterprise";
})(PlanTitles || (PlanTitles = {}));
export var OnPremPlanTitles;
(function (OnPremPlanTitles) {
    OnPremPlanTitles["ENTERPRISE_STARTER"] = "EnterpriseStarter";
    OnPremPlanTitles["ENTERPRISE"] = "Enterprise";
})(OnPremPlanTitles || (OnPremPlanTitles = {}));
export var PlanPriceLookupKeys;
(function (PlanPriceLookupKeys) {
    PlanPriceLookupKeys["PLUS_MONTHLY"] = "plus_monthly";
    PlanPriceLookupKeys["PLUS_YEARLY"] = "plus_yearly";
    PlanPriceLookupKeys["BUSINESS_MONTHLY"] = "business_monthly";
    PlanPriceLookupKeys["BUSINESS_YEARLY"] = "business_yearly";
})(PlanPriceLookupKeys || (PlanPriceLookupKeys = {}));
export const LoyaltyPriceLookupKeyMap = {
    [PlanPriceLookupKeys.PLUS_MONTHLY]: 'loyalty_plus_monthly',
    [PlanPriceLookupKeys.PLUS_YEARLY]: 'loyalty_plus_yearly',
    [PlanPriceLookupKeys.BUSINESS_MONTHLY]: 'loyalty_business_monthly',
    [PlanPriceLookupKeys.BUSINESS_YEARLY]: 'loyalty_business_yearly',
};
export const LoyaltyPriceReverseLookupKeyMap = {
    [LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.PLUS_MONTHLY]]: PlanPriceLookupKeys.PLUS_MONTHLY,
    [LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.PLUS_YEARLY]]: PlanPriceLookupKeys.PLUS_YEARLY,
    [LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.BUSINESS_MONTHLY]]: PlanPriceLookupKeys.BUSINESS_MONTHLY,
    [LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.BUSINESS_YEARLY]]: PlanPriceLookupKeys.BUSINESS_YEARLY,
};
export const PlanMeta = {
    [PlanTitles.FREE]: {
        title: PlanTitles.FREE,
        color: 'var(--free-plan-color, #F9F9FA)',
        accent: 'var(--free-plan-accent, #E7E7E9)',
        primary: 'var(--free-plan-primary, #1F293A)',
        bgLight: 'var(--free-plan-bg-light, #F9F9FA)',
        bgDark: 'var(--free-plan-bg-dark, #F4F4F5)',
        border: 'var(--free-plan-border, #E7E7E9)',
        chartFillColor: 'var(--color-gray-500, #6A7184)',
        badgeBgColor: 'var(--free-plan-badge-bg-color, #F4F4F5)',
        badgeTextColor: 'var(--free-plan-badge-text-color, #1F293A)',
    },
    [PlanTitles.PLUS]: {
        title: PlanTitles.PLUS,
        color: 'var(--plus-plan-color, #EDF9FF)',
        accent: 'var(--plus-plan-accent, #AFE5FF)',
        primary: 'var(--plus-plan-primary, #207399)',
        bgLight: 'var(--plus-plan-bg-light, #EDF9FF)',
        bgDark: 'var(--plus-plan-bg-dark, #D7F2FF)',
        border: 'var(--plus-plan-border, #AFE5FF)',
        chartFillColor: 'var(--plus-plan-chart-fill-color, #207399)',
        badgeBgColor: 'var(--plus-plan-badge-bg-color, #D7F2FF)',
        badgeTextColor: 'var(--plus-plan-badge-text-color, #207399)',
    },
    [PlanTitles.BUSINESS]: {
        title: PlanTitles.BUSINESS,
        color: 'var(--business-plan-color, #FAF5FF)',
        accent: 'var(--business-plan-accent, #FEB0E8)',
        primary: 'var(--business-plan-primary, #972377)',
        bgLight: 'var(--business-plan-bg-light, #FFEEFB)',
        bgDark: 'var(--business-plan-bg-dark, #FED8F4)',
        border: 'var(--business-plan-border, #FEB0E8)',
        chartFillColor: 'var(--business-plan-chart-fill-color, #972377)',
        badgeBgColor: 'var(--business-plan-badge-bg-color, #FED8F4)',
        badgeTextColor: 'var(--business-plan-badge-text-color, #972377)',
    },
    [PlanTitles.ENTERPRISE]: {
        title: PlanTitles.ENTERPRISE,
        color: 'var(--enterprise-plan-color, #FFF5EF)',
        accent: 'var(--enterprise-plan-accent, #663B1F)',
        primary: 'var(--enterprise-plan-primary, #C86827)',
        bgLight: 'var(--enterprise-plan-bg-light, #FFF5EF)',
        bgDark: 'var(--enterprise-plan-bg-dark, #FEE6D6)',
        border: 'var(--enterprise-plan-border, #FDCDAD)',
        chartFillColor: 'var(--enterprise-plan-chart-fill-color, #C86827)',
        badgeBgColor: 'var(--enterprise-plan-badge-bg-color, #FEE6D6)',
        badgeTextColor: 'var(--enterprise-plan-badge-text-color, #C86827)',
    },
};
export const PlanOrder = {
    [PlanTitles.FREE]: 0,
    [PlanTitles.PLUS]: 1,
    [PlanTitles.BUSINESS]: 2,
    [PlanTitles.ENTERPRISE]: 3,
};
export const PlanOrderToPlan = Object.entries(PlanOrder).reduce((acc, [plan, order]) => {
    acc[order] = plan;
    return acc;
}, {});
export const HigherPlan = {
    [PlanTitles.FREE]: PlanTitles.PLUS,
    [PlanTitles.PLUS]: PlanTitles.BUSINESS,
    [PlanTitles.BUSINESS]: PlanTitles.ENTERPRISE,
};
export const GRACE_PERIOD_DURATION = 14;
export const LOYALTY_GRACE_PERIOD_END_DATE = '2025-09-03';
export const SEAT_PRICE_CAP = 9;
export const LOYALTY_SEAT_PRICE_CAP = 4;
export const PlanLimitUpgradeMessages = {
    [PlanLimitTypes.LIMIT_FREE_WORKSPACE]: 'to add more workspaces.',
    [PlanLimitTypes.LIMIT_EDITOR]: 'to add more editors.',
    [PlanLimitTypes.LIMIT_COMMENTER]: 'to add more commenters.',
    [PlanLimitTypes.LIMIT_API_PER_SECOND]: 'due to reaching the API per second limit.',
    [PlanLimitTypes.LIMIT_AI_TOKEN]: 'due to reaching the AI token usage limit.',
    [PlanLimitTypes.LIMIT_API_CALL]: 'due to reaching the API call limit.',
    [PlanLimitTypes.LIMIT_AUDIT_RETENTION]: 'to increase audit retention.',
    [PlanLimitTypes.LIMIT_AUTOMATION_RUN]: 'to run more automations.',
    [PlanLimitTypes.LIMIT_AUTOMATION_RETENTION]: 'to increase automation retention.',
    [PlanLimitTypes.LIMIT_WEBHOOK_PER_WORKSPACE]: 'to add more webhooks.',
    [PlanLimitTypes.LIMIT_EXTENSION_PER_WORKSPACE]: 'to add more extensions.',
    [PlanLimitTypes.LIMIT_SNAPSHOT_PER_WORKSPACE]: 'due to reaching the snapshot limit.',
    [PlanLimitTypes.LIMIT_STORAGE_PER_WORKSPACE]: 'due to reaching the storage limit.',
    [PlanLimitTypes.LIMIT_RECORD_PER_WORKSPACE]: 'as the record limit has been reached.',
    [PlanLimitTypes.LIMIT_BASE_PER_WORKSPACE]: 'to add more bases.',
    [PlanLimitTypes.LIMIT_EXTERNAL_SOURCE_PER_WORKSPACE]: 'to connect more external sources.',
    [PlanLimitTypes.LIMIT_TABLE_PER_BASE]: 'to add more tables in a base.',
    [PlanLimitTypes.LIMIT_COLUMN_PER_TABLE]: 'to add more columns in a table.',
    [PlanLimitTypes.LIMIT_WEBHOOK_PER_TABLE]: 'to add more table-level webhooks.',
    [PlanLimitTypes.LIMIT_VIEW_PER_TABLE]: 'to add more views in a table.',
    [PlanLimitTypes.LIMIT_FILTER_PER_VIEW]: 'to add more filters in a view.',
    [PlanLimitTypes.LIMIT_SORT_PER_VIEW]: 'to add more sort rules in a view.',
    [PlanLimitTypes.LIMIT_ATTACHMENTS_IN_CELL]: 'to add more attachments in a cell.',
    [PlanLimitTypes.LIMIT_SCRIPT_PER_WORKSPACE]: 'to add more scripts in a workspace.',
    [PlanLimitTypes.LIMIT_DASHBOARD_PER_WORKSPACE]: 'to add more dashboards in a workspace.',
    [PlanLimitTypes.LIMIT_TEAM_MANAGEMENT]: 'to add more teams in a workspace.',
    [PlanLimitTypes.LIMIT_WORKFLOW_RUN]: 'to run more workflows.',
    [PlanLimitTypes.LIMIT_WORKFLOW_RETENTION]: 'to increase workflow logs retention.',
};
export const PlanFeatureUpgradeMessages = {
    [PlanFeatureTypes.FEATURE_AI]: 'to enable AI features.',
    [PlanFeatureTypes.FEATURE_AI_INTEGRATIONS]: 'to use AI integrations.',
    [PlanFeatureTypes.FEATURE_AT_MENTION]: 'to use @mention in comments.',
    [PlanFeatureTypes.FEATURE_AUDIT_WORKSPACE]: 'to access workspace audit logs.',
    [PlanFeatureTypes.FEATURE_COMMENT_RESOLVE]: 'to enable comment resolution.',
    [PlanFeatureTypes.FEATURE_CUSTOM_URL]: 'to use a custom URL.',
    [PlanFeatureTypes.FEATURE_DISCUSSION_MODE]: 'to use discussion mode.',
    [PlanFeatureTypes.FEATURE_EXTENSIONS]: 'to enable extensions.',
    [PlanFeatureTypes.FEATURE_FILE_MODE]: 'to enable file mode.',
    [PlanFeatureTypes.FEATURE_FORM_URL_REDIRECTION]: 'to access redirect after form submission feature',
    [PlanFeatureTypes.FEATURE_FORM_CUSTOM_LOGO]: 'to add a custom logo to forms.',
    [PlanFeatureTypes.FEATURE_FORM_FIELD_ON_CONDITION]: 'to access conditional form fields feature',
    [PlanFeatureTypes.FEATURE_FORM_FIELD_VALIDATION]: 'to access form field validation feature',
    [PlanFeatureTypes.FEATURE_GROUP_BY_AGGREGATIONS]: 'to use group-by aggregations.',
    [PlanFeatureTypes.FEATURE_HIDE_BRANDING]: 'to remove branding.',
    [PlanFeatureTypes.FEATURE_LTAR_LIMIT_SELECTION_BY_FILTER]: 'to limit row selection by filters.',
    [PlanFeatureTypes.FEATURE_LOOKUP_LIMIT_RECORDS_BY_FILTER]: 'to limit lookup records by filters.',
    [PlanFeatureTypes.FEATURE_ROLLUP_LIMIT_RECORDS_BY_FILTER]: 'to limit rollup records by filters.',
    [PlanFeatureTypes.FEATURE_PERSONAL_VIEWS]: 'to use personal views.',
    [PlanFeatureTypes.FEATURE_SSO]: 'to enable SSO (Single Sign-On).',
    [PlanFeatureTypes.FEATURE_WEBHOOK_CUSTOM_PAYLOAD]: 'to send custom webhook payloads.',
    [PlanFeatureTypes.FEATURE_WORKSPACE_CUSTOM_LOGO]: 'to upload a custom image as workspace avatar',
    [PlanFeatureTypes.FEATURE_CURRENT_USER_FILTER]: 'to filter view by current user',
    [PlanFeatureTypes.FEATURE_ROW_COLOUR]: 'to use row colouring.',
    [PlanFeatureTypes.FEATURE_TABLE_AND_FIELD_PERMISSIONS]: 'to use table and field permissions.',
    [PlanFeatureTypes.FEATURE_PRIVATE_BASES]: 'to use private bases.',
    [PlanFeatureTypes.FEATURE_API_MEMBER_MANAGEMENT]: 'to use member management api.',
    [PlanFeatureTypes.FEATURE_TEAM_MANAGEMENT]: 'to use team management.',
    [PlanFeatureTypes.FEATURE_API_VIEW_V3]: 'to use view api.',
    [PlanFeatureTypes.FEATURE_API_SCRIPT_MANAGEMENT]: 'to use script api.',
    [PlanFeatureTypes.FEATURE_CALENDAR_RANGE]: 'to visualize records in a calendar range.',
    [PlanFeatureTypes.FEATURE_AI_PROMPT_FIELD]: 'to use AI text fields.',
    [PlanFeatureTypes.FEATURE_AI_BUTTON_FIELD]: 'to use AI button fields.',
    [PlanFeatureTypes.FEATURE_DUPLICATE_TABLE_TO_OTHER_BASE]: 'to target different base when duplicate table.',
    [PlanFeatureTypes.FEATURE_DUPLICATE_TABLE_TO_OTHER_WS]: 'to target different workspace when duplicate table.',
    [PlanFeatureTypes.FEATURE_COPY_VIEW_SETTING_FROM_OTHER]: 'to copy view configuration from another view.',
    [PlanFeatureTypes.FEATURE_CARD_FIELD_HEADER_VISIBILITY]: 'to hide field headers in Gallery and Kanban views.',
    [PlanFeatureTypes.FEATURE_SYNC]: 'to use sync feature.',
    [PlanFeatureTypes.FEATURE_UNIQUE]: 'to use unique constraint.',
};
export const getUpgradeMessage = (limitOrFeature) => {
    if (!limitOrFeature)
        return '';
    if (PlanLimitUpgradeMessages[limitOrFeature]) {
        return PlanLimitUpgradeMessages[limitOrFeature];
    }
    if (PlanFeatureUpgradeMessages[limitOrFeature]) {
        return PlanFeatureUpgradeMessages[limitOrFeature];
    }
    return limitOrFeature;
};
export var ReturnToBillingPage;
(function (ReturnToBillingPage) {
    ReturnToBillingPage["ORG"] = "org";
    ReturnToBillingPage["ACCOUNT"] = "account";
    ReturnToBillingPage["WS"] = "ws";
})(ReturnToBillingPage || (ReturnToBillingPage = {}));
//# sourceMappingURL=data:application/json;base64,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