import { ProjectRoles, WorkspaceUserRoles } from '../enums';
export var PermissionKey;
(function (PermissionKey) {
    PermissionKey["TABLE_VISIBILITY"] = "TABLE_VISIBILITY";
    PermissionKey["TABLE_RECORD_ADD"] = "TABLE_RECORD_ADD";
    PermissionKey["TABLE_RECORD_DELETE"] = "TABLE_RECORD_DELETE";
    PermissionKey["RECORD_FIELD_EDIT"] = "RECORD_FIELD_EDIT";
})(PermissionKey || (PermissionKey = {}));
export var PermissionGrantedType;
(function (PermissionGrantedType) {
    PermissionGrantedType["ROLE"] = "role";
    PermissionGrantedType["USER"] = "user";
    PermissionGrantedType["NOBODY"] = "nobody";
})(PermissionGrantedType || (PermissionGrantedType = {}));
export var PermissionEntity;
(function (PermissionEntity) {
    PermissionEntity["TABLE"] = "table";
    PermissionEntity["FIELD"] = "field";
})(PermissionEntity || (PermissionEntity = {}));
export var PermissionRole;
(function (PermissionRole) {
    PermissionRole["OWNER"] = "owner";
    PermissionRole["CREATOR"] = "creator";
    PermissionRole["EDITOR"] = "editor";
    PermissionRole["COMMENTER"] = "commenter";
    PermissionRole["VIEWER"] = "viewer";
})(PermissionRole || (PermissionRole = {}));
// Permission option values used across the application
export var PermissionOptionValue;
(function (PermissionOptionValue) {
    PermissionOptionValue["VIEWERS_AND_UP"] = "viewers_and_up";
    PermissionOptionValue["COMMENTERS_AND_UP"] = "commenters_and_up";
    PermissionOptionValue["EDITORS_AND_UP"] = "editors_and_up";
    PermissionOptionValue["CREATORS_AND_UP"] = "creators_and_up";
    PermissionOptionValue["SPECIFIC_USERS"] = "specific_users";
    PermissionOptionValue["NOBODY"] = "nobody";
    PermissionOptionValue["EVERYONE"] = "everyone";
})(PermissionOptionValue || (PermissionOptionValue = {}));
export const PermissionOptions = [
    {
        value: PermissionOptionValue.CREATORS_AND_UP,
        label: 'Creators & up',
        description: 'Members with Creator or Owner role',
        icon: 'role_creator',
    },
    {
        value: PermissionOptionValue.EDITORS_AND_UP,
        label: 'Editors & up',
        description: 'Members with Editor, Creator or Owner role',
        icon: 'role_editor',
        isDefault: true,
    },
    {
        value: PermissionOptionValue.VIEWERS_AND_UP,
        label: 'Viewers and up',
        description: 'Members with Viewer, Commenter, Editor, Creator or Owner role',
        icon: 'role_viewer',
    },
    {
        value: PermissionOptionValue.SPECIFIC_USERS,
        label: 'Specific users',
        description: 'Specific set of members',
        icon: 'ncUsers',
    },
    {
        value: PermissionOptionValue.EVERYONE,
        label: 'Everyone',
        description: 'All members can access',
        icon: 'ncUsers',
        isDefault: true,
    },
    {
        value: PermissionOptionValue.NOBODY,
        label: 'Nobody',
        description: 'No one can add records',
        icon: 'role_no_access',
    },
];
export const PermissionRolePower = {
    [PermissionRole.OWNER]: 6,
    [PermissionRole.CREATOR]: 5,
    [PermissionRole.EDITOR]: 4,
    [PermissionRole.COMMENTER]: 3,
    [PermissionRole.VIEWER]: 2,
};
export const PermissionRoleMap = {
    [ProjectRoles.OWNER]: PermissionRole.OWNER,
    [ProjectRoles.CREATOR]: PermissionRole.CREATOR,
    [ProjectRoles.EDITOR]: PermissionRole.EDITOR,
    [ProjectRoles.COMMENTER]: PermissionRole.COMMENTER,
    [ProjectRoles.VIEWER]: PermissionRole.VIEWER,
    [WorkspaceUserRoles.OWNER]: PermissionRole.OWNER,
    [WorkspaceUserRoles.CREATOR]: PermissionRole.CREATOR,
    [WorkspaceUserRoles.EDITOR]: PermissionRole.EDITOR,
    [WorkspaceUserRoles.COMMENTER]: PermissionRole.COMMENTER,
    [WorkspaceUserRoles.VIEWER]: PermissionRole.VIEWER,
};
export const PermissionMeta = {
    [PermissionKey.TABLE_VISIBILITY]: {
        minimumRole: PermissionRole.VIEWER,
        label: 'Who can view table',
        description: 'can view table',
        userSelectorDescription: 'Only members selected here will be able to view and access this table.',
    },
    [PermissionKey.TABLE_RECORD_ADD]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can create records',
        description: 'can create records',
        userSelectorDescription: 'Only members selected here will be able to create records.',
    },
    [PermissionKey.TABLE_RECORD_DELETE]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can delete records',
        description: 'can delete records',
        userSelectorDescription: 'Only members selected here will be able to delete records.',
    },
    [PermissionKey.RECORD_FIELD_EDIT]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can edit data in this field',
        description: 'can edit records',
        userSelectorDescription: 'Only members selected here will be able to edit values in the {{field}} field.',
    },
};
// Utility functions for permission management
export const getPermissionOption = (value) => {
    return PermissionOptions.find((option) => option.value === value);
};
export const getPermissionLabel = (value) => {
    var _a;
    return ((_a = getPermissionOption(value)) === null || _a === void 0 ? void 0 : _a.label) || 'Editors & up';
};
export const getPermissionIcon = (value) => {
    var _a;
    return ((_a = getPermissionOption(value)) === null || _a === void 0 ? void 0 : _a.icon) || 'role_editor';
};
export const getPermissionOptionValue = (grantedType, grantedRole) => {
    if (grantedType === PermissionGrantedType.ROLE) {
        if (grantedRole === PermissionRole.VIEWER) {
            return PermissionOptionValue.VIEWERS_AND_UP;
        }
        else if (grantedRole === PermissionRole.COMMENTER) {
            return PermissionOptionValue.COMMENTERS_AND_UP;
        }
        else if (grantedRole === PermissionRole.CREATOR) {
            return PermissionOptionValue.CREATORS_AND_UP;
        }
        else {
            return PermissionOptionValue.EDITORS_AND_UP;
        }
    }
    else if (grantedType === PermissionGrantedType.USER) {
        return PermissionOptionValue.SPECIFIC_USERS;
    }
    else if (grantedType === PermissionGrantedType.NOBODY) {
        return PermissionOptionValue.NOBODY;
    }
    // Default for table visibility is everyone, for others it's editors and up
    return PermissionOptionValue.EDITORS_AND_UP;
};
//# sourceMappingURL=data:application/json;base64,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