export const REGEXSTR_ALPHABET = 'A-Za-z';
export const REGEXSTR_WHITESPACE = ' ';
export const REGEXSTR_CHINESE = '一-龠';
export const REGEXSTR_MANDARIN = REGEXSTR_CHINESE;
export const REGEXSTR_HIRA_KATA_KANA = 'ぁ-ゔァ-ヴー々〆〤ヶ';
export const REGEXSTR_JAPANESE = REGEXSTR_HIRA_KATA_KANA;
export const REGEXSTR_CYRILLIC = '\u0400-\u04FF';
export const REGEXSTR_HANGUL = ('\u1100-\u11FF\u3130-\u318F\uA960-\uA97F\uAC00-\uD7AF\uD7B0-\uD7FF');
export const REGEXSTR_KOREAN = REGEXSTR_HANGUL;
export const REGEXSTR_ARABIC = '\u0621-\u064A';
export const REGEXSTR_DEVANAGARI = '\u0900-\u097F';
export const REGEXSTR_GREEK = '\u0370-\u03FF';
export const REGEXSTR_HEBREW = '\u0590-\u05FF';
export const REGEXSTR_THAI = '\u0E00-\u0E7F';
export const REGEXSTR_TAMIL = '\u0B80-\u0BFF';
export const REGEXSTR_ARMENIAN = '\u0530-\u058F';
export const REGEXSTR_BENGALI = '\u0980-\u09FF';
export const REGEXSTR_GEORGIAN = '\u10A0-\u10FF';
export const REGEXSTR_GUJARATI = '\u0A80-\u0AFF';
export const REGEXSTR_KANNADA = '\u0C80-\u0CFF';
export const REGEXSTR_KHMER = '\u1780-\u17FF';
export const REGEXSTR_MALAYALAM = '\u0D00-\u0D7F';
export const REGEXSTR_MONGOLIAN = '\u1800-\u18AF';
export const REGEXSTR_MYANMAR = '\u1000-\u109F';
export const REGEXSTR_SINHALA = '\u0D80-\u0DFF';
export const REGEXSTR_SYRIAC = '\u0700-\u074F';
// alphabet is ommitted to prevent duplicates
export const REGEXSTR_VIETNAMESE = '\u0300-\u036F'; // Latin characters with diacritics
export const REGEXSTR_INTL_LETTER = [
    REGEXSTR_ALPHABET,
    REGEXSTR_CHINESE,
    REGEXSTR_CYRILLIC,
    REGEXSTR_HIRA_KATA_KANA,
    REGEXSTR_KOREAN,
    REGEXSTR_ARABIC,
    REGEXSTR_DEVANAGARI,
    REGEXSTR_GREEK,
    REGEXSTR_HEBREW,
    REGEXSTR_THAI,
    REGEXSTR_TAMIL,
    REGEXSTR_ARMENIAN,
    REGEXSTR_BENGALI,
    REGEXSTR_GEORGIAN,
    REGEXSTR_GUJARATI,
    REGEXSTR_KANNADA,
    REGEXSTR_KHMER,
    REGEXSTR_MALAYALAM,
    REGEXSTR_MONGOLIAN,
    REGEXSTR_MYANMAR,
    REGEXSTR_SINHALA,
    REGEXSTR_SYRIAC,
    REGEXSTR_VIETNAMESE,
].join('');
export const REGEXSTR_NUMERIC_ARABIC = '0-9';
export const REGEXSTR_IDENTIFIER_SPECIAL_CHAR = ('!@#$%^&*_+\\-=[\\]{};:\\\\|.<>/?');
export const REGEXSTR_IDENTIFIER = [
    REGEXSTR_INTL_LETTER,
    REGEXSTR_NUMERIC_ARABIC,
    REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
].join('');
export const REGEXSTR_SGL_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    '`"(),` ',
].join('');
export const REGEXSTR_DBL_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    "`'(), ",
].join('');
export const REGEXSTR_BACK_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    `'"(), `,
].join('');
export const REGEXP_ALPHABET = new RegExp(`[${REGEXSTR_ALPHABET}]*`);
export const REGEXP_CHINESE = new RegExp(`[${REGEXSTR_CHINESE}]*`);
export const REGEXP_MANDARIN = REGEXP_CHINESE;
export const REGEXP_HIRA_KATA_KANA = new RegExp(`[${REGEXSTR_HIRA_KATA_KANA}]*`);
export const REGEXP_JAPANESE = REGEXP_HIRA_KATA_KANA;
export const REGEXP_INTL_LETTER = new RegExp(`[${REGEXSTR_INTL_LETTER}]*`);
export const REGEXP_NUMBER_VALUE = /^[+-]?((\d+(\.\d*)?)|(\.\d+))$/;
//# sourceMappingURL=data:application/json;base64,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