import { REGEXSTR_ALPHABET, REGEXSTR_CHINESE, REGEXSTR_CYRILLIC, REGEXSTR_INTL_LETTER, REGEXSTR_JAPANESE, REGEXSTR_NUMERIC_ARABIC, } from './token';
describe('regex-token', () => {
    it('will test alphabet', () => {
        const testValue = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_ALPHABET}]+`))[0]).toBe('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
    });
    it('will test arabic numeral', () => {
        const testValue = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_NUMERIC_ARABIC}]+`))[0]).toBe('0123456789');
    });
    it('will test chinese letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_CHINESE}]+`))[0]).toBe('新年快乐');
    });
    it('will test japanese letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_JAPANESE}]+`))[0]).toBe('おはようございます');
    });
    it('will test cryillic letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_CYRILLIC}]+`))[0]).toBe('ЁёАя');
    });
    it('will test international letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${REGEXSTR_INTL_LETTER}]+`))[0]).toBe('新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
    });
});
//# sourceMappingURL=data:application/json;base64,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