import UITypes from '../UITypes';
import { ColumnType, IDType } from '../../lib';
import { SqlUi } from './SqlUI.types';
export declare class MysqlUi implements SqlUi {
    static getNewTableColumns(): readonly any[];
    static getNewColumn(suffix: any): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: any;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: any;
        clen: any;
        np: any;
        ns: any;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    static getDefaultLengthForDatatype(type: any): any;
    static getDefaultLengthIsDisabled(type: any): any;
    static getDefaultValueForDatatype(type: any): any;
    static getDefaultScaleForDatatype(type: any): any;
    static colPropAIDisabled(col: any, columns: any): boolean;
    static colPropUNDisabled(col: any): boolean;
    static onCheckboxChangeAI(col: any): void;
    static onCheckboxChangeAU(col: any): void;
    static showScale(columnObj: any): boolean;
    static removeUnsigned(columns: any): void;
    static columnEditable(colObj: any): boolean;
    static colPropAuDisabled(_col: any): boolean;
    static getUIType(col: any): any;
    static getAbstractType(col: any): any;
    static getDataTypeForUiType(col: {
        uidt: UITypes;
        dtxp?: string;
        colOptions?: any;
    }, idType?: IDType): any;
    static getDataTypeListForUiType(col: any, idType?: IDType): string[];
    static getUnsupportedFnList(): string[];
    static getCurrentDateDefault(col: Partial<ColumnType>): string;
    static isEqual(dataType1: string, dataType2: string): boolean;
    getNewTableColumns(): readonly any[];
    getNewColumn(suffix: string): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: null;
        clen: number;
        np: number;
        ns: number;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    getDefaultLengthForDatatype(type: string): number | string;
    getDefaultLengthIsDisabled(type: string): any;
    getDefaultValueForDatatype(type: string): any;
    getDefaultScaleForDatatype(type: any): string;
    colPropAIDisabled(col: ColumnType, columns: ColumnType[]): boolean;
    colPropUNDisabled(col: ColumnType): boolean;
    onCheckboxChangeAI(col: ColumnType): void;
    showScale(columnObj: ColumnType): boolean;
    removeUnsigned(columns: ColumnType[]): void;
    columnEditable(colObj: ColumnType): boolean;
    onCheckboxChangeAU(col: ColumnType): void;
    colPropAuDisabled(col: ColumnType): boolean;
    getAbstractType(col: ColumnType): string;
    getUIType(col: ColumnType): string;
    getDataTypeForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): any;
    getDataTypeListForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): string[];
    getUnsupportedFnList(): string[];
    getCurrentDateDefault(_col: Partial<ColumnType>): string;
    isEqual(dataType1: string, dataType2: string): boolean;
    adjustLengthAndScale(newColumn: Partial<ColumnType>, oldColumn?: ColumnType): void;
    isParsedJsonReturnType(col: ColumnType): boolean;
    get tableNameLengthLimit(): number;
}
